/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DisplayStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class DisplayStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;

    public DisplayStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(DisplayStatement displayStatement) {
        StatementValidator.validateIOTargetsContainer(displayStatement.getIOObjects(), this.problemRequestor);
        if (this.enclosingPart != null && 13 == this.enclosingPart.getKind()) {
            Expression expr;
            ITypeBinding targetBinding;
            if (this.enclosingPart.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null || this.enclosingPart.getAnnotation(EGLCORE, "BasicProgram") != null) {
                this.problemRequestor.acceptProblem((Node)displayStatement, 6551, new String[]{"display"});
            } else if (this.enclosingPart.getAnnotation(EGLUITEXT, "TextUIProgram") != null && StatementValidator.isValidBinding(targetBinding = (expr = displayStatement.getExpr()).resolveTypeBinding()) && targetBinding.getAnnotation(EGLUITEXT, "TextForm") == null) {
                this.problemRequestor.acceptProblem((Node)expr, 7502, new String[]{expr.getCanonicalString(), "display"});
            }
        }
        return false;
    }
}

