/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FieldAccessValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class RValueValidator {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IDataBinding dBinding;
    private Expression nodeForErrors;

    public RValueValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IDataBinding dBinding, Expression nodeForErrors) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.dBinding = dBinding;
        this.nodeForErrors = nodeForErrors;
    }

    public boolean validate() {
        boolean result = true;
        if (!Binding.isValidBinding(this.dBinding)) {
            return result;
        }
        if (!this.checkFunctionDelegation()) {
            result = false;
        }
        if (!this.invokeFieldAccessValidators()) {
            result = false;
        }
        return result;
    }

    private boolean invokeFieldAccessValidators() {
        boolean result = true;
        for (IAnnotationBinding ann : this.dBinding.getAnnotations()) {
            IAnnotationTypeBinding annType;
            IAnnotationTypeBinding validationProxy;
            if (!Binding.isValidBinding(ann) || !Binding.isValidBinding(ann.getType()) || !(ann.getType() instanceof IAnnotationTypeBinding) || (validationProxy = (annType = (IAnnotationTypeBinding)ann.getType()).getValidationProxy()) == null) continue;
            Iterator iter = validationProxy.getFieldAccessAnnotations().iterator();
            while (iter.hasNext()) {
                boolean bl = result = ((FieldAccessValidationAnnotationTypeBinding)iter.next()).validateRValue(this.nodeForErrors, this.dBinding, this.problemRequestor, this.compilerOptions) && result;
            }
        }
        return result;
    }

    private boolean checkFunctionDelegation() {
        boolean result = true;
        if ((20 == this.dBinding.getKind() || 21 == this.dBinding.getKind()) && ((IFunctionBinding)this.dBinding.getType()).hasConverse()) {
            this.problemRequestor.acceptProblem((Node)this.nodeForErrors, 3417, new String[]{this.dBinding.getCaseSensitiveName()});
            result = false;
        }
        if (20 == this.dBinding.getKind() && 13 == this.dBinding.getDeclaringPart().getKind() && InternUtil.intern((String)"main") == this.dBinding.getName()) {
            this.problemRequestor.acceptProblem((Node)this.nodeForErrors, 3418, new String[]{this.dBinding.getCaseSensitiveName()});
            result = false;
        }
        return result;
    }
}

