/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class PrepareStatementValidator
extends AbstractSqlStatementValidator {
    PrepareStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    FromOrToExpressionClause from;

    public PrepareStatementValidator(PrepareStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFrom();
        this.validateWith();
    }

    private void validateTarget() {
        ITypeBinding targetType = this.statement.getSqlStmt().resolveTypeBinding();
        if (Binding.isValidBinding(targetType) && !this.isSqlStatement(targetType)) {
            this.problemRequestor.acceptProblem((Node)this.statement.getSqlStmt(), 8500, new String[]{this.statement.getSqlStmt().getCanonicalString(), "eglx.persistence.sql.SQLStatement"});
            return;
        }
    }

    private void validateFrom() {
        ITypeBinding type;
        if (this.from != null && Binding.isValidBinding(type = this.from.getExpression().resolveTypeBinding()) && !this.isDataSource(type)) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLDataSource"});
            return;
        }
    }

    private void validateWith() {
        ITypeBinding type;
        if (this.withExpression != null && Binding.isValidBinding(type = this.withExpression.getExpression().resolveTypeBinding()) && (3 != type.getKind() || 19 != ((PrimitiveTypeBinding)type).getPrimitive().getType())) {
            this.problemRequestor.acceptProblem((Node)this.withExpression.getExpression(), 8500, new String[]{this.withExpression.getExpression().getCanonicalString(), "string"});
            return;
        }
    }

    private void initialize() {
        this.statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (PrepareStatementValidator.this.withInline == null && PrepareStatementValidator.this.withExpression == null) {
                    PrepareStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"prepare".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(WithExpressionClause withExpressionClause) {
                if (PrepareStatementValidator.this.withInline == null && PrepareStatementValidator.this.withExpression == null) {
                    PrepareStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"prepare".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                if (PrepareStatementValidator.this.from == null) {
                    PrepareStatementValidator.this.from = clause;
                } else {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"prepare".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }
        });
    }
}

