/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.edt.compiler.internal.io.IIOBufferWriter;

public abstract class CommonZipFileIOBufferWriter
implements IIOBufferWriter {
    private ZipOutputStream zipOutputStream;

    @Override
    public void beginWriting() throws IOException {
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(this.createOutputStream()));
    }

    @Override
    public void writeEntry(String entryName, Object value) throws IOException {
        ZipEntry newEntry = new ZipEntry(entryName);
        this.zipOutputStream.putNextEntry(newEntry);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.zipOutputStream);
        objectOutputStream.writeObject(value);
        this.zipOutputStream.flush();
    }

    @Override
    public void finishWriting() throws IOException {
        this.zipOutputStream.close();
    }

    protected abstract OutputStream createOutputStream() throws IOException;
}

