/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.mof2binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationBindingForElement;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.AnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.SystemEnumerationDataBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.binding.annotationType.StereotypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.mof2binding.EClassBinding;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EMetadataType;
import org.eclipse.edt.mof.EModelElement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.DataType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ElementAnnotations;
import org.eclipse.edt.mof.egl.ElementKind;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.FormField;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvalidName;
import org.eclipse.edt.mof.egl.MofConversion;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PatternType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.TopLevelFunctionName;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeName;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.impl.DynamicEObject;
import org.eclipse.edt.mof.serialization.ProxyEObject;

public abstract class Mof2BindingBase
extends AbstractVisitor
implements MofConversion {
    public static HashSet<String> ignoreTheseAnnotations = new HashSet();
    private static String[] MOFPACKAGE = InternUtil.intern((String[])new String[]{"egl", "lang", "reflect", "mof"});
    private static HashMap<String, String> MOF_STEREOTYPES = new HashMap();
    private static Object[] EMPTYARRAY = new Object[0];
    Stack<IBinding> stack;
    Map<EObject, IBinding> elementToBindingMap;
    Map<String, IPartBinding> partBindings;
    Map<IPartBinding, ProxyEObject> bindingToProxyMap;
    IBindingEnvironment env;
    int elementAnnotationIndex;

    public Mof2BindingBase(IBindingEnvironment env) {
        ignoreTheseAnnotations.add("EGL_Location");
        ignoreTheseAnnotations.add("abs");
        MOF_STEREOTYPES.put(InternUtil.intern((String)"MofClass"), "org.eclipse.edt.mof.EClass");
        MOF_STEREOTYPES.put(InternUtil.intern((String)"MofDataType"), "org.eclipse.edt.mof.EDataType");
        MOF_STEREOTYPES.put(InternUtil.intern((String)"MofEnum"), "org.eclipse.edt.mof.EEnum");
        this.stack = new Stack();
        this.elementToBindingMap = new HashMap<EObject, IBinding>();
        this.partBindings = new HashMap<String, IPartBinding>();
        this.bindingToProxyMap = new HashMap<IPartBinding, ProxyEObject>();
        this.elementAnnotationIndex = 0;
        this.env = env;
    }

    public boolean visit(Object obj) {
        this.stack.push(null);
        return false;
    }

    protected IPartBinding createProxyBinding(ProxyPart proxy) {
        IPartBinding binding = (IPartBinding)this.getBinding((EObject)proxy);
        if (binding == null) {
            String[] pkgName;
            String partName;
            String name = proxy.getTypeSignature();
            int index = name.lastIndexOf(".");
            if (index < 0) {
                partName = name;
                pkgName = new String[]{};
            } else {
                partName = name.substring(index + 1);
                pkgName = name.substring(0, index).split(".");
            }
            name = InternUtil.intern((String)partName);
            pkgName = InternUtil.intern((String[])pkgName);
            binding = new EClassBinding(pkgName, partName);
            this.putProxy(binding, (ProxyEObject)proxy);
            this.putBinding((EObject)proxy, binding);
        }
        return binding;
    }

    public boolean visit(GenericType type) {
        ITypeBinding elementType = null;
        if (type.getTypeArguments().isEmpty()) {
            elementType = PrimitiveTypeBinding.getInstance(Primitive.ANY);
        } else if (type.getTypeArguments().get(0) instanceof ProxyPart) {
            elementType = this.createProxyBinding((ProxyPart)type.getTypeArguments().get(0));
        } else {
            ((Type)type.getTypeArguments().get(0)).accept((EVisitor)this);
            elementType = (ITypeBinding)this.stack.pop();
        }
        this.stack.push(ArrayTypeBinding.getInstance(elementType));
        return false;
    }

    public boolean visit(SequenceType type) {
        Primitive primitive;
        ParameterizableType prim = type.getParameterizableType();
        PrimitiveTypeBinding binding = null;
        int len = 0;
        if (type.getLength() != null) {
            len = type.getLength();
        }
        if ((primitive = this.getPrimitive(prim)) != null) {
            binding = PrimitiveTypeBinding.getInstance(primitive, len);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean handleParameterizableType(ParameterizableType prim) {
        PrimitiveTypeBinding binding = null;
        Primitive primitive = this.getPrimitive(prim);
        if (primitive != null) {
            binding = PrimitiveTypeBinding.getInstance(primitive);
        }
        this.stack.push(binding);
        return false;
    }

    private Primitive getPrimitive(ParameterizableType prim) {
        String str = prim.getMofSerializationKey();
        if (str.equalsIgnoreCase("egl:eglx.lang.EDecimal")) {
            return Primitive.DECIMAL;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyBin")) {
            return Primitive.BIN;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyNum")) {
            return Primitive.NUM;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyNumc")) {
            return Primitive.NUMC;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyPacf")) {
            return Primitive.PACF;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyMonthsInterval")) {
            return Primitive.MONTHSPAN_INTERVAL;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnySecondsInterval")) {
            return Primitive.SECONDSPAN_INTERVAL;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyInterval")) {
            return Primitive.SECONDSPAN_INTERVAL;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.ETimestamp")) {
            return Primitive.TIMESTAMP;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyChar")) {
            return Primitive.CHAR;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyDBChar")) {
            return Primitive.DBCHAR;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyMBChar")) {
            return Primitive.MBCHAR;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyHex")) {
            return Primitive.HEX;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.AnyUnicode")) {
            return Primitive.UNICODE;
        }
        if (str.equalsIgnoreCase("egl:eglx.lang.EString")) {
            return Primitive.STRING;
        }
        return null;
    }

    public boolean visit(FixedPrecisionType type) {
        ParameterizableType prim = type.getParameterizableType();
        PrimitiveTypeBinding binding = null;
        Primitive primitive = this.getPrimitive(prim);
        if (primitive != null) {
            binding = PrimitiveTypeBinding.getInstance(primitive, type.getLength(), type.getDecimals());
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(PatternType type) {
        ParameterizableType prim = type.getParameterizableType();
        PrimitiveTypeBinding binding = null;
        Primitive primitive = this.getPrimitive(prim);
        if (primitive != null) {
            binding = PrimitiveTypeBinding.getInstance(primitive, type.getPattern());
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(StructPart type) {
        Primitive astPrimitive = null;
        TypeBinding binding = null;
        String key = type.getMofSerializationKey();
        if (key.equalsIgnoreCase("egl:eglx.lang.EAny")) {
            astPrimitive = Primitive.ANY;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EBigint")) {
            astPrimitive = Primitive.BIGINT;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.AnyBin")) {
            astPrimitive = Primitive.BIN;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive, ((FixedPrecisionType)type).getLength(), ((FixedPrecisionType)type).getDecimals());
        } else if (key.equalsIgnoreCase("egl:eglx.lang.AnyBlob")) {
            astPrimitive = Primitive.BLOB;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EBoolean")) {
            astPrimitive = Primitive.BOOLEAN;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.AnyClob")) {
            astPrimitive = Primitive.CLOB;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EDate")) {
            astPrimitive = Primitive.DATE;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EFloat")) {
            astPrimitive = Primitive.FLOAT;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EInt")) {
            astPrimitive = Primitive.INT;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.ENumber")) {
            astPrimitive = Primitive.NUMBER;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.ESmallint")) {
            astPrimitive = Primitive.SMALLINT;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.ESmallfloat")) {
            astPrimitive = Primitive.SMALLFLOAT;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.AnyMonthsInterval")) {
            astPrimitive = Primitive.MONTHSPAN_INTERVAL;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive, ((PatternType)type).getPattern());
        } else if (key.equalsIgnoreCase("egl:eglx.lang.ETime")) {
            astPrimitive = Primitive.TIME;
            binding = PrimitiveTypeBinding.getInstance(astPrimitive);
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EDictionary")) {
            binding = DictionaryBinding.INSTANCE;
        } else if (key.equalsIgnoreCase("egl:eglx.lang.EArrayDictionary")) {
            binding = ArrayDictionaryBinding.INSTANCE;
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(DataType type) {
        return false;
    }

    public boolean visit(EMetadataObject metadata) {
        IAnnotationBinding binding = this.createAnnotationBinding(metadata);
        this.stack.push(binding);
        return false;
    }

    public boolean visit(Annotation ann) {
        IAnnotationBinding binding = this.createAnnotationBinding(ann);
        this.stack.push(binding);
        return false;
    }

    abstract IPartBinding getPartBinding();

    public IBinding getBinding(EObject ir) {
        String name;
        IBinding binding = this.elementToBindingMap.get(ir);
        if (binding != null || !(ir instanceof Part)) {
            return binding;
        }
        Part part = (Part)ir;
        String[] packageName = InternUtil.intern((String[])part.getPackageName().split("[.]"));
        binding = this.env.getCachedPartBinding(packageName, name = InternUtil.intern((String)part.getName()));
        if (Binding.isValidBinding(binding)) {
            return binding;
        }
        return null;
    }

    public void putBinding(EObject ir, IBinding binding) {
        this.elementToBindingMap.put(ir, binding);
        if (binding instanceof IPartBinding) {
            ((IPartBinding)binding).setEnvironment(this.env);
            this.env.addPartBindingToCache((IPartBinding)binding);
        }
    }

    public IPartBinding getPartBinding(String key) {
        return this.partBindings.get(key);
    }

    public void putPartBinding(String key, IPartBinding binding) {
        this.partBindings.put(key, binding);
        if (binding instanceof IPartBinding) {
            binding.setEnvironment(this.env);
            this.env.addPartBindingToCache(binding);
        }
    }

    public ProxyEObject getProxy(IPartBinding binding) {
        return this.bindingToProxyMap.get(binding);
    }

    public void putProxy(IPartBinding binding, ProxyEObject value) {
        this.bindingToProxyMap.put(binding, value);
    }

    public void removeProxy(IPartBinding binding) {
        this.bindingToProxyMap.remove(binding);
    }

    public void handleAnnotations(Element ir, IBinding binding) {
        for (Annotation ann : ir.getAnnotations()) {
            if (this.shouldIgnore(ann)) continue;
            ann.accept((EVisitor)this);
            binding.addAnnotation((IAnnotationBinding)this.stack.pop());
        }
    }

    public void handleElementAnnotations(FormField ir, FormFieldBinding binding) {
        for (ElementAnnotations elemAnns : ir.getElementAnnotations()) {
            this.elementAnnotationIndex = elemAnns.getIndex();
            for (Annotation ann : elemAnns.getAnnotations()) {
                ann.accept((EVisitor)this);
                binding.addAnnotation((IAnnotationBinding)this.stack.pop());
            }
            this.elementAnnotationIndex = 0;
        }
    }

    public void handleElementAnnotations(StructuredField ir, StructureItemBinding binding) {
        for (ElementAnnotations elemAnns : ir.getElementAnnotations()) {
            this.elementAnnotationIndex = elemAnns.getIndex();
            for (Annotation ann : elemAnns.getAnnotations()) {
                ann.accept((EVisitor)this);
                binding.addAnnotation((IAnnotationBinding)this.stack.pop());
            }
            this.elementAnnotationIndex = 0;
        }
    }

    public void handleMetadata(EModelElement ir, IBinding binding) {
        for (EMetadataObject ann : ir.getMetadataList()) {
            ann.accept((EVisitor)this);
            binding.addAnnotation((IAnnotationBinding)this.stack.pop());
        }
    }

    private IBinding findData(IPartBinding partBinding, String id) {
        IDataBinding dataBinding = partBinding.findData(id);
        if (Binding.isValidBinding(dataBinding) && dataBinding.getKind() == 20) {
            return dataBinding.getType();
        }
        if (!Binding.isValidBinding(dataBinding) && partBinding instanceof FixedStructureBinding) {
            dataBinding = (IDataBinding)((FixedStructureBinding)partBinding).getSimpleNamesToDataBindingsMap().get(id);
        }
        return dataBinding;
    }

    private boolean isStringList(List list) {
        for (Object val : list) {
            if (val instanceof String) continue;
            return false;
        }
        return true;
    }

    private boolean isIntegerList(List list) {
        for (Object val : list) {
            if (val instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private boolean isStringArrayList(List list) {
        for (Object val : list) {
            if (val instanceof String[]) continue;
            return false;
        }
        return true;
    }

    private boolean isIntegerArrayList(List list) {
        for (Object val : list) {
            if (val instanceof Integer[]) continue;
            return false;
        }
        return true;
    }

    private Object getListValue(List list) {
        if (list.isEmpty()) {
            return EMPTYARRAY;
        }
        ArrayList<Object> convertedValues = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            convertedValues.add(this.getValue(list.get(i)));
            ++i;
        }
        if (convertedValues.get(0) instanceof IAnnotationBinding) {
            return convertedValues.toArray(new IAnnotationBinding[convertedValues.size()]);
        }
        if (this.isStringList(convertedValues)) {
            return convertedValues.toArray(new String[convertedValues.size()]);
        }
        if (this.isStringArrayList(convertedValues)) {
            return (String[][])convertedValues.toArray((T[])new String[convertedValues.size()][]);
        }
        if (this.isIntegerArrayList(convertedValues)) {
            return (Integer[][])convertedValues.toArray((T[])new Integer[convertedValues.size()][]);
        }
        if (this.isIntegerList(convertedValues)) {
            return convertedValues.toArray(new Integer[convertedValues.size()]);
        }
        return convertedValues.toArray(new Object[convertedValues.size()]);
    }

    protected Object getValue(Object value) {
        if (value instanceof InvalidName && "EZENOTFOUND".equalsIgnoreCase(((InvalidName)value).getId())) {
            return IBinding.NOT_FOUND_BINDING;
        }
        if (value instanceof java.lang.Boolean) {
            if (((java.lang.Boolean)value).booleanValue()) {
                return Boolean.YES;
            }
            return Boolean.NO;
        }
        if (value instanceof Integer[] || value instanceof Integer[][] || value instanceof int[] || value instanceof int[][] || value instanceof String[] || value instanceof String[][] || value instanceof SystemEnumerationDataBinding || value instanceof SystemEnumerationDataBinding[]) {
            return value;
        }
        if (value instanceof List) {
            return this.getListValue((List)value);
        }
        if (value instanceof TypeName) {
            ((TypeName)value).getType().accept((EVisitor)this);
            return this.stack.pop();
        }
        if (value instanceof Type) {
            ((Type)value).accept((EVisitor)this);
            return this.stack.pop();
        }
        if (value instanceof EType) {
            ((EType)value).accept((EVisitor)this);
            return this.stack.pop();
        }
        if (value instanceof TopLevelFunctionName) {
            TopLevelFunctionName tlfName = (TopLevelFunctionName)value;
            String[] pkgName = tlfName.getPackageName().split("[.]");
            return new TopLevelFunctionBinding(InternUtil.intern((String[])pkgName), tlfName.getId());
        }
        if (value instanceof Name) {
            String name = InternUtil.intern((String)((Name)value).getId());
            return this.findData(this.getPartBinding(), name);
        }
        if (value instanceof Expression) {
            return value.toString();
        }
        if (value instanceof Annotation) {
            return this.createAnnotationBinding((Annotation)value);
        }
        if (value instanceof Annotation[]) {
            Annotation[] annotations = (Annotation[])value;
            IAnnotationBinding[] annotationBindings = new IAnnotationBinding[annotations.length];
            int i = 0;
            while (i < annotationBindings.length) {
                annotationBindings[i] = this.createAnnotationBinding(annotations[i]);
                ++i;
            }
            return annotationBindings;
        }
        if (value instanceof Object[]) {
            Object[] arrVal = (Object[])value;
            if (arrVal.length > 0) {
                Object[] retValue = new Object[arrVal.length];
                int i = 0;
                while (i < arrVal.length) {
                    retValue[i] = this.getValue(arrVal[i]);
                    ++i;
                }
                return retValue;
            }
            return EMPTYARRAY;
        }
        return value;
    }

    protected IAnnotationBinding createAnnotationBinding(EMetadataObject annotation) {
        annotation.getEClass().accept((EVisitor)this);
        IPartBinding declarer = this.getPartBinding();
        AnnotationTypeBindingImpl type = new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.stack.pop(), declarer);
        AnnotationBinding binding = new AnnotationBinding(type.getName(), declarer, type, true);
        for (EField field : annotation.getEClass().getEFields()) {
            Object value = this.getValue(annotation.eGet(field));
            if (value == EMPTYARRAY) continue;
            AnnotationFieldBinding fieldBinding = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)field.getName()), declarer, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.ANY), type);
            fieldBinding.setValue(value, null, null, null, false);
            binding.addField(fieldBinding);
        }
        List annotations = annotation.getMetadataList();
        int j = 0;
        while (j < annotations.size()) {
            binding.addAnnotation(this.createAnnotationBinding((EMetadataObject)annotations.get(j)));
            ++j;
        }
        return binding;
    }

    protected IAnnotationBinding createStereotypeSubtypeFor(StereotypeType ir) {
        IAnnotationTypeBinding annType;
        IPartBinding part = (IPartBinding)this.getBinding((EObject)ir);
        IAnnotationBinding binding = this.createAnnotationSubtypeFor((EClass)ir);
        StereotypeAnnotationTypeBinding stereotypeType = StereotypeAnnotationTypeBinding.getInstance();
        AnnotationBinding stereotype = new AnnotationBinding(InternUtil.intern((String)"Stereotype"), part, stereotypeType);
        binding.addAnnotation(stereotype);
        if (ir.isReferenceType()) {
            PrimitiveTypeBinding boolType = PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN);
            IAnnotationTypeBinding annType2 = AnnotationTypeManager.getAnnotationType("Annotation");
            AnnotationFieldBinding refTypeAnn = new AnnotationFieldBinding(InternUtil.intern((String)"ReferenceType"), part, (ITypeBinding)boolType, annType2);
            refTypeAnn.setValue(Boolean.YES, null, null, null, false);
            stereotype.addField(refTypeAnn);
        }
        if (ir.getPartType() != null) {
            annType = AnnotationTypeManager.getAnnotationType("Annotation");
            AnnotationFieldBinding partTypeAnn = new AnnotationFieldBinding(InternUtil.intern((String)"partType"), part, (ITypeBinding)SystemPartManager.TYPEREF_BINDING, annType);
            ir.getPartType().accept((EVisitor)this);
            partTypeAnn.setValue(this.stack.pop(), null, null, null, false);
            stereotype.addField(partTypeAnn);
        }
        if (ir.getDefaultSuperType() != null) {
            annType = AnnotationTypeManager.getAnnotationType("Annotation");
            AnnotationFieldBinding defaultSuperTypeAnn = new AnnotationFieldBinding(InternUtil.intern((String)"defaultSuperType"), part, (ITypeBinding)SystemPartManager.TYPEREF_BINDING, annType);
            ir.getDefaultSuperType().accept((EVisitor)this);
            defaultSuperTypeAnn.setValue(this.stack.pop(), null, null, null, false);
            stereotype.addField(defaultSuperTypeAnn);
        }
        return binding;
    }

    protected IAnnotationBinding createAnnotationSubtypeFor(EClass ir) {
        EnumerationDataBinding[] list;
        FlexibleRecordBinding declarer = (FlexibleRecordBinding)this.getBinding((EObject)ir);
        IAnnotationTypeBinding annType = AnnotationTypeManager.getAnnotationType(InternUtil.intern((String)"Annotation"));
        InternUtil.intern((String)ir.getName());
        AnnotationBinding binding = new AnnotationBinding(annType.getName(), declarer, annType, true);
        for (FlexibleRecordFieldBinding field : declarer.getDeclaredFields()) {
            Object value;
            EField eField = ir.getEClass().getEField(field.getName());
            if (eField == null || (value = this.getValue(ir.eGet(eField))) == EMPTYARRAY) continue;
            AnnotationFieldBinding fieldBinding = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)field.getName()), (IPartBinding)declarer, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.ANY), annType);
            fieldBinding.setValue(value, null, null, null, false);
            binding.addField(fieldBinding);
        }
        EnumerationTypeBinding elementKind = (EnumerationTypeBinding)this.env.getPartBinding(InternUtil.intern((String[])new String[]{"egl", "core"}), InternUtil.intern((String)"ElementKind"));
        int i = 0;
        IDataBinding entry = null;
        if (ir instanceof EMetadataType) {
            list = new EnumerationDataBinding[((EMetadataType)ir).getTargets().size()];
            for (EClass eClass : ((EMetadataType)ir).getTargets()) {
                entry = eClass.getName().equals("EClass") ? elementKind.findData(ElementKind_Part) : (eClass.getName().equals("EField") ? elementKind.findData(ElementKind_FieldMbr) : (eClass.getName().equals("EFunction") ? elementKind.findData(ElementKind_FunctionMbr) : elementKind.findData(ElementKind_Part)));
                if (entry == null || entry == IBinding.NOT_FOUND_BINDING) continue;
                list[i] = (EnumerationDataBinding)entry;
                ++i;
            }
        } else {
            list = new EnumerationDataBinding[((AnnotationType)ir).getTargets().size()];
            for (ElementKind literal : ((AnnotationType)ir).getTargets()) {
                entry = elementKind.findData(InternUtil.intern((String)literal.name()));
                list[i] = (EnumerationDataBinding)entry;
                ++i;
            }
            String valProxy = ((AnnotationType)ir).getValidationProxy();
            if (valProxy != null && valProxy.trim().length() > 0) {
                PrimitiveTypeBinding stringType = PrimitiveTypeBinding.getInstance(Primitive.STRING);
                AnnotationFieldBinding proxy = new AnnotationFieldBinding(InternUtil.intern((String)"ValidationProxy"), (IPartBinding)declarer, (ITypeBinding)stringType, annType);
                proxy.setValue(valProxy, null, null, null, false);
                binding.addField(proxy);
            }
        }
        ArrayTypeBinding arrayType = ArrayTypeBinding.getInstance(elementKind);
        AnnotationFieldBinding targets = new AnnotationFieldBinding(InternUtil.intern((String)"targets"), (IPartBinding)declarer, (ITypeBinding)arrayType, annType);
        targets.setValue(list, null, null, null, false);
        binding.addField(targets);
        if (ir instanceof AnnotationType) {
            List annotations = ((AnnotationType)ir).getAnnotations();
            int j = 0;
            while (j < annotations.size()) {
                binding.addAnnotation(this.createAnnotationBinding((Annotation)annotations.get(j)));
                ++j;
            }
        }
        if (ir instanceof EMetadataType && declarer.getPackageName() == MOFPACKAGE && MOF_STEREOTYPES.keySet().contains(declarer.getName())) {
            StereotypeAnnotationTypeBinding stereotypeType = StereotypeAnnotationTypeBinding.getInstance();
            AnnotationBinding stereotype = new AnnotationBinding(InternUtil.intern((String)"Stereotype"), declarer, stereotypeType);
            binding.addAnnotation(stereotype);
            FlexibleRecordBinding rec = (FlexibleRecordBinding)this.env.getPartBinding(InternUtil.intern((String[])new String[]{"egl", "lang", "reflect"}), InternUtil.intern((String)"PartType"));
            AnnotationTypeBindingImpl partTypeType = new AnnotationTypeBindingImpl(rec, declarer);
            AnnotationBinding partType = new AnnotationBinding(InternUtil.intern((String)"PartType"), declarer, partTypeType);
            partType.setValue(MOF_STEREOTYPES.get(declarer.getName()), null, null, null, false);
            declarer.addAnnotation(partType);
        }
        return binding;
    }

    protected void addMofClassAnnotation(IPartBinding binding) {
        FlexibleRecordBinding rec = (FlexibleRecordBinding)this.env.getPartBinding(InternUtil.intern((String[])new String[]{"egl", "lang", "reflect", "mof"}), InternUtil.intern((String)"MofClass"));
        AnnotationTypeBindingImpl annType = new AnnotationTypeBindingImpl(rec, binding);
        AnnotationBinding ann = new AnnotationBinding(InternUtil.intern((String)"PartType"), binding, annType);
        binding.addAnnotation(ann);
    }

    protected IAnnotationBinding createAnnotationBinding(Annotation annotation) {
        IAnnotationTypeBinding type;
        String name = InternUtil.intern((String)annotation.getEClass().getName());
        IPartBinding declarer = null;
        if (!(annotation instanceof DynamicEObject)) {
            annotation.getEClass().accept((EVisitor)this);
            declarer = this.getPartBinding();
            type = new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.stack.pop(), declarer);
        } else {
            type = AnnotationTypeManager.getAnnotationType(name);
            if (type != null && ((AnnotationTypeBinding)type).hasSingleValue()) {
                declarer = this.getPartBinding();
            }
        }
        String typeName = annotation.getEClass().getName();
        AnnotationBinding annotationBinding = this.elementAnnotationIndex > 0 ? new AnnotationBindingForElement(InternUtil.internCaseSensitive((String)typeName), this.getPartBinding(), (ITypeBinding)type, this.elementAnnotationIndex) : new AnnotationBinding(InternUtil.internCaseSensitive((String)typeName), this.getPartBinding(), type, true);
        for (EField field : annotation.getEClass().getEFields()) {
            Object value = this.getValue(annotation.eGet(field));
            if (value == EMPTYARRAY) continue;
            AnnotationFieldBinding fieldBinding = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)field.getName()), declarer, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.ANY), type);
            fieldBinding.setValue(value, null, null, null, false);
            annotationBinding.addField(fieldBinding);
        }
        List annotations = annotation.getAnnotations();
        int j = 0;
        while (j < annotations.size()) {
            annotationBinding.addAnnotation(this.createAnnotationBinding((Annotation)annotations.get(j)));
            ++j;
        }
        return annotationBinding;
    }

    boolean shouldIgnore(Annotation ir) {
        return ignoreTheseAnnotations.contains(ir.getEClass().getName());
    }

    boolean isEGLReflectStereotype(EMetadataType type) {
        return type.getMetadata("PartType") != null;
    }
}

