/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.compile;

import java.io.File;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.compiler.BindingCompletor;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.IProcessor;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.sdk.utils.Util;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SourcePathEntry {
    private static final SourcePathEntry INSTANCE = new SourcePathEntry();
    private PartBindingCache bindingCache = new PartBindingCache();
    private IProcessor processor;
    private IEnvironment declaringEnvironment;

    private SourcePathEntry() {
    }

    public static SourcePathEntry getInstance() {
        return INSTANCE;
    }

    public int hasPart(String[] packageName, String partName) {
        return SourcePathInfo.getInstance().hasPart(packageName, partName);
    }

    public boolean hasPackage(String[] packageName) {
        return SourcePathInfo.getInstance().hasPackage(packageName);
    }

    public IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        return this.getPartBinding(packageName, partName, false);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName, boolean force) {
        IPartBinding result = null;
        result = this.processor.requestCompilationFor(packageName, partName, force);
        if (result == null) {
            result = this.bindingCache.get(packageName, partName);
        }
        return result;
    }

    public IPartBinding getOrCompilePartBinding(String[] packageName, String partName) {
        return this.getOrCompilePartBinding(packageName, partName, false);
    }

    private IPartBinding getOrCompilePartBinding(String[] packageName, String partName, boolean force) {
        IPartBinding result = null;
        result = this.getPartBinding(packageName, partName, force);
        if (result == null) {
            File declaringFile = SourcePathInfo.getInstance().getDeclaringFile(packageName, partName);
            SourcePathEntry.getInstance().getProcessor().addPart(packageName, SourcePathInfo.getInstance().getCaseSensitivePartName(packageName, Util.getFilePartName(declaringFile)));
            SourcePathEntry.getInstance().getProcessor().addPart(packageName, SourcePathInfo.getInstance().getCaseSensitivePartName(packageName, partName));
            result = this.getPartBinding(packageName, partName, force);
        }
        return result;
    }

    public IPartBinding compileLevel2Binding(String[] packageName, String caseSensitiveInternedPartName) {
        Scope scope;
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        File declaringFile = SourcePathInfo.getInstance().getDeclaringFile(packageName, caseInsensitiveInternedPartName);
        Node partAST = ASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedPartName);
        IPartBinding partBinding = new BindingCreator(this.declaringEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        if (partBinding.getKind() == 16) {
            scope = new EnvironmentScope(this.declaringEnvironment, NullDependencyRequestor.getInstance());
        } else {
            String fileName = Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.getOrCompilePartBinding(packageName, fileName, true);
            scope = new SystemScope(new FileScope(new EnvironmentScope(this.declaringEnvironment, NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, NullDependencyRequestor.getInstance()), this.declaringEnvironment.getSystemEnvironment());
        }
        BindingCompletor.getInstance().completeBinding(partAST, partBinding, scope, DefaultCompilerOptions.getInstance());
        partBinding.setEnvironment(this.declaringEnvironment);
        this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        return partBinding;
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        IPartBinding partBinding = this.bindingCache.get(packageName, caseInsensitiveInternedPartName);
        if (partBinding == null || partBinding.getKind() != kind) {
            partBinding = PartBinding.newPartBinding(kind, packageName, caseSensitiveInternedPartName);
            this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        } else {
            partBinding.clear();
        }
        return partBinding;
    }

    public long lastModified(String[] packageName, String partName) {
        File declaringFile = SourcePathInfo.getInstance().getDeclaringFile(packageName, partName);
        return declaringFile.lastModified();
    }

    public void setProcessor(IProcessor processor) {
        this.processor = processor;
    }

    public IProcessor getProcessor() {
        return this.processor;
    }

    public void setDeclaringEnvironment(IEnvironment declaringEnvironment) {
        this.declaringEnvironment = declaringEnvironment;
    }

    public void reset() {
        this.bindingCache = new PartBindingCache();
        this.processor = null;
        this.declaringEnvironment = null;
    }
}

