/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.internal.generation.GenerationBuilder;
import org.eclipse.edt.ide.core.internal.generation.GenerationQueue;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class AbstractGenerator {
    protected GenerationBuilder builder;
    protected IBuildNotifier notifier;
    protected IContainer outputLocation;
    protected HashSet processedFiles;
    protected GenerationQueue generationQueue;

    protected AbstractGenerator(GenerationBuilder builder, IBuildNotifier notifier) {
        this.builder = builder;
        this.notifier = notifier;
        this.outputLocation = ProjectBuildPathManager.getInstance().getProjectBuildPath(builder.getProject()).getOutputLocation();
        this.processedFiles = new HashSet();
        this.generationQueue = new GenerationQueue(notifier, builder.getProject());
    }

    public boolean build(IResourceDelta sourceDelta) {
        boolean abortedBuild = false;
        try {
            this.beginBuilding();
            if (sourceDelta != null && !this.processDeltas(sourceDelta)) {
                abortedBuild = true;
            }
            if (!abortedBuild) {
                this.addAdditionalParts();
                this.generationQueue.generate();
                abortedBuild = this.notifier.isAborted();
            }
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (BuildException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BuildException((Throwable)e);
        }
        return abortedBuild;
    }

    protected boolean processDeltas(IResourceDelta delta) {
        this.notifier.updateProgressDelta(0.2f);
        this.notifier.subTask(CoreIDEPluginStrings.analyzingChangedIRs);
        IResourceDelta sourceDelta = delta.findMember(this.outputLocation.getProjectRelativePath());
        if (sourceDelta != null) {
            if (sourceDelta.getKind() == 2) {
                System.out.println("ABORTING incremental build... found removed bin folder");
                return false;
            }
            int segmentCount = sourceDelta.getFullPath().segmentCount();
            IResourceDelta[] children = sourceDelta.getAffectedChildren();
            int j = 0;
            int m = children.length;
            while (j < m) {
                this.processDeltas(children[j], segmentCount);
                ++j;
            }
        }
        this.notifier.checkCancel();
        return true;
    }

    private void processDeltas(IResourceDelta sourceDelta, int segmentCount) {
        IResource resource = sourceDelta.getResource();
        block0 : switch (resource.getType()) {
            case 2: {
                switch (sourceDelta.getKind()) {
                    case 1: 
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.processDeltas(children[i], segmentCount);
                            ++i;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                String resourceName = resource.getName();
                this.processedFiles.add(resource);
                if (!IRUtils.isEGLIRFileName((String)resourceName)) break;
                switch (sourceDelta.getKind()) {
                    case 1: 
                    case 4: {
                        IPath fullPath = resource.getFullPath();
                        IPath packagePath = fullPath.removeFirstSegments(segmentCount).removeLastSegments(1);
                        this.generationQueue.addPart(InternUtil.intern((String[])Util.pathToStringArray(packagePath)), InternUtil.intern((String)fullPath.removeFileExtension().lastSegment()));
                        break block0;
                    }
                }
            }
        }
    }

    protected abstract void addAdditionalParts();

    protected void beginBuilding() {
        this.notifier.setAborted(false);
    }
}

