/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ISourceRange;

public class ASTFileInfoWriter {
    public static void writeFileInfo(IFileInfo fileInfo, IPath fileInfoPath) {
        try {
            fileInfoPath.removeLastSegments(1).toFile().mkdirs();
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileInfoPath.toFile())));
            try {
                int numLines = fileInfo.getNumberOfLines();
                dataOutputStream.writeInt(numLines);
                int i = 0;
                while (i < numLines) {
                    dataOutputStream.writeInt(fileInfo.getOffsetForLine(i));
                    ++i;
                }
                Set partNames = fileInfo.getPartNames();
                dataOutputStream.writeInt(partNames.size());
                for (String partName : partNames) {
                    dataOutputStream.writeUTF(partName);
                    dataOutputStream.writeUTF(fileInfo.getCaseSensitivePartName(partName));
                    dataOutputStream.writeInt(fileInfo.getPartType(partName));
                    ISourceRange partRange = fileInfo.getPartRange(partName);
                    dataOutputStream.writeInt(partRange.getOffset());
                    dataOutputStream.writeInt(partRange.getLength());
                    byte[] md5Key = fileInfo.getMD5Key(partName);
                    dataOutputStream.writeInt(md5Key.length);
                    dataOutputStream.write(md5Key);
                }
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new BuildException("Error writing FileInfo", (Throwable)e);
        }
    }
}

