/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.EGLElementRequestor;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.IEGLElementRequestor;
import org.eclipse.edt.ide.core.internal.model.SinglePartRequestor;
import org.eclipse.edt.ide.core.internal.model.util.PerThreadObject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public class NameLookup {
    public static final int ACCEPT_EGLFILES = 2;
    public static final int ACCEPT_PARTS = 4;
    protected IPackageFragmentRoot[] fPackageFragmentRoots = null;
    protected Map fPackageFragments;
    protected IWorkspace workspace;
    protected PerThreadObject unitsToLookInside = new PerThreadObject();

    public NameLookup(IEGLProject project) throws EGLModelException {
        this.configureFromProject(project);
    }

    protected boolean acceptPart(IPart part, int acceptFlags) {
        if (acceptFlags == 0) {
            return true;
        }
        return (acceptFlags & 4) != 0;
    }

    private void configureFromProject(IEGLProject project) throws EGLModelException {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.fPackageFragmentRoots = ((EGLProject)project).getAllPackageFragmentRoots();
        this.fPackageFragments = new HashMap();
        IPackageFragment[] frags = this.getPackageFragmentsInRoots(this.fPackageFragmentRoots, project);
        int i = 0;
        while (i < frags.length) {
            IPackageFragment fragment = frags[i];
            IPackageFragment[] entry = (IPackageFragment[])this.fPackageFragments.get(fragment.getElementName());
            if (entry == null) {
                entry = new IPackageFragment[]{fragment};
                this.fPackageFragments.put(fragment.getElementName(), entry);
            } else {
                IPackageFragment[] copy = new IPackageFragment[entry.length + 1];
                System.arraycopy(entry, 0, copy, 0, entry.length);
                copy[entry.length] = fragment;
                this.fPackageFragments.put(fragment.getElementName(), copy);
            }
            ++i;
        }
    }

    private void findAllParts(String prefix, boolean partialMatch, int acceptFlags, IEGLElementRequestor requestor) {
        int count = this.fPackageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                IEGLElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (EGLModelException eGLModelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekParts(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public IEGLFile findEGLFile(String qualifiedPartName) {
        String pkgName = "";
        String cuName = qualifiedPartName;
        int index = qualifiedPartName.lastIndexOf(46);
        if (index != -1) {
            pkgName = qualifiedPartName.substring(0, index);
            cuName = qualifiedPartName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        cuName = String.valueOf(cuName) + ".egl";
        IPackageFragment[] frags = (IPackageFragment[])this.fPackageFragments.get(pkgName);
        if (frags != null) {
            int i = 0;
            while (i < frags.length) {
                IPackageFragment frag = frags[i];
                IEGLFile cu = frag.getEGLFile(cuName);
                if (cu != null && cu.exists()) {
                    return cu;
                }
                ++i;
            }
        }
        return null;
    }

    public IPackageFragment findPackageFragment(IPath path) {
        block15: {
            IPackageFragment[] pkgs;
            IPackageFragmentRoot root;
            block16: {
                IResource possibleFragment;
                block17: {
                    if (!path.isAbsolute()) {
                        throw new IllegalArgumentException(EGLModelResources.pathMustBeAbsolute);
                    }
                    possibleFragment = this.workspace.getRoot().findMember(path);
                    if (possibleFragment != null) break block17;
                    int i = 0;
                    while (i < this.fPackageFragmentRoots.length) {
                        block14: {
                            IPath rootPath;
                            int matchingCount;
                            IPackageFragmentRoot root2 = this.fPackageFragmentRoots[i];
                            if (root2.isExternal() && (matchingCount = (rootPath = root2.getPath()).matchingFirstSegments(path)) != 0) {
                                String name = path.toOSString();
                                name = name.substring(rootPath.toOSString().length() + 1, name.length());
                                name = name.replace(File.separatorChar, '.');
                                IEGLElement[] list = null;
                                try {
                                    list = root2.getChildren();
                                }
                                catch (EGLModelException eGLModelException) {
                                    break block14;
                                }
                                int elementCount = list.length;
                                int j = 0;
                                while (j < elementCount) {
                                    IPackageFragment packageFragment = (IPackageFragment)list[j];
                                    if (this.nameMatches(name, packageFragment, false)) {
                                        return packageFragment;
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++i;
                    }
                    break block15;
                }
                IEGLElement fromFactory = EGLCore.create(possibleFragment);
                if (fromFactory == null) {
                    return null;
                }
                if (fromFactory instanceof IPackageFragment) {
                    return (IPackageFragment)fromFactory;
                }
                if (!(fromFactory instanceof IEGLProject)) break block15;
                EGLProject project = (EGLProject)fromFactory;
                IEGLPathEntry entry = project.getEGLPathEntryFor(path);
                if (entry == null) break block15;
                root = project.getPackageFragmentRoot(project.getResource());
                pkgs = (IPackageFragment[])this.fPackageFragments.get("");
                if (pkgs != null) break block16;
                return null;
            }
            try {
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getParent().equals(root)) {
                        return pkgs[i];
                    }
                    ++i;
                }
            }
            catch (EGLModelException eGLModelException) {
                return null;
            }
        }
        return null;
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        int count = this.fPackageFragmentRoots.length;
        if (partialMatch) {
            name = name.toLowerCase();
            int i = 0;
            while (i < count) {
                block11: {
                    IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                    IEGLElement[] list = null;
                    try {
                        list = root.getChildren();
                    }
                    catch (EGLModelException eGLModelException) {
                        break block11;
                    }
                    int elementCount = list.length;
                    IPackageFragment[] result = new IPackageFragment[elementCount];
                    int resultLength = 0;
                    int j = 0;
                    while (j < elementCount) {
                        IPackageFragment packageFragment = (IPackageFragment)list[j];
                        if (this.nameMatches(name, packageFragment, true)) {
                            result[resultLength++] = packageFragment;
                        }
                        ++j;
                    }
                    if (resultLength > 0) {
                        IPackageFragment[] iPackageFragmentArray = result;
                        result = new IPackageFragment[resultLength];
                        System.arraycopy(iPackageFragmentArray, 0, result, 0, resultLength);
                        return result;
                    }
                    return null;
                }
                ++i;
            }
        } else {
            IPackageFragment[] fragments = (IPackageFragment[])this.fPackageFragments.get(name);
            if (fragments != null) {
                IPackageFragment[] result = new IPackageFragment[fragments.length];
                int resultLength = 0;
                int i = 0;
                while (i < fragments.length) {
                    IPackageFragment packageFragment = fragments[i];
                    result[resultLength++] = packageFragment;
                    ++i;
                }
                if (resultLength > 0) {
                    IPackageFragment[] iPackageFragmentArray = result;
                    result = new IPackageFragment[resultLength];
                    System.arraycopy(iPackageFragmentArray, 0, result, 0, resultLength);
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    public IPart findPart(String typeName, String packageName, boolean partialMatch, int acceptFlags) {
        if (packageName == null) {
            packageName = "";
        }
        EGLElementRequestor elementRequestor = new EGLElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            IPart type = this.findPart(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots, IEGLProject project) {
        ArrayList<IEGLElement> frags = new ArrayList<IEGLElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IEGLElement[] children = root.getChildren();
                int length = children.length;
                if (length != 0) {
                    int j;
                    if (children[0].getParent().getParent().equals(project)) {
                        j = 0;
                        while (j < length) {
                            frags.add(children[j]);
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < length) {
                            frags.add(root.getPackageFragment(children[j].getElementName()));
                            ++j;
                        }
                    }
                }
            }
            catch (EGLModelException eGLModelException) {}
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IPart findPart(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SinglePartRequestor typeRequestor = new SinglePartRequestor();
        this.seekParts(name, pkg, partialMatch, acceptFlags, typeRequestor);
        IPart part = typeRequestor.getPart();
        return part;
    }

    public IPart findPart(String name, boolean partialMatch, int acceptFlags) {
        int index = name.lastIndexOf(46);
        String partName = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            partName = name;
        } else {
            packageName = name.substring(0, index);
            partName = name.substring(index + 1);
        }
        return this.findPart(partName, packageName, partialMatch, acceptFlags);
    }

    protected boolean nameMatches(String searchName, IEGLElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equalsIgnoreCase(searchName);
    }

    public void seekPackageFragments(String name, boolean partialMatch, IEGLElementRequestor requestor) {
        int count = this.fPackageFragmentRoots.length;
        String matchName = partialMatch ? name.toLowerCase() : name;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                IEGLElement[] list = null;
                try {
                    list = root.getChildren();
                }
                catch (EGLModelException eGLModelException) {
                    break block7;
                }
                int elementCount = list.length;
                int j = 0;
                while (j < elementCount) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    IPackageFragment packageFragment = (IPackageFragment)list[j];
                    if (this.nameMatches(matchName, packageFragment, partialMatch)) {
                        requestor.acceptPackageFragment(packageFragment);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void seekParts(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IEGLElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (matchName.indexOf(46) >= 0) {
            matchName = matchName.replace('.', '$');
        }
        if (pkg == null) {
            this.findAllParts(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int packageFlavor = root.getKind();
            switch (packageFlavor) {
                case 2: {
                    this.seekPartsInBinaryPackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    this.seekPartsInSourcePackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
    }

    protected void seekQualifiedMemberParts(String qualifiedName, IPart type, boolean partialMatch, IEGLElementRequestor requestor, int acceptFlags) {
        if (type == null) {
            return;
        }
        IPart[] types = null;
        try {
            types = type.getFunctions();
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
        String matchName = qualifiedName;
        int index = qualifiedName.indexOf(36);
        boolean nested = false;
        if (index != -1) {
            matchName = qualifiedName.substring(0, index);
            nested = true;
        }
        int length = types.length;
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return;
            }
            IPart memberType = types[i];
            if (this.nameMatches(matchName, memberType, partialMatch)) {
                if (nested) {
                    this.seekQualifiedMemberParts(qualifiedName.substring(index + 1, qualifiedName.length()), memberType, partialMatch, requestor, acceptFlags);
                } else if (this.acceptPart(memberType, acceptFlags)) {
                    requestor.acceptPart(memberType);
                }
            }
            ++i;
        }
    }

    protected void seekPartsInSourcePackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IEGLElementRequestor requestor) {
        IEGLFile[] eglfiles = null;
        try {
            eglfiles = pkg.getEGLFiles();
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
        int length = eglfiles.length;
        String matchName = name;
        int index = name.indexOf(36);
        if (index != -1) {
            name.substring(0, index);
        }
        int i = 0;
        while (i < length) {
            block13: {
                if (requestor.isCanceled()) {
                    return;
                }
                IEGLFile eglfile = eglfiles[i];
                IEGLFile unitToLookInside = null;
                Map workingCopies = (Map)this.unitsToLookInside.getCurrent();
                if (workingCopies != null && (unitToLookInside = (IEGLFile)workingCopies.get(eglfile)) != null) {
                    eglfile = unitToLookInside;
                    try {
                        eglfile.reconcile(true, null);
                    }
                    catch (EGLModelException e) {
                        EDTCoreIDEPlugin.getPlugin().log("NameLookup Failure", (Exception)((Object)e));
                    }
                }
                IPart[] parts = null;
                try {
                    parts = eglfile.getParts();
                }
                catch (EGLModelException eGLModelException) {
                    break block13;
                }
                int typeLength = parts.length;
                int j = 0;
                while (j < typeLength) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    IPart part = parts[j];
                    if (this.nameMatches(matchName, part, partialMatch) && this.acceptPart(part, acceptFlags)) {
                        requestor.acceptPart(part);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void seekPartsInBinaryPackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IEGLElementRequestor requestor) {
        IClassFile[] classFiles = null;
        try {
            classFiles = pkg.getClassFiles();
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
        int length = classFiles.length;
        String matchName = name;
        int i = 0;
        while (i < length) {
            block9: {
                if (requestor.isCanceled()) {
                    return;
                }
                IClassFile classFile = classFiles[i];
                IPart[] parts = null;
                try {
                    parts = classFile.getParts();
                }
                catch (EGLModelException eGLModelException) {
                    break block9;
                }
                int typeLength = parts.length;
                int j = 0;
                while (j < typeLength) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    IPart part = parts[j];
                    if (this.nameMatches(matchName, part, partialMatch) && this.acceptPart(part, acceptFlags)) {
                        requestor.acceptPart(part);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setUnitsToLookInside(IWorkingCopy[] unitsToLookInside) {
        if (unitsToLookInside == null) {
            this.unitsToLookInside.setCurrent(null);
        } else {
            HashMap<IWorkingCopy, IWorkingCopy> workingCopies = new HashMap<IWorkingCopy, IWorkingCopy>();
            this.unitsToLookInside.setCurrent(workingCopies);
            int i = 0;
            int length = unitsToLookInside.length;
            while (i < length) {
                IWorkingCopy unitToLookInside = unitsToLookInside[i];
                IEGLFile original = (IEGLFile)unitToLookInside.getOriginalElement();
                if (original != null) {
                    workingCopies.put(original, unitToLookInside);
                } else {
                    workingCopies.put(unitToLookInside, unitToLookInside);
                }
                ++i;
            }
        }
    }
}

