/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.model;

import com.ibm.icu.util.StringTokenizer;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;

public final class EGLConventions {
    private static final char fgDot = '.';

    private EGLConventions() {
    }

    private static int indexOfEnclosingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (!paths[i].equals((Object)checkedPath) && paths[i].isPrefixOf(checkedPath)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOfMatchingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (paths[i].equals((Object)checkedPath)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOfNestedPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (!checkedPath.equals((Object)paths[i]) && checkedPath.isPrefixOf(paths[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isOverlappingRoots(IPath rootPath1, IPath rootPath2) {
        if (rootPath1 == null || rootPath2 == null) {
            return false;
        }
        String extension1 = rootPath1.getFileExtension();
        String extension2 = rootPath2.getFileExtension();
        String jarExtension = "JAR";
        String zipExtension = "ZIP";
        if (extension1 != null && (extension1.equalsIgnoreCase(jarExtension) || extension1.equalsIgnoreCase(zipExtension))) {
            return false;
        }
        if (extension2 != null && (extension2.equalsIgnoreCase(jarExtension) || extension2.equalsIgnoreCase(zipExtension))) {
            return false;
        }
        return rootPath1.isPrefixOf(rootPath2) || rootPath2.isPrefixOf(rootPath1);
    }

    private static synchronized char[] scannedIdentifier(String id) {
        return id.toCharArray();
    }

    public static IStatus validateEGLFileName(String name) {
        if (name == null) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionUnitNullName, null);
        }
        if (!Util.isEGLFileName(name)) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionUnitNotEGLName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionUnitNotEGLName, null);
        }
        String identifier = name.substring(0, index);
        IStatus status = EGLConventions.validateIdentifier(identifier);
        if (!status.isOK()) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name) {
        return EGLConventions.validateIdentifier(name);
    }

    public static IStatus validateIdentifier(String id) {
        if (EGLConventions.scannedIdentifier(id) != null) {
            return EGLModelStatus.VERIFIED_OK;
        }
        return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.bind((String)EGLModelResources.conventionIllegalIdentifier, (Object)id), null);
    }

    public static IStatus validateImportDeclaration(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionImportNullImport, null);
        }
        if (name.charAt(name.length() - 1) == '*') {
            if (name.charAt(name.length() - 2) == '.') {
                return EGLConventions.validatePackageName(name.substring(0, name.length() - 2));
            }
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionImportUnqualifiedImport, null);
        }
        return EGLConventions.validatePackageName(name);
    }

    public static IStatus validateEGLTypeName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionTypeNullName, null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed)) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionTypeNameWithBlanks, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            scannedID = EGLConventions.scannedIdentifier(name);
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = EGLConventions.validatePackageName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + 1).trim();
            scannedID = EGLConventions.scannedIdentifier(type);
        }
        if (scannedID != null) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(scannedID), 1);
            if (!status.isOK()) {
                return status;
            }
            if (CharOperation.contains((char)'$', (char[])scannedID)) {
                return new Status(2, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionTypeDollarName, null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionTypeLowercaseName, null);
            }
            return EGLModelStatus.VERIFIED_OK;
        }
        return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.bind((String)EGLModelResources.conventionTypeInvalidName, (Object)name), null);
    }

    public static IStatus validateMethodName(String name) {
        return EGLConventions.validateIdentifier(name);
    }

    public static IStatus validatePackageName(String name) {
        if (name == null) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionPackageNullName, null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionPackageEmptyName, null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionPackageDotName, null);
        }
        if (CharOperation.isWhitespace((char)name.charAt(0)) || CharOperation.isWhitespace((char)name.charAt(name.length() - 1))) {
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionPackageNameWithBlanks, null);
        }
        int dot = 0;
        while (dot != -1 && dot < length - 1) {
            if ((dot = name.indexOf(46, dot + 1)) == -1 || dot >= length - 1 || name.charAt(dot + 1) != '.') continue;
            return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionPackageConsecutiveDotsName, null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, new String(new char[]{'.'}));
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = EGLConventions.scannedIdentifier(typeName = typeName.trim());
            if (scannedID == null) {
                return new Status(4, EGLCore.PLUGIN_ID, -1, EGLModelResources.bind((String)EGLModelResources.conventionIllegalIdentifier, (Object)typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && Character.isUpperCase(scannedID[0])) {
                return new Status(2, EGLCore.PLUGIN_ID, -1, EGLModelResources.conventionPackageUppercaseName, null);
            }
            firstToken = false;
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    public static IEGLModelStatus validateEGLPath(IEGLProject javaProject, IEGLPathEntry[] rawEGLPath, IPath projectOutputLocation) {
        IEGLPathEntry otherEntry;
        int j;
        int kind;
        IEGLPathEntry entry;
        int index;
        IEGLPathEntry resolvedEntry;
        IEGLPathEntry[] eglpath;
        IProject project = javaProject.getProject();
        IPath projectPath = project.getFullPath();
        if (projectOutputLocation == null) {
            return new EGLModelStatus(970);
        }
        if (projectOutputLocation.isAbsolute()) {
            if (!projectPath.isPrefixOf(projectOutputLocation)) {
                return new EGLModelStatus(971, (IEGLElement)javaProject, projectOutputLocation.toString());
            }
        } else {
            return new EGLModelStatus(972, projectOutputLocation);
        }
        boolean hasSource = false;
        boolean hasLibFolder = false;
        if (rawEGLPath == null) {
            return EGLModelStatus.VERIFIED_OK;
        }
        try {
            eglpath = ((EGLProject)javaProject).getResolvedEGLPath(rawEGLPath, null, true, false, null);
        }
        catch (EGLModelException e) {
            return e.getEGLModelStatus();
        }
        int length = eglpath.length;
        int outputCount = 1;
        IPath[] outputLocations = new IPath[length + 1];
        boolean[] allowNestingInOutputLocations = new boolean[length + 1];
        outputLocations[0] = projectOutputLocation;
        IPath potentialNestedOutput = null;
        int sourceEntryCount = 0;
        int i = 0;
        while (i < length) {
            resolvedEntry = eglpath[i];
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    ++sourceEntryCount;
                    IPath customOutput = resolvedEntry.getOutputLocation();
                    if (customOutput == null) break;
                    if (customOutput.isAbsolute()) {
                        if (!javaProject.getPath().isPrefixOf(customOutput)) {
                            return new EGLModelStatus(971, (IEGLElement)javaProject, customOutput.toString());
                        }
                    } else {
                        return new EGLModelStatus(972, customOutput);
                    }
                    index = EGLConventions.indexOfMatchingPath(customOutput, outputLocations, outputCount);
                    if (index != -1) break;
                    index = EGLConventions.indexOfEnclosingPath(customOutput, outputLocations, outputCount);
                    if (index != -1) {
                        if (index == 0) {
                            if (potentialNestedOutput == null) {
                                potentialNestedOutput = customOutput;
                            }
                        } else {
                            return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotNestOutputInOutput, (Object)customOutput.makeRelative().toString(), (Object)outputLocations[index].makeRelative().toString()));
                        }
                    }
                    outputLocations[outputCount++] = resolvedEntry.getOutputLocation();
                }
            }
            ++i;
        }
        if (potentialNestedOutput != null && sourceEntryCount > outputCount - 1) {
            return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotNestOutputInOutput, (Object)potentialNestedOutput.makeRelative().toString(), (Object)outputLocations[0].makeRelative().toString()));
        }
        i = 0;
        while (i < length) {
            resolvedEntry = eglpath[i];
            IPath path = resolvedEntry.getPath();
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    hasSource = true;
                    index = EGLConventions.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                    break;
                }
                case 1: {
                    hasLibFolder |= !Util.isArchiveFileName(path.lastSegment());
                    index = EGLConventions.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                }
            }
            ++i;
        }
        if (!hasSource && !hasLibFolder) {
            i = 0;
            while (i < outputCount) {
                allowNestingInOutputLocations[i] = true;
                ++i;
            }
        }
        HashMap<IPath, IEGLPathEntry> pathEntry = new HashMap<IPath, IEGLPathEntry>(length);
        int i2 = 0;
        while (i2 < length) {
            entry = eglpath[i2];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                IEGLPathEntry oldEntry = pathEntry.put(entryPath, entry);
                if (oldEntry != null && (oldEntry.isBinaryProject() && entry.isBinaryProject() || !oldEntry.isBinaryProject() && !entry.isBinaryProject())) {
                    return new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.eglpathDuplicateEntryPath, (Object)entryPath.makeRelative().toString()));
                }
                if (entryPath.equals((Object)projectPath)) {
                    if (kind == 2) {
                        return new EGLModelStatus(979, EGLModelResources.bind((String)EGLModelResources.eglpathCannotReferToItself, (Object)entryPath.makeRelative().toString()));
                    }
                } else {
                    int index2;
                    if (kind == 3 || kind == 1 && !Util.isArchiveFileName(entryPath.lastSegment())) {
                        j = 0;
                        while (j < eglpath.length) {
                            otherEntry = eglpath[j];
                            if (otherEntry != null) {
                                int otherKind = otherEntry.getEntryKind();
                                IPath otherPath = otherEntry.getPath();
                                if (entry != otherEntry && (otherKind == 3 || otherKind == 1 && !Util.isArchiveFileName(otherPath.lastSegment())) && otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath)) {
                                    char[][] exclusionPatterns = ((EGLPathEntry)otherEntry).fullExclusionPatternChars();
                                    if (!Util.isExcluded(entryPath.append("*"), exclusionPatterns)) {
                                        String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                        if (Util.isExcluded(entryPath, exclusionPatterns)) {
                                            return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathMustEndWithSlash, (Object)exclusionPattern, (Object)entryPath.makeRelative().toString()));
                                        }
                                        if (otherKind == 3) {
                                            exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                            return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotNestEntryInEntry, (Object[])new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString(), exclusionPattern}));
                                        }
                                        return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotNestEntryInLibrary, (Object[])new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()}));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if ((index2 = EGLConventions.indexOfNestedPath(entryPath, outputLocations, outputCount)) != -1) {
                        return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotNestOutputInEntry, (Object)outputLocations[index2].makeRelative().toString(), (Object)entryPath.makeRelative().toString()));
                    }
                    index2 = EGLConventions.indexOfEnclosingPath(entryPath, outputLocations, outputCount);
                    if (!(index2 == -1 || allowNestingInOutputLocations[index2] || index2 == 0 && sourceEntryCount <= outputCount - 1)) {
                        return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotNestEntryInOutput, (Object)entryPath.makeRelative().toString(), (Object)outputLocations[index2].makeRelative().toString()));
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            entry = eglpath[i2];
            if (entry != null) {
                IPath output;
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                if (kind == 3 && (output = entry.getOutputLocation()) != null) {
                    j = 0;
                    while (j < length) {
                        otherEntry = eglpath[j];
                        if (otherEntry != entry) {
                            switch (otherEntry.getEntryKind()) {
                                case 3: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotUseDistinctSourceFolderAsOutput, (Object)entryPath.makeRelative().toString(), (Object)otherEntry.getPath().makeRelative().toString()));
                                }
                                case 1: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathCannotUseLibraryAsOutput, (Object)entryPath.makeRelative().toString(), (Object)otherEntry.getPath().makeRelative().toString()));
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEGLModelStatus validateEGLPathEntry(IEGLProject javaProject, IEGLPathEntry entry, boolean checkSourceAttachment) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = entry.getPath();
        switch (entry.getEntryKind()) {
            case 5: {
                if (path == null || path.segmentCount() < 1) return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathIllegalContainerPath, (Object)path.makeRelative().toString()));
                try {
                    IEGLPathContainer container = EGLCore.getEGLPathContainer(path, javaProject);
                    if (container == null) {
                        return new EGLModelStatus(963, (IEGLElement)javaProject, path);
                    }
                    IEGLPathEntry[] containerEntries = container.getEGLPathEntries();
                    if (containerEntries == null) return EGLModelStatus.VERIFIED_OK;
                    int i = 0;
                    int length = containerEntries.length;
                    while (i < length) {
                        int kind;
                        IEGLPathEntry containerEntry = containerEntries[i];
                        int n = kind = containerEntry == null ? 0 : containerEntry.getEntryKind();
                        if (containerEntry == null || kind == 3 || kind == 4 || kind == 5) {
                            String description = container.getDescription();
                            if (description != null) return new EGLModelStatus(962, (IEGLElement)javaProject, path);
                            description = path.makeRelative().toString();
                            return new EGLModelStatus(962, (IEGLElement)javaProject, path);
                        }
                        IEGLModelStatus containerEntryStatus = EGLConventions.validateEGLPathEntry(javaProject, containerEntry, checkSourceAttachment);
                        if (!containerEntryStatus.isOK()) {
                            return containerEntryStatus;
                        }
                        ++i;
                    }
                    return EGLModelStatus.VERIFIED_OK;
                }
                catch (EGLModelException e) {
                    return new EGLModelStatus(e);
                }
            }
            case 4: {
                if (path == null || path.segmentCount() < 1) return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathIllegalVariablePath, (Object)path.makeRelative().toString()));
                if ((entry = EGLCore.getResolvedEGLPathEntry(entry)) != null) return EGLConventions.validateEGLPathEntry(javaProject, entry, checkSourceAttachment);
                return new EGLModelStatus(965, (IEGLElement)javaProject, path);
            }
            case 1: {
                if (path == null || !path.isAbsolute() || path.isEmpty() || EGLModel.getTarget((IContainer)workspaceRoot, path, true) != null) return EGLModelStatus.VERIFIED_OK;
                return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathIllegalEGLARPath, (Object)path.toString()));
            }
            case 2: {
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathIllegalProjectPath, (Object)path.segment(0).toString()));
                IProject project = workspaceRoot.getProject(path.segment(0));
                try {
                    if (!project.exists() || !project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                        return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathUnboundProject, (Object)path.makeRelative().segment(0).toString()));
                    }
                    if (project.isOpen()) return EGLModelStatus.VERIFIED_OK;
                    return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathClosedProject, (Object)path.segment(0).toString()));
                }
                catch (CoreException coreException) {
                    return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathUnboundProject, (Object)path.segment(0).toString()));
                }
            }
            case 3: {
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathIllegalSourceFolderPath, (Object)path.makeRelative().toString()));
                IPath projectPath = javaProject.getProject().getFullPath();
                if (projectPath.isPrefixOf(path) && EGLModel.getTarget((IContainer)workspaceRoot, path, true) != null) return EGLModelStatus.VERIFIED_OK;
                return new EGLModelStatus(964, EGLModelResources.bind((String)EGLModelResources.eglpathUnboundSourceFolder, (Object)path.makeRelative().toString()));
            }
        }
        return EGLModelStatus.VERIFIED_OK;
    }
}

