/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionEvent;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionParticipant;
import org.eclipse.jpt.jpa.ui.internal.views.structure.JpaStructureView;

public class JpaStructureSelectionParticipant
implements JpaSelectionParticipant {
    final JpaStructureView structureView;

    public JpaStructureSelectionParticipant(JpaSelectionManager selectionManager, JpaStructureView structureView) {
        this.structureView = structureView;
        structureView.addSelectionChangedListener(new StructureViewSelectionListener(selectionManager, structureView));
    }

    public JpaSelection getSelection() {
        return this.structureView.getJpaSelection();
    }

    public void selectionChanged(JpaSelectionEvent evt) {
        if (evt.getSource() != this) {
            this.structureView.select(evt.getSelection());
        }
    }

    public boolean disposeOnHide() {
        return false;
    }

    public void dispose() {
    }

    private class StructureViewSelectionListener
    implements ISelectionChangedListener {
        private final JpaSelectionManager selectionManager;

        StructureViewSelectionListener(JpaSelectionManager selectionManager, JpaStructureView structureView) {
            this.selectionManager = selectionManager;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (JpaStructureSelectionParticipant.this.structureView.getViewSite().getWorkbenchWindow().getPartService().getActivePart() == JpaStructureSelectionParticipant.this.structureView) {
                this.selectionManager.select(this.structureViewSelection(), JpaStructureSelectionParticipant.this);
            }
        }

        private JpaSelection structureViewSelection() {
            return JpaStructureSelectionParticipant.this.structureView.getJpaSelection();
        }
    }
}

