/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.BitSet;
import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;

public class EGLContextBoundaryUtility {
    private static final EGLContextBoundaryUtility INSTANCE = new EGLContextBoundaryUtility();
    private ErrorGrammar grammar = ErrorGrammar.getInstance();
    private BitSet boundaryStatesSet;

    public static EGLContextBoundaryUtility getInstance() {
        return INSTANCE;
    }

    public boolean isBoundaryState(int state) {
        short[] nonterminalCandidates = this.grammar.getNonTerminalCandidates(state);
        int i = 0;
        while (i < nonterminalCandidates.length) {
            if (this.getBoundarySet().get(nonterminalCandidates[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BitSet getBoundarySet() {
        if (this.boundaryStatesSet == null) {
            this.initBoundaryStatesSet();
        }
        return this.boundaryStatesSet;
    }

    private void initBoundaryStatesSet() {
        this.boundaryStatesSet = new BitSet(500);
        this.boundaryStatesSet.set(32);
        this.boundaryStatesSet.set(67);
        this.boundaryStatesSet.set(46);
        this.boundaryStatesSet.set(68);
        this.boundaryStatesSet.set(91);
        this.boundaryStatesSet.set(90);
        this.boundaryStatesSet.set(54);
        this.boundaryStatesSet.set(63);
        this.boundaryStatesSet.set(35);
        this.boundaryStatesSet.set(34);
        this.boundaryStatesSet.set(76);
        this.boundaryStatesSet.set(75);
        this.boundaryStatesSet.set(40);
        this.boundaryStatesSet.set(8);
        this.boundaryStatesSet.set(79);
        this.boundaryStatesSet.set(17);
        this.boundaryStatesSet.set(89);
        this.boundaryStatesSet.set(85);
        this.boundaryStatesSet.set(77);
        this.boundaryStatesSet.set(41);
        this.boundaryStatesSet.set(22);
        this.boundaryStatesSet.set(43);
        this.boundaryStatesSet.set(53);
        this.boundaryStatesSet.set(5);
        this.boundaryStatesSet.set(97);
        this.boundaryStatesSet.set(20);
        this.boundaryStatesSet.set(27);
        this.boundaryStatesSet.set(21);
        this.boundaryStatesSet.set(39);
        this.boundaryStatesSet.set(93);
        this.boundaryStatesSet.set(70);
        this.boundaryStatesSet.set(37);
        this.boundaryStatesSet.set(26);
        this.boundaryStatesSet.set(48);
        this.boundaryStatesSet.set(23);
        this.boundaryStatesSet.set(66);
        this.boundaryStatesSet.set(64);
        this.boundaryStatesSet.set(28);
        this.boundaryStatesSet.set(74);
        this.boundaryStatesSet.set(84);
        this.boundaryStatesSet.set(83);
        this.boundaryStatesSet.set(55);
        this.boundaryStatesSet.set(94);
    }
}

