/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLFormUseStatementProposalHandler
extends EGLAbstractProposalHandler {
    private boolean parens;
    private Node functionContainerPart;
    private String formgroupName;
    String formTypes = "form";

    public EGLFormUseStatementProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionContainerPart = boundNode.getParent();
            } else if (boundNode instanceof Part) {
                this.functionContainerPart = boundNode;
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals() {
        return this.getProposals(false, "form", false);
    }

    public List getProposals(boolean parens) {
        return this.getProposals(parens, "form", false);
    }

    public List getProposals(String formTypes) {
        return this.getProposals(false, formTypes, false);
    }

    public List getProposals(String formTypes, boolean quotes) {
        return this.getProposals(false, formTypes, quotes);
    }

    public List getProposals(boolean parens, String formTypes, boolean quotes) {
        this.parens = parens;
        this.formTypes = formTypes;
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        HashSet usedFormGroups = new HashSet();
        if (this.functionContainerPart != null) {
            this.functionContainerPart.accept((IASTVisitor)new AbstractASTPartVisitor(){

                public void visitPart(Part part) {
                    Iterator iter = part.getContents().iterator();
                    while (iter.hasNext()) {
                        ((Node)iter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(UseStatement useStatement) {
                                for (Name nextName : useStatement.getNames()) {
                                    IBinding binding = nextName.resolveBinding();
                                    if (binding == null || IBinding.NOT_FOUND_BINDING == binding || !binding.isTypeBinding()) continue;
                                    if (9 == ((ITypeBinding)binding).getKind()) {
                                        ITypeBinding cfr_ignored_0 = (ITypeBinding)binding;
                                        continue;
                                    }
                                    if (8 != ((ITypeBinding)binding).getKind() || !nextName.isQualifiedName() || (binding = ((QualifiedName)nextName).getQualifier().resolveBinding()) == null || IBinding.NOT_FOUND_BINDING == binding || 9 != ((ITypeBinding)binding).getKind()) continue;
                                    ITypeBinding cfr_ignored_1 = (ITypeBinding)binding;
                                }
                                return false;
                            }
                        });
                    }
                }
            });
        }
        for (FormGroupBinding formGroupTypeBinding : usedFormGroups) {
            this.formgroupName = formGroupTypeBinding.getCaseSensitiveName();
            List dataBindings = formGroupTypeBinding.getForms();
            for (ITypeBinding formBinding : dataBindings) {
                if (8 != formBinding.getKind() || !this.isRightFormType((FormBinding)formBinding) || !formBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                proposals.add(this.createProposal((FormBinding)formBinding, quotes));
            }
        }
        return proposals;
    }

    private boolean isRightFormType(FormBinding formBinding) {
        if (this.formTypes.equalsIgnoreCase("form")) {
            return true;
        }
        IPartSubTypeAnnotationTypeBinding subType = formBinding.getSubType();
        if (subType != null) {
            String formTypeString = subType.getName();
            return formTypeString.equalsIgnoreCase(this.formTypes);
        }
        return false;
    }

    private EGLCompletionProposal createProposal(FormBinding formBinding, boolean quotes) {
        String proposalString = this.getProposalString(formBinding, quotes);
        String displayString = formBinding.getCaseSensitiveName();
        return new EGLCompletionProposal(this.viewer, String.valueOf(displayString) + " (" + this.getPartTypeString((ITypeBinding)formBinding) + ")", proposalString, this.getAdditionalInfo(formBinding), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), this.getPartTypeImgKeyStr(this.getPartTypeString((ITypeBinding)formBinding)));
    }

    protected String getProposalString(FormBinding formBinding, boolean quotes) {
        String proposalString = this.getProposalString(formBinding.getCaseSensitiveName());
        if (quotes) {
            proposalString = "\"" + proposalString + "\"";
        }
        return proposalString;
    }

    private String getProposalString(String string) {
        if (this.parens) {
            return "(" + string + ");";
        }
        return string;
    }

    protected String getAdditionalInfo(FormBinding formBinding) {
        String formTypeString = "form".toLowerCase();
        IPartSubTypeAnnotationTypeBinding subType = formBinding.getSubType();
        if (subType != null) {
            formTypeString = subType.getCaseSensitiveName();
        }
        return MessageFormat.format(UINlsStrings.CAProposal_UseDeclarationIn, formTypeString, this.formgroupName);
    }
}

