/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards.buildpaths;

import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.core.model.PPListElementAttribute;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLElementImageDescriptor;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.viewsupport.ElementImageProvider;
import org.eclipse.edt.ide.ui.internal.viewsupport.ImageDescriptorRegistry;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;

public class PPListLabelProvider
extends LabelProvider {
    private String fNewLabel = NewWizardMessages.CPListLabelProviderNew;
    private String fCreateLabel = NewWizardMessages.CPListLabelProviderWillbecreated;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor sourceAttachment;
    private ImageDescriptorRegistry fRegistry = EDTUIPlugin.getImageDescriptorRegistry();

    public PPListLabelProvider() {
        this.fFolderImage = PluginImages.DESC_OBJS_PACKFRAG_ROOT;
        IWorkbench workbench = EDTUIPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        this.sourceAttachment = PluginImages.DESC_OBJS_SOURCE_ATTACHMENT;
    }

    public String getText(Object element) {
        if (element instanceof PPListElement) {
            return this.getCPListElementText((PPListElement)element);
        }
        if (element instanceof PPListElementAttribute) {
            return this.getCPListElementAttributeText((PPListElementAttribute)element);
        }
        return super.getText(element);
    }

    public String getCPListElementAttributeText(PPListElementAttribute attrib) {
        String notAvailable = NewWizardMessages.CPListLabelProviderNone;
        StringBuffer buf = new StringBuffer();
        String key = attrib.getKey();
        if (key.equals("sourcepath")) {
            buf.append(NewWizardMessages.CPListLabelProviderSource_attachmentLabel);
            IPath path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                if (attrib.getParent().getEntryKind() == 4) {
                    buf.append(this.getVariableString(path));
                } else {
                    buf.append(this.getPathString(path, path.getDevice() != null));
                }
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("rootpath")) {
            buf.append(NewWizardMessages.CPListLabelProviderSource_attachment_rootLabel);
            IPath path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                buf.append(path.toString());
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("javadoc")) {
            buf.append(NewWizardMessages.CPListLabelProviderjavadoc_locationlabel);
            URL path = (URL)attrib.getValue();
            if (path != null) {
                buf.append(path.toExternalForm());
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("output")) {
            buf.append(NewWizardMessages.CPListLabelProviderOutput_folderLabel);
            IPath path = (IPath)attrib.getValue();
            if (path != null) {
                buf.append(path.makeRelative().toString());
            } else {
                buf.append(NewWizardMessages.CPListLabelProviderDefault_output_folderLabel);
            }
        } else if (key.equals("exclusion")) {
            buf.append(NewWizardMessages.CPListLabelProviderExclusion_filterLabel);
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int i = 0;
                while (i < patterns.length) {
                    if (i > 0) {
                        buf.append(NewWizardMessages.CPListLabelProviderExclusion_filter_separator);
                    }
                    buf.append(patterns[i].toString());
                    ++i;
                }
            } else {
                buf.append(notAvailable);
            }
        }
        return buf.toString();
    }

    public String getCPListElementText(PPListElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource resource = cpentry.getResource();
                if ("eglar".equalsIgnoreCase(path.getFileExtension())) {
                    return this.getPathString(path, resource == null);
                }
                return path.makeRelative().toString();
            }
            case 4: {
                return this.getVariableString(path);
            }
            case 2: {
                return path.lastSegment();
            }
            case 3: {
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IResource resource = cpentry.getResource();
                if (resource != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                }
                return buf.toString();
            }
        }
        return NewWizardMessages.CPListLabelProviderUnknown_elementLabel;
    }

    private String getPathString(IPath path, boolean isExternal) {
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private String getVariableString(IPath path) {
        String name = path.makeRelative().toString();
        IPath entryPath = EGLCore.getEGLPathVariable((String)path.segment(0));
        if (entryPath != null) {
            String appended = entryPath.append(path.removeFirstSegments(1)).toOSString();
            return NewWizardMessages.bind((String)NewWizardMessages.CPListLabelProviderTwopart, (Object[])new String[]{name, appended});
        }
        return name;
    }

    private ImageDescriptor getCPListElementBaseImage(PPListElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: {
                return PluginImages.DESC_OBJS_PACKFRAG_ROOT_EGLAR;
            }
            case 2: {
                if (cpentry.getEGLPathEntry().isBinaryProject()) {
                    return PluginImages.DESC_OBJS_EGL_BINARY_PROJECT_OPEN;
                }
                return this.fProjectImage;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        String key;
        if (element instanceof PPListElement) {
            PPListElement cpentry = (PPListElement)element;
            Object imageDescriptor = this.getCPListElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                if (cpentry.isMissing()) {
                    imageDescriptor = new EGLElementImageDescriptor((ImageDescriptor)imageDescriptor, 32, ElementImageProvider.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else if (element instanceof PPListElementAttribute && (key = ((PPListElementAttribute)element).getKey()).equals("sourcepath")) {
            this.sourceAttachment = new EGLElementImageDescriptor(this.sourceAttachment, 0, ElementImageProvider.SMALL_SIZE);
            return this.fRegistry.get(this.sourceAttachment);
        }
        return null;
    }
}

