/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.java.jtopen.access;

import eglx.jtopen.IBMiConnection;
import java.util.TimeZone;
import org.eclipse.edt.javart.util.DateTimeUtil;

public class AS400DateTimeUtil {
    private static TimeZone getIBMiTimezone(IBMiConnection conn) {
        String tzStr;
        TimeZone tz = null;
        if (conn != null && (tzStr = conn.getTimezone()) != null && !tzStr.isEmpty()) {
            try {
                tz = AS400DateTimeUtil.getIBMiTimezone(tzStr);
            }
            catch (Exception exception) {}
        } else if (conn != null) {
            try {
                if (conn.getAS400() != null) {
                    tz = conn.getAS400().getTimeZone();
                }
            }
            catch (Exception exception) {}
        }
        if (tz == null) {
            tz = DateTimeUtil.getBaseCalendar().getTimeZone();
        }
        return tz;
    }

    private static TimeZone getIBMiTimezone(String timeZoneID) {
        TimeZone tz = null;
        if (timeZoneID != null && !timeZoneID.isEmpty()) {
            tz = TimeZone.getTimeZone(timeZoneID);
        }
        if (tz == null) {
            tz = DateTimeUtil.getBaseCalendar().getTimeZone();
        }
        return tz;
    }

    static TimeZone getIBMiTimezone(String timeZoneID, IBMiConnection conn) {
        return timeZoneID != null ? AS400DateTimeUtil.getIBMiTimezone(timeZoneID) : AS400DateTimeUtil.getIBMiTimezone(conn);
    }

    static String getConnSeparator(String seperator, IBMiConnection conn) {
        if (seperator != null && seperator.isEmpty()) {
            String connSeparatorChar = conn.getDateSeparatorChar();
            if (connSeparatorChar != null && "null".equalsIgnoreCase(connSeparatorChar)) {
                seperator = null;
            } else if (connSeparatorChar != null && !connSeparatorChar.isEmpty()) {
                seperator = connSeparatorChar;
            }
        }
        return seperator;
    }
}

