/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates.eglx.jtopen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;

public class CommonUtilities {
    public static void addAnntation(Member member, Annotation annot, Context ctx) {
        if (annot != null) {
            HashMap<String, Annotation> annotations = (HashMap<String, Annotation>)ctx.getAttribute((Object)member, "ibmiAnnotations");
            if (annotations == null) {
                annotations = new HashMap<String, Annotation>();
                ctx.putAttribute((Object)member, "ibmiAnnotations", annotations);
            }
            annotations.put(annot.getEClass().getETypeSignature(), annot);
        }
    }

    public static Annotation getAnnotation(Member member, String annotationSignature, Context ctx) {
        Annotation annotation = null;
        Map annotations = (Map)ctx.getAttribute((Object)member, "ibmiAnnotations");
        if (annotations != null) {
            annotation = (Annotation)annotations.get(annotationSignature);
        }
        if (annotation == null) {
            annotation = member.getAnnotation(annotationSignature);
        }
        return annotation;
    }

    public static Function createProxyFunction(Function function) {
        Function proxy = (Function)function.clone();
        proxy.setName(CommonUtilities.createProxyFunctionName(proxy));
        FunctionParameter conn = JavaTemplate.factory.createFunctionParameter();
        conn.setIsNullable(true);
        conn.setParameterKind(ParameterKind.PARM_IN);
        conn.setName("ezeIBMiConn");
        try {
            conn.setType((Type)Environment.getCurrentEnv().find("egl:eglx.jtopen.IBMiConnection"));
        }
        catch (Exception exception) {}
        proxy.addParameter(conn);
        return proxy;
    }

    public static String createProxyFunctionName(Function function) {
        return "eze_" + function.getName() + "_IBMiProxy";
    }

    public static Set<String> getGeneratedHelpers(Context ctx) {
        HashSet generatedHelpers = (HashSet)ctx.getAttribute(ctx.getClass(), "ibmiGeneratedHelpers");
        if (generatedHelpers == null) {
            generatedHelpers = new HashSet();
            ctx.putAttribute(ctx.getClass(), "ibmiGeneratedHelpers", generatedHelpers);
        }
        return generatedHelpers;
    }
}

