/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.ComponentConstructionData;
import org.eclipse.jst.jsf.designtime.internal.view.ComponentTreeConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.ViewObjectConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewObjectConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewObjectMappingService;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLComponentTreeConstructionStrategy
extends ComponentTreeConstructionStrategy<Node, IDocument> {
    private final XMLViewDefnAdapter _adapter;
    private final IProject _project;

    public XMLComponentTreeConstructionStrategy(XMLViewDefnAdapter adapter, IProject project) {
        this._adapter = adapter;
        this._project = project;
    }

    @Override
    public ComponentInfo createComponentTree(DTFacesContext context, DTUIViewRoot viewRoot) {
        IDocument container = this._adapter.getContainer(context, viewRoot.getViewId());
        List<Node> roots = this._adapter.getViewDefnRoots(container);
        if (roots.size() > 0) {
            IAdaptable adaptable = viewRoot.getServices();
            XMLViewObjectMappingService tagMappingService = null;
            if (adaptable != null) {
                tagMappingService = (XMLViewObjectMappingService)adaptable.getAdapter(XMLViewObjectMappingService.class);
            }
            XMLViewObjectConstructionStrategy objectConstructionStrategy = new XMLViewObjectConstructionStrategy(this._adapter, new ComponentConstructionData(0, null, this._project, container), tagMappingService);
            objectConstructionStrategy.getConstructionData().setIdCounter(0);
            return this.buildComponentTree(roots.get(0), viewRoot, container, objectConstructionStrategy);
        }
        return viewRoot;
    }

    private ComponentInfo buildComponentTree(Node root, DTUIViewRoot viewRoot, IDocument document, XMLViewObjectConstructionStrategy objectConstructionStrategy) {
        ComponentInfo dummyRoot = ComponentFactory.createComponentInfo(null, null, null, (boolean)true);
        this.recurseDOMModel(root, dummyRoot, document, objectConstructionStrategy);
        this.populateViewRoot(viewRoot, dummyRoot.getChildren());
        return viewRoot;
    }

    protected void populateViewRoot(DTUIViewRoot viewRoot, List children) {
        ComponentInfo foundRoot = null;
        for (ComponentInfo topLevelChild : children) {
            if (!"javax.faces.ViewRoot".equals(topLevelChild.getComponentTypeInfo().getComponentType())) continue;
            foundRoot = topLevelChild;
            break;
        }
        if (foundRoot != null) {
            for (ComponentInfo child : foundRoot.getChildren()) {
                String facetName = foundRoot.getFacetName(child);
                if (facetName == null) {
                    viewRoot.addChild(child);
                    continue;
                }
                viewRoot.addFacet(facetName, child);
            }
        }
    }

    private void recurseDOMModel(Node node, ComponentInfo parent, IDocument document, XMLViewObjectConstructionStrategy objectConstructionStrategy) {
        ViewObject mappedObject = null;
        objectConstructionStrategy.getConstructionData().setParent(parent);
        mappedObject = this._adapter.mapToViewObject(node, (ViewObjectConstructionStrategy<? extends Node>)objectConstructionStrategy, document);
        ComponentInfo newParent = parent;
        if (mappedObject instanceof ComponentInfo) {
            parent.addChild((ComponentInfo)mappedObject);
            newParent = (ComponentInfo)mappedObject;
        }
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            this.recurseDOMModel(children.item(i), newParent, document, objectConstructionStrategy);
            ++i;
        }
    }
}

