/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.testserver.AbstractTestServerContribution;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TestServerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.edt.ide.testserver";
    private static TestServerPlugin plugin;
    public static final String TEST_SERVER_CONTRIBUTION_ID = "org.eclipse.edt.ide.testserver.testServerExtension";
    private static final Object syncObj;
    private static AbstractTestServerContribution[] contributions;

    static {
        syncObj = new Object();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        Object object = syncObj;
        synchronized (object) {
            if (contributions != null) {
                AbstractTestServerContribution[] abstractTestServerContributionArray = contributions;
                int n = contributions.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractTestServerContribution contrib = abstractTestServerContributionArray[n2];
                    contrib.dispose();
                    ++n2;
                }
                contributions = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractTestServerContribution[] getContributions() {
        if (plugin == null) {
            return new AbstractTestServerContribution[0];
        }
        Object object = syncObj;
        synchronized (object) {
            if (contributions == null) {
                IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TEST_SERVER_CONTRIBUTION_ID);
                ArrayList<AbstractTestServerContribution> contribs = new ArrayList<AbstractTestServerContribution>(elements.length);
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    try {
                        Object o = element.createExecutableExtension("class");
                        if (o instanceof AbstractTestServerContribution) {
                            contribs.add((AbstractTestServerContribution)o);
                        }
                    }
                    catch (CoreException e) {
                        TestServerPlugin.getDefault().log((Exception)((Object)e));
                    }
                    ++n2;
                }
                contributions = contribs.toArray(new AbstractTestServerContribution[contribs.size()]);
            }
            return contributions;
        }
    }

    public static TestServerPlugin getDefault() {
        return plugin;
    }

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = TestServerPlugin.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void log(Exception e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public void log(String msg) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    public void log(String msg, Exception e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public void logWarning(String msg) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, msg));
    }
}

