/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;

public final class TypeVariable
extends ConstraintVariable {
    private final String fSource;
    private final CompilationUnitRange fTypeRange;

    public TypeVariable(Type type) {
        super(type.resolveBinding());
        this.fSource = type.toString();
        ICompilationUnit cu = ASTCreator.getCu((ASTNode)type);
        Assert.isNotNull((Object)cu);
        this.fTypeRange = new CompilationUnitRange(cu, (ASTNode)ASTNodes.getElementType(type));
    }

    public TypeVariable(ITypeBinding binding, String source, CompilationUnitRange range) {
        super(binding);
        this.fSource = source;
        this.fTypeRange = range;
    }

    public String toString() {
        return this.fSource;
    }

    public CompilationUnitRange getCompilationUnitRange() {
        return this.fTypeRange;
    }
}

