/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.ws.internal.converter.IIFile2UriConverter;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class J2EEActionAdapterFactory {
    public static final String EJB_MODULE = "ejbModule";
    public static final String APPCLIENT_MODULE = "appClientModule";
    public static final String WEB_MODULE = "WebContent";
    public static String FILE = "file:/";
    public static String FILEL = "file:";

    private static String getConvertedURIFromIFile(IFile file, String defaultURI) {
        IIFile2UriConverter converter;
        String convertedLocation = null;
        boolean allowBaseConversionOnFailure = true;
        if (file != null && file.exists() && (converter = WSPlugin.getInstance().getIFile2UriConverter()) != null) {
            convertedLocation = converter.convert(file);
            allowBaseConversionOnFailure = converter.allowBaseConversionOnFailure();
        }
        if (convertedLocation == null && allowBaseConversionOnFailure) {
            return defaultURI;
        }
        return convertedLocation;
    }

    private static String getConvertedURIFromURI(String originalURI) {
        IFile file = null;
        if (originalURI != null) {
            String platformResource = "platform:/resource";
            if (originalURI.startsWith(platformResource)) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(originalURI.substring(platformResource.length())));
            } else if (originalURI.startsWith("file:")) {
                String filePath = J2EEActionAdapterFactory.convertToRelative(originalURI);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
            }
        }
        return J2EEActionAdapterFactory.getConvertedURIFromIFile(file, originalURI);
    }

    public static String getWSDLURI(ServiceImpl serviceImpl) {
        Definition definition = serviceImpl.getEnclosingDefinition();
        String location = definition.getLocation();
        return J2EEActionAdapterFactory.getConvertedURIFromURI(location);
    }

    public static String getWSDLURI(ServiceRef serviceImpl) {
        String moduleRoot = null;
        IProject project = ProjectUtilities.getProject((EObject)serviceImpl);
        if (J2EEUtils.isWebComponent(project)) {
            moduleRoot = WEB_MODULE;
        } else if (J2EEUtils.isEJBComponent(project)) {
            moduleRoot = EJB_MODULE;
        } else if (J2EEUtils.isAppClientComponent(project)) {
            moduleRoot = APPCLIENT_MODULE;
        }
        if (moduleRoot != null) {
            IPath path = project.getLocation().addTrailingSeparator();
            path = path.append(moduleRoot).addTrailingSeparator();
            path = path.append(serviceImpl.getWsdlFile());
            File file = new File(path.toString());
            try {
                URL url = file.toURL();
                return J2EEActionAdapterFactory.getConvertedURIFromURI(url.toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public static String getWSDLURI(WSDLResourceImpl wsdlRI) {
        Definition definition = wsdlRI.getDefinition();
        String location = definition.getLocation();
        return J2EEActionAdapterFactory.getConvertedURIFromURI(location);
    }

    public static String getWSILPath(WSDLResourceImpl wsdlRI) {
        return J2EEActionAdapterFactory.convertToRelative(J2EEActionAdapterFactory.getWSDLURI(wsdlRI));
    }

    public static String getWSILPath(ServiceRef serviceImpl) {
        return J2EEActionAdapterFactory.convertToRelative(J2EEActionAdapterFactory.getWSDLURI(serviceImpl));
    }

    public static String getWSILPath(ServiceImpl serviceImpl) {
        return J2EEActionAdapterFactory.convertToRelative(J2EEActionAdapterFactory.getWSDLURI(serviceImpl));
    }

    public static String convertToRelative(String uri) {
        String root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        root = String.valueOf(FILE) + root;
        String rootL = String.valueOf(FILEL) + root;
        if (uri.startsWith(root) || uri.startsWith(rootL)) {
            return uri.substring(root.length());
        }
        return uri;
    }
}

