/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.generators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.ide.deployment.rui.internal.util.WebUtilities;
import org.eclipse.edt.ide.deployment.services.generators.ServiceUtilities;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.ui.internal.deployment.ui.DeploymentUtilities;
import org.eclipse.edt.javart.util.JavaAliaser;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceUriMappingGenerator {
    private DeploymentContext context;
    private String uriMappingFileName;
    private Document document;
    private IProject project;
    private Element root;
    private String projectName;
    private LogicAndDataPart logicPart;
    private boolean isHostProgramService;
    private Restservice restService;
    private static String gatewayServiceName = "UIGatewayService";

    public ServiceUriMappingGenerator(DeploymentContext context) {
        this.context = context;
    }

    public boolean visit(Service service, Restservice restService) {
        this.isHostProgramService = false;
        this.gen((LogicAndDataPart)service, restService);
        return false;
    }

    public boolean visit(ExternalType externalType, Restservice restService) {
        this.isHostProgramService = true;
        this.gen((LogicAndDataPart)externalType, restService);
        return false;
    }

    private void gen(LogicAndDataPart part, Restservice restService) {
        this.logicPart = part;
        this.project = this.context.getTargetProject();
        this.projectName = this.project.getName();
        this.uriMappingFileName = ServiceUtilities.getUriMappingFileName(this.projectName);
        this.restService = restService;
        this.genUriMapping();
    }

    private void genUriMapping() {
        try {
            this.getRoot();
        }
        catch (Exception exception) {}
        String fullyQualifiedName = String.valueOf(JavaAliaser.packageNameAlias((String)this.logicPart.getPackageName())) + '.' + this.logicPart.getId();
        this.removeServiceContextNode("contextroot");
        this.removeServiceContextNode("classpath");
        this.removeServiceNode(fullyQualifiedName);
        this.addServiceNode(fullyQualifiedName);
        this.addContextNode();
        try {
            this.addClasspathNode();
            this.writeDocument();
        }
        catch (Exception exception) {}
    }

    private void removeServiceNode(String fullyQualifiedName) {
        NodeList mappings = this.root.getElementsByTagName("servicemapping");
        Element node = null;
        ArrayList<Element> nodes2Remove = new ArrayList<Element>();
        int idx = 0;
        while (idx < mappings.getLength()) {
            node = (Element)mappings.item(idx);
            String className = node.getAttribute("classname");
            if (className == null) {
                nodes2Remove.add(node);
            } else if (className.equals(fullyQualifiedName)) {
                nodes2Remove.add(node);
            }
            ++idx;
        }
        idx = 0;
        while (idx < nodes2Remove.size()) {
            this.root.removeChild((Node)nodes2Remove.get(idx));
            ++idx;
        }
    }

    private void removeServiceContextNode(String nodeName) {
        NodeList nodeList = this.root.getElementsByTagName(nodeName);
        ArrayList<Element> nodes2Remove = new ArrayList<Element>();
        int idx = 0;
        while (idx < nodeList.getLength()) {
            nodes2Remove.add((Element)nodeList.item(idx));
            ++idx;
        }
        idx = 0;
        while (idx < nodes2Remove.size()) {
            this.root.removeChild((Node)nodes2Remove.get(idx));
            ++idx;
        }
    }

    private void addContextNode() {
        Element serviceContextNode = this.document.createElement("contextroot");
        this.root.appendChild(serviceContextNode);
        serviceContextNode.appendChild(this.document.createTextNode(String.valueOf('/') + WebUtilities.getContextRoot((IProject)this.project) + '/' + ServiceUtilities.getRestServiceRoot()));
    }

    private void addClasspathNode() throws CoreException {
    }

    private void addServiceNode(String fullyQualifiedName) {
        Element serviceMappingNode = this.document.createElement("servicemapping");
        this.root.appendChild(serviceMappingNode);
        serviceMappingNode.setAttribute("classname", fullyQualifiedName);
        if (ServiceUtilities.isStateful((Part)this.logicPart)) {
            serviceMappingNode.setAttribute("stateful", "true");
        }
        if (this.isHostProgramService) {
            serviceMappingNode.setAttribute("hostProgramService", "true");
        }
        Element uriNode = this.document.createElement("uri");
        uriNode.setAttribute("httpmethod", "POST");
        String nodeValue = ServiceUtilities.getUri(this.logicPart, this.restService);
        uriNode.appendChild(this.document.createTextNode(nodeValue));
        serviceMappingNode.appendChild(uriNode);
    }

    private void getRoot() throws Exception {
        NodeList roots;
        String fullyQualifiedUriMappingFileName = this.project.getLocation().toPortableString();
        ArrayList folders = new ArrayList();
        DeploymentUtilities.getJavaSourceFolders((IProject)this.project, folders);
        if (folders.size() == 0) {
            return;
        }
        String sourceFolder = ((IResource)folders.get(0)).getFullPath().removeFirstSegments(1).toOSString();
        fullyQualifiedUriMappingFileName = String.valueOf(fullyQualifiedUriMappingFileName) + '/' + sourceFolder + '/' + this.uriMappingFileName;
        File file = new File(fullyQualifiedUriMappingFileName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (file.exists()) {
            try {
                this.document = builder.parse(file);
            }
            catch (Exception exception) {}
        }
        if (this.document == null) {
            this.document = builder.newDocument();
        }
        if ((roots = this.document.getElementsByTagName("servicemappings")) == null || roots.getLength() == 0) {
            this.root = this.document.createElement("servicemappings");
            this.document.appendChild(this.root);
        } else {
            this.root = (Element)roots.item(0);
        }
    }

    private void writeDocument() throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        this.cleanupDocument();
        DOMSource source = new DOMSource(this.document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        ByteArrayInputStream bis = new ByteArrayInputStream(os.toByteArray());
        String javaSourceFolder = EclipseUtilities.getJavaSourceFolderName((IProject)this.context.getTargetProject());
        Path targetFilePath = new Path("/" + this.context.getTargetProject().getName() + "/" + javaSourceFolder + "/" + this.uriMappingFileName);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetFilePath);
        if (targetFile.exists()) {
            targetFile.setContents((InputStream)bis, true, true, this.context.getMonitor());
        } else {
            targetFile.create((InputStream)bis, true, this.context.getMonitor());
        }
        os.close();
        ((InputStream)bis).close();
    }

    private void cleanupDocument() {
        this.document.normalize();
        NodeList nodes = this.root.getChildNodes();
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node node = nodes.item(idx);
            if (node.getNodeType() != 1) {
                this.root.removeChild(node);
            }
            ++idx;
        }
    }

    private String getClasspath(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        String classpath = "";
        try {
            if (javaProject != null) {
                classpath = ServiceUriMappingGenerator.createClasspath(javaProject);
            }
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return classpath;
    }

    private static String createClasspath(IJavaProject javaProject) throws JavaModelException, MalformedURLException, URISyntaxException {
        StringBuffer classpath = new StringBuffer();
        IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < resolvedClasspath.length) {
            IClasspathEntry entry = resolvedClasspath[i];
            String path = entry.getEntryKind() != 3 ? entry.getPath().toPortableString() : (entry.getOutputLocation() != null ? javaProject.getProject().getLocation().removeLastSegments(1).append(entry.getOutputLocation()).toPortableString() : javaProject.getProject().getLocation().removeLastSegments(1).append(javaProject.getOutputLocation()).toPortableString());
            classpath.append(path);
            classpath.append(";");
            ++i;
        }
        return classpath.toString();
    }
}

