/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ErrorLexer;
import org.eclipse.edt.ide.core.internal.errors.ErrorLineTracker;
import org.eclipse.edt.ide.core.internal.errors.FileReaderUtil;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;

public class TokenStream {
    private ArrayList tokenList = new ArrayList();
    private int lookaheadPos = 0;
    private int readPos = 0;
    private ErrorLineTracker lineTracker;
    private boolean skipPrefix = false;

    private TokenStream() {
    }

    public TokenStream(String input) {
        TerminalNode terminalNode;
        ErrorLexer errorLexer = new ErrorLexer(new StringReader(input));
        this.lineTracker = new ErrorLineTracker(input);
        do {
            terminalNode = errorLexer.next();
            this.tokenList.add(terminalNode);
        } while (terminalNode.terminalType != 0);
        if (this.getTerminalNodeAt(0).isWhiteSpace()) {
            this.advanceLookAhead();
        }
    }

    private void advanceLookAhead() {
        ++this.lookaheadPos;
        while (this.getTerminalNodeAt(this.lookaheadPos).isWhiteSpace()) {
            ++this.lookaheadPos;
        }
    }

    public void shift() {
        this.advanceLookAhead();
        ++this.readPos;
    }

    public TerminalNode lookAhead() {
        return this.getTerminalNodeAt(this.lookaheadPos);
    }

    public TokenStream copy() {
        TokenStream result = new TokenStream();
        result.tokenList = this.tokenList;
        result.readPos = this.readPos;
        result.lookaheadPos = this.lookaheadPos;
        return result;
    }

    public boolean deleteInput(int inputDeleted) {
        int i = 0;
        while (i < inputDeleted) {
            if (AbstractRecoverer.isUndeletableTerminal(this.lookAhead())) {
                return false;
            }
            this.advanceLookAhead();
            ++i;
        }
        return true;
    }

    private TerminalNode getTerminalNodeAt(int index) {
        return (TerminalNode)this.tokenList.get(index);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.readPos) {
            buffer.append(this.getTerminalNodeAt(i));
            buffer.append(' ');
            ++i;
        }
        buffer.append(" --> ");
        i = this.readPos;
        while (i < this.lookaheadPos) {
            buffer.append(this.getTerminalNodeAt(i));
            buffer.append(' ');
            ++i;
        }
        if (this.readPos != this.lookaheadPos) {
            buffer.append(" --> ");
        }
        i = this.lookaheadPos;
        while (i < this.tokenList.size()) {
            buffer.append(this.getTerminalNodeAt(i));
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public int numTokensLeft() {
        int numTokensLeft = 0;
        int i = this.lookaheadPos;
        while (i < this.tokenList.size()) {
            if (!this.getTerminalNodeAt(i).isWhiteSpace()) {
                ++numTokensLeft;
            }
            ++i;
        }
        return numTokensLeft - 1;
    }

    public boolean hasWhitespaces() {
        return this.readPos != this.lookaheadPos;
    }

    public ParseNode[] getUnprocessedTerminals() {
        ParseNode[] result = this.tokenList.subList(this.readPos, this.lookaheadPos).toArray(new ParseNode[0]);
        this.readPos = this.lookaheadPos;
        return result;
    }

    public static void main(String[] args) {
        new TokenStream(FileReaderUtil.readFile("tokens.egl"));
    }

    public String getLine(TerminalNode terminal) {
        return this.lineTracker.getLine(terminal.line);
    }

    public TerminalNode previousNonWSTerminal(TerminalNode terminalNode) {
        int index = this.tokenList.indexOf(terminalNode) - 1;
        while (index >= 0 && this.getTerminalNodeAt(index).isWhiteSpace()) {
            --index;
        }
        return index < 0 ? terminalNode : this.getTerminalNodeAt(index);
    }

    public void skipPrefix() {
        this.skipPrefix = true;
    }

    public List getPrefixNodes() {
        ArrayList<TerminalNode> result = new ArrayList<TerminalNode>();
        if (this.tokenList.size() == 0) {
            return result;
        }
        int i = this.readPos;
        while (i < this.tokenList.size() - 1) {
            result.add(this.getTerminalNodeAt(i));
            ++i;
        }
        return result;
    }

    public String getTemplatePrefix() {
        int numTokens = this.tokenList.size();
        if (numTokens < 2) {
            return "";
        }
        TerminalNode lastToken = (TerminalNode)this.tokenList.get(numTokens - 2);
        if (TokenStream.isExtensibleTerminal(lastToken.terminalType)) {
            return lastToken.text;
        }
        if (lastToken.terminalType == 110) {
            if (lastToken.text.equalsIgnoreCase("sql")) {
                return "sql";
            }
            return "";
        }
        return "";
    }

    public boolean isDone() {
        int terminalType = this.lookAhead().terminalType;
        return terminalType == 0 || this.skipPrefix && this.lookaheadPos == this.tokenList.size() - 2 && TokenStream.isExtensibleTerminal(terminalType);
    }

    public static boolean isExtensibleTerminal(int terminalType) {
        switch (terminalType) {
            case 4: 
            case 9: 
            case 10: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: {
                return false;
            }
        }
        return true;
    }
}

