/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexedFile;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractIndexer;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.MultipleSearchPattern;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class PartReferencePattern
extends MultipleSearchPattern {
    private char[] qualification;
    private char[] simpleName;
    private char[] decodedSimpleName;
    private static char[][] TAGS = new char[][]{PART_REF, REF};
    private static char[][] REF_TAGS = new char[][]{REF};
    private char[][] segments;
    private int currentSegment;
    private char[] decodedSegment;
    protected char partTypes;

    public PartReferencePattern(char[] qualification, char[] simpleName, char partTypes, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        this.qualification = isCaseSensitive ? qualification : CharOperation.toLowerCase((char[])qualification);
        char[] cArray = this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase((char[])simpleName);
        if (simpleName == null) {
            this.segments = this.qualification == null ? ONE_STAR_CHAR : CharOperation.splitOn((char)'.', (char[])this.qualification);
        }
        this.partTypes = partTypes;
        this.needsResolve = true;
    }

    @Override
    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int tagLength = this.currentTag.length;
        int nameLength = CharOperation.indexOf((char)'/', (char[])word, (int)tagLength);
        if (nameLength < 0) {
            nameLength = size;
        }
        if (this.simpleName == null) {
            this.decodedSegment = CharOperation.subarray((char[])word, (int)tagLength, (int)nameLength);
        } else {
            this.decodedSimpleName = CharOperation.subarray((char[])word, (int)tagLength, (int)nameLength);
        }
    }

    @Override
    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IEGLSearchScope scope) throws IOException {
        if (this.currentTag == REF) {
            this.foundAmbiguousIndexMatches = true;
        }
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file;
            int reference = references[i];
            if (reference != -1 && (file = input.getIndexedFile(reference)) != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptPartReference(path, this.decodedSimpleName);
            }
            ++i;
        }
    }

    @Override
    protected char[][] getPossibleTags() {
        if (this.simpleName == null) {
            return REF_TAGS;
        }
        return TAGS;
    }

    @Override
    protected boolean hasNextQuery() {
        if (this.simpleName == null) {
            if (this.segments.length > 2) {
                return --this.currentSegment >= 2;
            }
            return --this.currentSegment >= 0;
        }
        return false;
    }

    @Override
    public char[] indexEntryPrefix() {
        if (this.simpleName == null) {
            return AbstractIndexer.bestReferencePrefix(REF, this.segments[this.currentSegment], this.matchMode, this.isCaseSensitive);
        }
        return AbstractIndexer.bestReferencePrefix(this.currentTag, this.simpleName, this.matchMode, this.isCaseSensitive);
    }

    @Override
    protected int matchContainer() {
        return 31;
    }

    @Override
    protected boolean matchIndexEntry() {
        block14: {
            block13: {
                if (this.simpleName != null) break block13;
                switch (this.matchMode) {
                    case 0: {
                        if (!CharOperation.equals((char[])this.segments[this.currentSegment], (char[])this.decodedSegment, (boolean)this.isCaseSensitive)) {
                            return false;
                        }
                        break block14;
                    }
                    case 1: {
                        if (!CharOperation.prefixEquals((char[])this.segments[this.currentSegment], (char[])this.decodedSegment, (boolean)this.isCaseSensitive)) {
                            return false;
                        }
                        break block14;
                    }
                    case 2: {
                        if (!CharOperation.match((char[])this.segments[this.currentSegment], (char[])this.decodedSegment, (boolean)this.isCaseSensitive)) {
                            return false;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void resetQuery() {
        if (this.simpleName == null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("TypeReferencePattern: pkg<");
        if (this.qualification != null) {
            buffer.append(this.qualification);
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    @Override
    public int matchLevel(Node node, boolean resolve) {
        final int[] retVal = new int[1];
        if (node instanceof Expression) {
            node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                public boolean visitName(Name name) {
                    retVal[0] = PartReferencePattern.this.matchLevelName(name);
                    return false;
                }
            });
        }
        return retVal[0];
    }

    @Override
    public int matchLevel(IMember member, boolean resolve) {
        if (member instanceof IPart) {
            IPart type = (IPart)member;
            if (this.simpleName != null && !this.matchesName(this.simpleName, type.getElementName().toCharArray())) {
                return 0;
            }
        }
        return 1;
    }

    private int matchLevel(NameType partRef, boolean resolve) {
        throw new UnsupportedOperationException();
    }

    private int matchLevel(Expression accessRef, boolean resolve) {
        throw new UnsupportedOperationException();
    }

    private Node getContainingLibrary(IDataBinding dataBinding) {
        return null;
    }

    private Node getContainingTableOrLibrary(IDataBinding dataBinding) {
        return null;
    }

    private int matchLevelName(Name nameRef) {
        if (this.simpleName == null) {
            return this.needsResolve ? 1 : 2;
        }
        if (nameRef.isSimpleName()) {
            if (this.matchesName(this.simpleName, nameRef.getCanonicalName().toCharArray())) {
                return 1;
            }
            return 0;
        }
        char[][] tokens = CharOperation.splitOn((char)'.', (char[])nameRef.getCanonicalName().toCharArray());
        int i = 0;
        int max = tokens.length;
        while (i < max) {
            if (this.matchesName(this.simpleName, tokens[i])) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int matchesPartType(Name nameRef, IPartBinding partBinding, boolean forceQualification) {
        if (partBinding == null) {
            return 3;
        }
        if (this.matchesPartType(partBinding)) {
            if (forceQualification && this.qualification == null && nameRef.isQualifiedName()) {
                return 0;
            }
            if (nameRef.isSimpleName()) {
                return this.matchLevelForType(this.simpleName, this.qualification, partBinding);
            }
            char[][] tokens = CharOperation.splitOn((char)'.', (char[])nameRef.getCanonicalName().toCharArray());
            int lastIndex = tokens.length - 1;
            while (lastIndex >= 0) {
                int level;
                if (!this.matchesName(this.simpleName, tokens[lastIndex--]) || (level = this.matchLevelForType(this.simpleName, this.qualification, partBinding)) == 0) continue;
                return level;
            }
            return 0;
        }
        return 0;
    }

    public boolean matchesPartType(IPartBinding partBinding) {
        boolean match = false;
        switch (this.partTypes) {
            case '\u0001': {
                match = partBinding.getKind() == 13;
                break;
            }
            case '\b': {
                match = partBinding.getKind() == 6 || partBinding.getKind() == 7;
                break;
            }
            case '\u0010': {
                match = partBinding.getKind() == 17;
                break;
            }
            case '\u0100': {
                match = partBinding.getKind() == 11;
                break;
            }
            case '\u0080': {
                match = partBinding.getKind() == 20;
                break;
            }
            case '@': {
                match = partBinding.getKind() == 9;
                break;
            }
            case ' ': {
                match = partBinding.getKind() == 8;
                break;
            }
            case '\u0004': {
                match = partBinding.getKind() == 5;
                break;
            }
            case '\u0200': {
                match = partBinding.getKind() == 10;
                break;
            }
            case '\u1000': {
                match = partBinding.getKind() == 27;
                break;
            }
            case '\u2000': {
                match = partBinding.getKind() == 28;
                break;
            }
            case '\u4000': {
                match = partBinding.getKind() == 19;
                break;
            }
            case '\u0400': {
                match = partBinding.getKind() == 14;
                break;
            }
            case '\u0800': {
                match = partBinding.getKind() == 15;
                break;
            }
            case '\u7fff': {
                match = true;
            }
        }
        return match;
    }

    private boolean matchesPartType(IPart part) {
        boolean match = false;
        try {
            SourcePartElementInfo partInfo = (SourcePartElementInfo)((EGLElement)((Object)part)).getElementInfo();
            if (this.partTypes == Short.MAX_VALUE) {
                match = true;
            } else if (partInfo.isProgram()) {
                match = this.partTypes == '\u0001';
            } else if (partInfo.isRecord()) {
                match = this.partTypes == '\b';
            } else if (partInfo.isDataItem()) {
                match = this.partTypes == '\u0010';
            } else if (partInfo.isLibrary()) {
                match = this.partTypes == '\u0100';
            } else if (partInfo.isFunction()) {
                match = this.partTypes == '\u0080';
            } else if (partInfo.isFormGroup()) {
                match = this.partTypes == '@';
            } else if (partInfo.isForm()) {
                match = this.partTypes == ' ';
            } else if (partInfo.isDataTable()) {
                match = this.partTypes == '\u0004';
            } else if (partInfo.isHandler()) {
                match = this.partTypes == '\u0200';
            } else if (partInfo.isService()) {
                match = this.partTypes == '\u0400';
            } else if (partInfo.isInterface()) {
                match = this.partTypes == '\u0800';
            } else if (partInfo.isDelegate()) {
                match = this.partTypes == '\u1000';
            } else if (partInfo.isExternalType()) {
                match = this.partTypes == '\u2000';
            } else if (partInfo.isEnumeration()) {
                match = this.partTypes == '\u4000';
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return match;
    }

    @Override
    public int matchesAnnotationType(Name node, IAnnotationTypeBinding binding, boolean forceQualification) {
        if (binding == null) {
            return 3;
        }
        if (this.matchesAnnotationType(binding)) {
            if (forceQualification && this.qualification == null && node.isQualifiedName()) {
                return 0;
            }
            if (node.isSimpleName()) {
                return this.matchLevelForType(this.simpleName, this.qualification, binding);
            }
            char[][] tokens = CharOperation.splitOn((char)'.', (char[])node.getCanonicalName().toCharArray());
            int lastIndex = tokens.length - 1;
            while (lastIndex >= 0) {
                int level;
                if (!this.matchesName(this.simpleName, tokens[lastIndex--]) || (level = this.matchLevelForType(this.simpleName, this.qualification, binding)) == 0) continue;
                return level;
            }
            return 0;
        }
        return 0;
    }

    public boolean matchesAnnotationType(IAnnotationTypeBinding binding) {
        switch (this.partTypes) {
            case '\u7fff': {
                return true;
            }
            case '\u0002': {
                return binding.isPartSubType() || binding.getAnnotation((IAnnotationTypeBinding)AnnotationAnnotationTypeBinding.getInstance()) != null;
            }
            case '\u8000': {
                return binding.isPartSubType();
            }
        }
        return false;
    }

    @Override
    public int matchesFunctionPartType(IFunction function) {
        try {
            if (function.getParent() instanceof IPart && ((SourcePartElementInfo)((EGLElement)function.getParent()).getElementInfo()).isDelegate()) {
                return 3;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public int matchesPart(IPart part) {
        if (!this.matchesPartType(part)) {
            return 0;
        }
        return this.matchLevelForType(this.simpleName, this.qualification, part);
    }

    @Override
    public int getPatternType() {
        return 2;
    }
}

