/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.launching;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ListSelectionDialog
extends Dialog {
    protected String fTitle;
    protected String fMessage;
    protected Text fText;
    protected Table fTable;
    protected ILabelProvider fLabelProvider;
    protected ListElement[] fListElements;
    protected ListElement[] fFilteredListElements;
    protected int fSelectionIndex = -1;
    private String fHelpId;

    public ListSelectionDialog(Shell parent, ILabelProvider labelProvider, String helpId) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fHelpId = helpId;
    }

    public int open() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ListSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    protected void access$superOpen() {
        super.open();
    }

    public void setElements(Object[] elements) {
        this.fListElements = new ListElement[elements.length];
        int i = 0;
        while (i < elements.length) {
            ListElement listElement;
            Object element = elements[i];
            String text = this.fLabelProvider.getText(element);
            Image image = this.fLabelProvider.getImage(element);
            this.fListElements[i] = listElement = new ListElement(text, image, element);
            ++i;
        }
        Arrays.sort(this.fListElements, new ListElementComparator());
        this.fFilteredListElements = this.fListElements;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setMessage(String message) {
        this.fMessage = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        if (this.fFilteredListElements.length == 0) {
            this.getButton(0).setEnabled(false);
        }
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        this.createMessageArea(composite);
        this.createText(composite);
        this.createTable(composite);
        this.createTableEntries();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.fHelpId);
        return composite;
    }

    public void create() {
        super.create();
        this.setView();
    }

    protected void createMessageArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.fMessage);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
    }

    protected void createText(Composite parent) {
        this.fText = new Text(parent, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.fText.setLayoutData((Object)gridData);
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ListSelectionDialog.this.handleTextModified();
            }
        });
    }

    protected void createTable(Composite parent) {
        this.fTable = new Table(parent, 68100);
        this.fTable.setEnabled(true);
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionDialog.this.fSelectionIndex = ListSelectionDialog.this.fTable.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ListSelectionDialog.this.fSelectionIndex = ListSelectionDialog.this.fTable.getSelectionIndex();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        gridData.heightHint = this.convertHeightInCharsToPixels(18);
        this.fTable.setLayoutData((Object)gridData);
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Point coordinates = new Point(event.x, event.y);
                TableItem item = ListSelectionDialog.this.fTable.getItem(coordinates);
                if (item != null) {
                    ListSelectionDialog.this.fSelectionIndex = ListSelectionDialog.this.fTable.indexOf(item);
                    ListSelectionDialog.this.okPressed();
                }
            }
        });
    }

    protected void createTableEntries() {
        int i = 0;
        while (i < this.fFilteredListElements.length) {
            TableItem item = new TableItem(this.fTable, 0);
            ListElement element = this.fFilteredListElements[i];
            item.setText(element.getText());
            item.setImage(element.getImage());
            ++i;
        }
    }

    protected void handleTextModified() {
        String text = this.fText.getText();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        if (text == null || text.length() < 1) {
            this.fFilteredListElements = this.fListElements;
        } else {
            Vector<ListElement> vector = new Vector<ListElement>();
            int i = 0;
            while (i < this.fListElements.length) {
                ListElement element = this.fListElements[i];
                if (element.getText().startsWith(text)) {
                    vector.add(element);
                }
                ++i;
            }
            this.fFilteredListElements = new ListElement[vector.size()];
            vector.copyInto(this.fFilteredListElements);
        }
        if (this.fFilteredListElements.length == 0) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
        this.createTableEntries();
        this.fTable.setRedraw(true);
        this.setView();
    }

    protected void setView() {
        if (this.fFilteredListElements.length > 0) {
            this.fTable.setSelection(0);
            this.fSelectionIndex = 0;
        } else {
            this.fSelectionIndex = -1;
        }
        this.fText.setFocus();
    }

    public Object getResult() {
        if (this.fSelectionIndex >= 0 && this.fSelectionIndex < this.fFilteredListElements.length) {
            return this.fFilteredListElements[this.fSelectionIndex].getElementObject();
        }
        return null;
    }

    public int getResultIndex() {
        return this.fSelectionIndex;
    }

    protected class ListElement {
        protected String fText;
        protected Image fImage;
        protected Object fElementObject;

        public ListElement(String text, Image image, Object elementObject) {
            this.fText = text;
            this.fImage = image;
            this.fElementObject = elementObject;
        }

        public String getText() {
            return this.fText;
        }

        public Image getImage() {
            return this.fImage;
        }

        public Object getElementObject() {
            return this.fElementObject;
        }
    }

    protected class ListElementComparator
    implements Comparator {
        protected ListElementComparator() {
        }

        public int compare(Object o1, Object o2) {
            ListElement element1 = (ListElement)o1;
            ListElement element2 = (ListElement)o2;
            return element1.getText().compareToIgnoreCase(element2.getText());
        }
    }
}

