/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLModelChangeListener;
import org.eclipse.edt.ide.rui.editor.IEditorSelectAndRevealer;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.edt.ide.rui.server.EventValue;
import org.eclipse.edt.ide.rui.server.PropertyValue;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOutlinePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditorErrorUpdater;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditorOutlinePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditorUndoManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPreviewPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvSourceOperation;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.palette.EvPaletteRoot;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.IEvPropertySheetPageAdapter;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyChange;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertySheetPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiUtils;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BrowserManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.EvWidgetNameDialog;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.Mnemonics;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.IPageDataViewPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.PageDataViewPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.IWidgetDescriptorRegistryListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorGroup;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetEventDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenModelBuilder;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.IEGLEditorWrapper;
import org.eclipse.edt.ide.ui.internal.editor.IEvEditor;
import org.eclipse.gef.ui.views.palette.PaletteView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class EvEditor
extends MultiPageEditorPart
implements IEGLEditorWrapper,
IEGLModelChangeListener,
IEditorSelectAndRevealer,
IEvPropertySheetPageAdapter,
IPartListener,
IPropertyChangeListener,
IResourceChangeListener,
IResourceDeltaVisitor,
ISelectionChangedListener,
IWidgetDescriptorRegistryListener,
SelectionListener,
IEvEditor,
ITextEditor {
    protected boolean _bRuiHandler = true;
    protected boolean _bTranslationTestMode = false;
    protected boolean _bOperationInProgress = false;
    protected boolean _bWebPageGenerationRequired = true;
    protected EvEditorProvider _editorProvider = null;
    protected EvEditorErrorUpdater _errorUpdater = null;
    protected int _iPerformance = 0;
    protected EvEditorOutlinePage _outlinePage = null;
    protected PageDataViewPage _eglPageDataViewPage = null;
    protected EvDesignPage _pageDesign = null;
    protected EvPreviewPage _pagePreview = null;
    protected EGLEditor _pageSource = null;
    protected EvEditorUndoManager _undoManager = null;
    protected String _widgetId = null;
    public static int _iRenderEngine = 0;

    public void close(final boolean bSave) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                EvEditor.this.getSite().getPage().closeEditor((IEditorPart)EvEditor.this, bSave);
            }
        });
    }

    public EvDesignPage getDesignPage() {
        return this._pageDesign;
    }

    public Browser createBrowser(Composite compositeParent) {
        Browser browser = null;
        if (this._iPerformance == 1) {
            Browser browserDesign = this._pageDesign.getBrowser();
            Browser browserPreview = this._pagePreview.getBrowser();
            Browser browser2 = browser = browserDesign != null ? browserDesign : browserPreview;
            if (browser != null) {
                boolean bReparented = browser.setParent(compositeParent);
                if (bReparented) {
                    this._pageDesign.resetBrowserToNull();
                    this._pagePreview.resetBrowserToNull();
                } else {
                    browser = null;
                }
            }
        }
        if (browser == null) {
            browser = BrowserManager.getInstance().createBrowser(compositeParent);
        }
        return browser;
    }

    @Override
    public void createEventHandlingFunction(String strFunctionName) {
        this.doSourceOperationFunctionCreate(strFunctionName);
    }

    protected void createPageDesign() {
        if (this._pageDesign != null) {
            return;
        }
        this._pageDesign = new EvDesignPage(this);
        try {
            this.addPage(0, (IEditorPart)this._pageDesign, this.getEditorInput());
            this.setPageText(0, Messages.NL_Design);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void createPagePreview() {
        if (this._pagePreview != null) {
            return;
        }
        this._pagePreview = new EvPreviewPage(this);
        try {
            this.addPage(2, (IEditorPart)this._pagePreview, this.getEditorInput());
            this.setPageText(2, Messages.NL_Preview);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void createPages() {
        this._errorUpdater = new EvEditorErrorUpdater(this);
        this._iPerformance = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.Performance");
        _iRenderEngine = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.RenderEngine");
        IPreferenceStore preferences = EGLBasePlugin.getPlugin().getPreferenceStore();
        preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.createPageSource();
        this.initializeSource();
        this.createPageDesign();
        this.createPagePreview();
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        new Mnemonics().setMnemonics(tabFolder);
        EvHelp.setHelp((Control)tabFolder, EvHelp.VISUAL_EDITOR);
        tabFolder.addSelectionListener((SelectionListener)this);
        if (this.isRuiHandler()) {
            this.setActivePage(EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.EditorOpeningTab"));
        } else {
            this.setActivePage(1);
        }
        IEGLDocument currentDocument = this.getDocument();
        if (currentDocument != null) {
            currentDocument.addModelChangeListener((IEGLModelChangeListener)this);
        }
        this.updateBrowsers();
    }

    protected void createPageSource() {
        if (this._pageSource != null) {
            return;
        }
        this._pageSource = new EGLEditor();
        try {
            this.addPage(0, (IEditorPart)this._pageSource, this.getEditorInput());
            this.setPageText(0, Messages.NL_Source);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this._editorProvider = new EvEditorProvider(this._pageSource);
        this.initializeUndoManager();
    }

    public void dispose() {
        IEditorSite editorSite;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        WidgetDescriptorRegistry.getInstance(this.getProject()).removeWidgetDescriptorRegistryListener(this);
        IEGLDocument currentDocument = this.getDocument();
        if (currentDocument != null) {
            this.cleanModelChangeListeners(currentDocument);
        }
        if ((editorSite = this.getEditorSite()) != null) {
            editorSite.getPage().removePartListener((IPartListener)this);
        }
        if (this._pageDesign != null) {
            this._pageDesign.terminate();
        }
        if (this._pagePreview != null) {
            this._pagePreview.terminate();
        }
        if (this._editorProvider != null) {
            this._editorProvider.cleanupGeneratedJavaScript();
        }
        if (this._errorUpdater != null) {
            this._errorUpdater.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this._pageSource.doSave(progressMonitor);
    }

    public void doSaveAs() {
        this._pageSource.doSaveAs();
        this.setInput(this._pageSource.getEditorInput());
        this.setPartName(this._pageSource.getTitle());
        this._bWebPageGenerationRequired = true;
        this.updateBrowsers();
    }

    public void doSourceOperationFunctionCreate(String strFunctionName) {
        if (this._undoManager != null) {
            this._undoManager.operationStarting();
        }
        this._bOperationInProgress = true;
        NestedFunction function = null;
        try {
            try {
                function = this._editorProvider.createEventHandlingFunction(strFunctionName);
            }
            catch (Exception exception) {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (function == null) {
                    return;
                }
                StructuredSelection selection = new StructuredSelection((Object)function);
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this._outlinePage, (ISelection)selection);
                this._pageSource.doSelectionChanged(event);
            }
        }
        finally {
            this._bOperationInProgress = false;
            if (this._undoManager != null) {
                this._undoManager.operationEnded("");
            }
            if (function == null) {
                return;
            }
            StructuredSelection selection = new StructuredSelection((Object)function);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this._outlinePage, (ISelection)selection);
            this._pageSource.doSelectionChanged(event);
        }
    }

    public void doSourceOperationFieldCreate(String packageName, String fieldName, String fieldType, String template) {
        if (this._undoManager != null) {
            this._undoManager.operationStarting();
        }
        try {
            try {
                this._editorProvider.createField(packageName, fieldName, fieldType, template);
            }
            catch (Exception exception) {
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
            }
        }
        finally {
            if (this._undoManager != null) {
                this._undoManager.operationEnded("");
            }
        }
    }

    public IProject getProject() {
        IFile fileInput = this.getFile();
        IProject projectEditorInput = null;
        if (fileInput != null) {
            projectEditorInput = fileInput.getProject();
        }
        return projectEditorInput;
    }

    public void doSourceOperationWidgetCreate(WidgetDescriptor descriptor, EvDesignOverlayDropLocation location) {
        IEGLDocument currentDocument;
        GenModel genModel;
        boolean bIncremental = true;
        String strProjectName = null;
        if (descriptor != null) {
            strProjectName = descriptor.getProjectName();
        }
        IProject projectWidget = null;
        if (strProjectName != null) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            projectWidget = workspaceRoot.getProject(strProjectName);
        }
        String strWidgetName = null;
        boolean bPrompt = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName");
        if (!GenManager.getInstance().isGenFromDataView() && bPrompt) {
            EvWidgetNameDialog dialog = new EvWidgetNameDialog(Display.getCurrent().getActiveShell(), descriptor.getLabel(), this._editorProvider);
            int iRC = dialog.open();
            if (iRC == 1) {
                return;
            }
            strWidgetName = dialog.getName();
        }
        if (GenManager.getInstance().isGenFromDataView() && (genModel = GenModelBuilder.getInstance().getGenModel()) != null) {
            strWidgetName = genModel.getName();
        }
        if (this._undoManager != null) {
            this._undoManager.operationStarting();
        }
        this._bOperationInProgress = true;
        String strWidgetCreationTemplate = null;
        String strfunctionCreationTemplate = null;
        if (descriptor != null) {
            if (GenManager.getInstance().isGenFromDataView()) {
                strWidgetCreationTemplate = descriptor.getDataTemplate();
                strfunctionCreationTemplate = descriptor.getDataFunctionTemplate();
            } else {
                strWidgetCreationTemplate = descriptor.getTemplate();
            }
        }
        if (bIncremental && (currentDocument = this.getDocument()) != null) {
            this.cleanModelChangeListeners(currentDocument);
        }
        try {
            try {
                int iParentStatementOffset = 0;
                int iParentStatementLength = 0;
                if (location.widgetParent != null) {
                    iParentStatementOffset = location.widgetParent.getStatementOffset();
                    iParentStatementLength = location.widgetParent.getStatementLength();
                }
                if (location.widgetLayoutData != null) {
                    String[] layoutWidget = location.widgetLayoutData.getWidgetLayout().getLayoutWidgetQualifiedName();
                    WidgetDescriptor widgetDescriptor = WidgetDescriptorRegistry.getInstance(this.getProject()).getDescriptor(layoutWidget[0], layoutWidget[1]);
                    String layoutDataTemplate = "new " + widgetDescriptor.getChildLayoutDataTemplate();
                    String layoutProperty = location.widgetLayoutData.getWidgetLayout().processNewLayoutData(location.widgetLayoutData.getLayoutData(), layoutDataTemplate);
                    int startIndex = 0;
                    if (GenManager.getInstance().isGenFromDataView() && GenManager.getInstance().getGenRootWidgetName() != null) {
                        String rootWidgetname = GenManager.getInstance().getGenRootWidgetName();
                        startIndex = strWidgetCreationTemplate.indexOf(rootWidgetname);
                        GenManager.getInstance().setGenRootWidgetName(null);
                    }
                    startIndex = strWidgetCreationTemplate.indexOf("{", startIndex);
                    while (strWidgetCreationTemplate.charAt(startIndex - 1) == '$') {
                        startIndex = strWidgetCreationTemplate.indexOf("{", startIndex + 1);
                    }
                    int hasProperty = strWidgetCreationTemplate.lastIndexOf("=");
                    strWidgetCreationTemplate = String.valueOf(strWidgetCreationTemplate.substring(0, startIndex + 1)) + " layoutData = " + layoutProperty + (hasProperty < 0 ? "" : ",") + strWidgetCreationTemplate.substring(startIndex + 1);
                }
                if (GenManager.getInstance().isGenFromDataView()) {
                    strWidgetCreationTemplate = strWidgetCreationTemplate.substring(strWidgetCreationTemplate.indexOf(" ") + 1, strWidgetCreationTemplate.length());
                }
                if (BidiUtils.isBidi()) {
                    strWidgetCreationTemplate = BidiUtils.updateTemplateWithBidi(strWidgetCreationTemplate, this._pageDesign.getBidiFormat());
                }
                this._editorProvider.create(projectWidget, descriptor.getPackage(), descriptor.getType(), iParentStatementOffset, iParentStatementLength, location.iIndex, strWidgetCreationTemplate, strfunctionCreationTemplate, strWidgetName);
            }
            catch (Exception exception) {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (bIncremental) {
                    this.updateBrowsersIncremental();
                    IEGLDocument currentDocument2 = this.getDocument();
                    if (currentDocument2 != null) {
                        this.restoreModelChangeListeners(currentDocument2);
                    }
                } else {
                    this.updateBrowsers();
                }
                this._pageDesign.setFocus();
            }
        }
        finally {
            this._bOperationInProgress = false;
            if (this._undoManager != null) {
                this._undoManager.operationEnded("");
            }
            if (bIncremental) {
                this.updateBrowsersIncremental();
                IEGLDocument currentDocument3 = this.getDocument();
                if (currentDocument3 != null) {
                    this.restoreModelChangeListeners(currentDocument3);
                }
            } else {
                this.updateBrowsers();
            }
            this._pageDesign.setFocus();
        }
    }

    public void doSourceOperationWidgetDelete(WidgetPart widget) {
        block14: {
            IEGLDocument currentDocument;
            boolean bIncremental = true;
            if (this._undoManager != null) {
                this._undoManager.operationStarting();
            }
            this._bOperationInProgress = true;
            if (bIncremental && (currentDocument = this.getDocument()) != null) {
                this.cleanModelChangeListeners(currentDocument);
            }
            try {
                try {
                    WidgetPart widgetParent = widget.getParent();
                    int iWidgetIndex = widgetParent.getChildIndex(widget);
                    this._editorProvider.delete(widgetParent.getStatementOffset(), widgetParent.getStatementLength(), iWidgetIndex);
                }
                catch (Exception exception) {
                    this._bOperationInProgress = false;
                    if (this._undoManager != null) {
                        this._undoManager.operationEnded("");
                    }
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument2 = this.getDocument();
                        if (currentDocument2 != null) {
                            this.restoreModelChangeListeners(currentDocument2);
                        }
                        break block14;
                    }
                    this.updateBrowsers();
                }
            }
            finally {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (bIncremental) {
                    this.updateBrowsersIncremental();
                    IEGLDocument currentDocument3 = this.getDocument();
                    if (currentDocument3 != null) {
                        this.restoreModelChangeListeners(currentDocument3);
                    }
                } else {
                    this.updateBrowsers();
                }
            }
        }
    }

    public void doSourceOperationWidgetEventValueChange(WidgetPart widget, WidgetEventDescriptor descriptor, String strValueOld, String strValueNew, boolean refresh) {
        block15: {
            IEGLDocument currentDocument;
            boolean bIncremental = true;
            if (this._undoManager != null) {
                this._undoManager.operationStarting();
            }
            this._bOperationInProgress = true;
            if (refresh && bIncremental && (currentDocument = this.getDocument()) != null) {
                this.cleanModelChangeListeners(currentDocument);
            }
            try {
                try {
                    this._editorProvider.setEventValue(widget.getStatementOffset(), widget.getStatementLength(), descriptor.getID(), strValueNew);
                }
                catch (Exception exception) {
                    this._bOperationInProgress = false;
                    if (this._undoManager != null) {
                        this._undoManager.operationEnded("");
                    }
                    if (!refresh) break block15;
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument2 = this.getDocument();
                        if (currentDocument2 != null) {
                            this.restoreModelChangeListeners(currentDocument2);
                        }
                        break block15;
                    }
                    this.updateBrowsers();
                }
            }
            finally {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (refresh) {
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument3 = this.getDocument();
                        if (currentDocument3 != null) {
                            this.restoreModelChangeListeners(currentDocument3);
                        }
                    } else {
                        this.updateBrowsers();
                    }
                }
            }
        }
    }

    public void doSourceOperationWidgetMove(WidgetPart widget, EvDesignOverlayDropLocation location) {
        block21: {
            IEGLDocument currentDocument;
            boolean bIncremental = true;
            if (this._undoManager != null) {
                this._undoManager.operationStarting();
            }
            this._bOperationInProgress = true;
            if (bIncremental && (currentDocument = this.getDocument()) != null) {
                this.cleanModelChangeListeners(currentDocument);
            }
            int[] charactersChanged = new int[2];
            int iWidgetIndex = 0;
            try {
                try {
                    WidgetPart widgetParent = widget.getParent();
                    iWidgetIndex = widgetParent.getChildIndex(widget);
                    PropertyValue layoutData = this._editorProvider.getPropertyValue(widget.getStatementOffset(), widget.getStatementLength(), "layoutData", "");
                    charactersChanged = this._editorProvider.move(widgetParent.getStatementOffset(), widgetParent.getStatementLength(), iWidgetIndex, location.widgetParent.getStatementOffset(), location.widgetParent.getStatementLength(), location.iIndex);
                    int statementOffset = widget.getStatementOffset();
                    if (statementOffset > widgetParent.getStatementOffset() && statementOffset > location.widgetParent.getStatementOffset()) {
                        statementOffset = statementOffset - charactersChanged[0] + charactersChanged[1];
                    } else if (statementOffset > widgetParent.getStatementOffset() && statementOffset < location.widgetParent.getStatementOffset()) {
                        statementOffset -= charactersChanged[0];
                    } else if (statementOffset < widgetParent.getStatementOffset() && statementOffset > location.widgetParent.getStatementOffset()) {
                        statementOffset += charactersChanged[1];
                    }
                    if (location.widgetLayoutData != null) {
                        WidgetLayout layout = location.widgetLayoutData.getWidgetLayout();
                        String[] layoutWidget = location.widgetLayoutData.getWidgetLayout().getLayoutWidgetQualifiedName();
                        WidgetDescriptor widgetDescriptor = WidgetDescriptorRegistry.getInstance(this.getProject()).getDescriptor(layoutWidget[0], layoutWidget[1]);
                        String layoutDataTemplate = "new " + widgetDescriptor.getChildLayoutDataTemplate();
                        layout.updateLayoutData(this._editorProvider, statementOffset, widget, location.widgetLayoutData.getLayoutData(), layoutData, layoutDataTemplate);
                    } else {
                        PropertyValue propertyValue = new PropertyValue("", true);
                        this._editorProvider.setPropertyValue(statementOffset, widget.getStatementLength(), "layoutData", "", propertyValue);
                    }
                    PropertySheetPage.getInstance().setLayoutChanged(true);
                }
                catch (Exception exception) {
                    this._bOperationInProgress = false;
                    if (this._undoManager != null) {
                        this._undoManager.operationEnded("");
                    }
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument2 = this.getDocument();
                        if (currentDocument2 != null) {
                            this.restoreModelChangeListeners(currentDocument2);
                        }
                        break block21;
                    }
                    this.updateBrowsers();
                }
            }
            finally {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (bIncremental) {
                    this.updateBrowsersIncremental();
                    IEGLDocument currentDocument3 = this.getDocument();
                    if (currentDocument3 != null) {
                        this.restoreModelChangeListeners(currentDocument3);
                    }
                } else {
                    this.updateBrowsers();
                }
            }
        }
    }

    public void doSourceOperationWidgetPropertyValueChange(WidgetPart widget, String strPropertyID, String strPropertyType, WidgetPropertyValue valueOld, WidgetPropertyValue valueNew, int propertyContainerType) {
        block15: {
            IEGLDocument currentDocument;
            boolean bIncremental = true;
            if (this._undoManager != null) {
                this._undoManager.operationStarting();
            }
            this._bOperationInProgress = true;
            if (bIncremental && (currentDocument = this.getDocument()) != null) {
                this.cleanModelChangeListeners(currentDocument);
            }
            PropertyValue propertyValue = null;
            try {
                try {
                    PropertyValue propertyValue2 = propertyValue = valueNew == null ? null : new PropertyValue(valueNew.getValues(), valueNew.isEditable());
                    if (propertyContainerType == 1) {
                        this._editorProvider.setPropertyValue(widget.getStatementOffset(), widget.getStatementLength(), strPropertyID, strPropertyType, propertyValue);
                        break block15;
                    }
                    this._editorProvider.setLayoutPropertyValue(widget.getStatementOffset(), widget.getStatementLength(), strPropertyID, strPropertyType, propertyValue);
                }
                catch (Exception exception) {
                    this._bOperationInProgress = false;
                    if (this._undoManager != null) {
                        this._undoManager.operationEnded("");
                    }
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument2 = this.getDocument();
                        if (currentDocument2 != null) {
                            this.restoreModelChangeListeners(currentDocument2);
                        }
                        break block15;
                    }
                    this.updateBrowsers();
                }
            }
            finally {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (bIncremental) {
                    this.updateBrowsersIncremental();
                    IEGLDocument currentDocument3 = this.getDocument();
                    if (currentDocument3 != null) {
                        this.restoreModelChangeListeners(currentDocument3);
                    }
                } else {
                    this.updateBrowsers();
                }
            }
        }
    }

    public void doSourceOperationWidgetPropertyValueChanges(List listPropertyChanges) {
        block16: {
            IEGLDocument currentDocument;
            if (listPropertyChanges == null || listPropertyChanges.size() == 0) {
                return;
            }
            boolean bIncremental = true;
            if (this._undoManager != null) {
                this._undoManager.operationStarting();
            }
            this._bOperationInProgress = true;
            if (bIncremental && (currentDocument = this.getDocument()) != null) {
                this.cleanModelChangeListeners(currentDocument);
            }
            try {
                try {
                    int i = 0;
                    while (i < listPropertyChanges.size()) {
                        PropertyChange propertyChange = (PropertyChange)listPropertyChanges.get(i);
                        PropertyValue propertyValue = propertyChange.valueNew == null ? null : new PropertyValue(propertyChange.valueNew.getValues(), propertyChange.valueNew.isEditable());
                        this._editorProvider.setPropertyValue(propertyChange.widget.getStatementOffset(), propertyChange.widget.getStatementLength(), propertyChange.strPropertyID, propertyChange.strPropertyType, propertyValue);
                        ++i;
                    }
                }
                catch (Exception exception) {
                    this._bOperationInProgress = false;
                    if (this._undoManager != null) {
                        this._undoManager.operationEnded("");
                    }
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument2 = this.getDocument();
                        if (currentDocument2 != null) {
                            this.restoreModelChangeListeners(currentDocument2);
                        }
                        break block16;
                    }
                    this.updateBrowsers();
                }
            }
            finally {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (bIncremental) {
                    this.updateBrowsersIncremental();
                    IEGLDocument currentDocument3 = this.getDocument();
                    if (currentDocument3 != null) {
                        this.restoreModelChangeListeners(currentDocument3);
                    }
                } else {
                    this.updateBrowsers();
                }
            }
        }
    }

    public void doSourceOperation(EvSourceOperation operation) {
        block14: {
            IEGLDocument currentDocument;
            boolean bIncremental = true;
            if (this._undoManager != null) {
                this._undoManager.operationStarting();
            }
            this._bOperationInProgress = true;
            if (bIncremental && (currentDocument = this.getDocument()) != null) {
                this.cleanModelChangeListeners(currentDocument);
            }
            try {
                try {
                    operation.doSourceOperation(this._editorProvider);
                }
                catch (Exception exception) {
                    this._bOperationInProgress = false;
                    if (this._undoManager != null) {
                        this._undoManager.operationEnded("");
                    }
                    if (bIncremental) {
                        this.updateBrowsersIncremental();
                        IEGLDocument currentDocument2 = this.getDocument();
                        if (currentDocument2 != null) {
                            this.restoreModelChangeListeners(currentDocument2);
                        }
                        break block14;
                    }
                    this.updateBrowsers();
                }
            }
            finally {
                this._bOperationInProgress = false;
                if (this._undoManager != null) {
                    this._undoManager.operationEnded("");
                }
                if (bIncremental) {
                    this.updateBrowsersIncremental();
                    IEGLDocument currentDocument3 = this.getDocument();
                    if (currentDocument3 != null) {
                        this.restoreModelChangeListeners(currentDocument3);
                    }
                } else {
                    this.updateBrowsers();
                }
            }
        }
    }

    @Override
    public void eventChanged(WidgetPart widget, WidgetEventDescriptor descriptor, String strValueOld, String strValueNew, boolean refresh) {
        this.doSourceOperationWidgetEventValueChange(widget, descriptor, strValueOld, strValueNew, refresh);
    }

    public WorkingCopyGenerationResult generateJavaScript() {
        this._editorProvider.generateJavaScript();
        WorkingCopyGenerationResult result = this._editorProvider.getLastGenerationResult();
        return result;
    }

    public Object getAdapter(Class classRequested) {
        if (classRequested == IEGLEditor.class || classRequested == EGLEditor.class) {
            return this._pageSource;
        }
        if (classRequested.equals(IPageDataViewPage.class)) {
            IDocument doc;
            if (this._eglPageDataViewPage == null && (doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) instanceof IEGLDocument) {
                this._eglPageDataViewPage = new PageDataViewPage((IEGLDocument)doc, this);
            }
            return this._eglPageDataViewPage;
        }
        if (classRequested.equals(IContentOutlinePage.class)) {
            IDocument doc;
            if (this._outlinePage == null && (doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) instanceof IEGLDocument) {
                EvDesignOutlinePage outlineDesign = this._pageDesign.getContentOutline();
                this._outlinePage = new EvEditorOutlinePage((IEGLDocument)doc, "#EGLOutlinerContext", this._pageSource, outlineDesign);
                this._outlinePage.addSelectionChangedListener(this);
                outlineDesign._editorOutlinePage = this._outlinePage;
            }
            return this._outlinePage;
        }
        if (classRequested.equals(IAnnotationModel.class)) {
            return this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        }
        if (classRequested.equals(IPropertySheetPage.class)) {
            return PropertySheetPage.getInstance();
        }
        if (classRequested.equals(IEvPropertySheetPageAdapter.class)) {
            return this;
        }
        return super.getAdapter(classRequested);
    }

    public IEGLDocument getDocument() {
        IEditorInput input = this.getEditorInput();
        IDocumentProvider provider = this.getDocumentProvider();
        IDocument document = provider.getDocument((Object)input);
        return (IEGLDocument)document;
    }

    public IDocumentProvider getDocumentProvider() {
        return this._pageSource.getDocumentProvider();
    }

    @Override
    public String getDocumentStatement(WidgetPart widget) {
        if (widget == null) {
            return "";
        }
        IEGLDocument document = this.getDocument();
        if (document == null) {
            return "";
        }
        String strStatement = null;
        try {
            strStatement = document.get(widget.getStatementOffset(), widget.getStatementLength());
        }
        catch (BadLocationException badLocationException) {}
        if (strStatement == null) {
            return "";
        }
        return strStatement;
    }

    protected IDocumentUndoManager getDocumentUndoManager() {
        return DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)this.getDocument());
    }

    @Override
    public EvEditorProvider getEditorProvider() {
        return this._editorProvider;
    }

    @Override
    public String[] getEventHandlingFunctionNames() {
        return this._editorProvider.getEventHandlingFunctionNames();
    }

    @Override
    public WidgetPropertyValue getEventValue(WidgetPart widget, String strEventName) {
        EventValue eventValue = this._editorProvider.getEventValue(widget.getStatementOffset(), widget.getStatementLength(), strEventName);
        if (eventValue == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(eventValue.getValue());
        return new WidgetPropertyValue(list, eventValue.isEditable());
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)editorInput).getFile();
    }

    public CTabFolder getPageFolder() {
        return (CTabFolder)this.getContainer();
    }

    public int getPageIndex() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        return tabFolder.getSelectionIndex();
    }

    public EGLEditor getPageSource() {
        return this._pageSource;
    }

    @Override
    public WidgetPropertyValue getPropertyValue(WidgetPart widget, String strPropertyName, String strPropertyType) {
        PropertyValue propertyValue = this._editorProvider.getPropertyValue(widget.getStatementOffset(), widget.getStatementLength(), strPropertyName, strPropertyType);
        if (propertyValue == null) {
            return null;
        }
        return new WidgetPropertyValue(propertyValue.getValues(), propertyValue.isEditable());
    }

    @Override
    public WidgetPropertyValue getLayoutPropertyValue(WidgetPart widget, String strPropertyName, String strPropertyType) {
        PropertyValue propertyValue = this._editorProvider.getLayoutPropertyValue(widget.getStatementOffset(), widget.getStatementLength(), strPropertyName, strPropertyType);
        if (propertyValue == null) {
            return null;
        }
        return new WidgetPropertyValue(propertyValue.getValues(), propertyValue.isEditable());
    }

    public String getURL() {
        int iPortNumber = EvServer.getInstance().getPortNumber();
        return this._editorProvider.getWebPageURL(Integer.toString(iPortNumber));
    }

    public String getWidgetProjectName(String strWidgetPackageName, String strWidgetTypeName) {
        return this._editorProvider.getWidgetProjectName(strWidgetPackageName, strWidgetTypeName);
    }

    @Override
    public WidgetPart getWidgetSelected() {
        WidgetPart widgetSelected = null;
        if (this.getPageIndex() == 0) {
            widgetSelected = this._pageDesign.getWidgetSelected();
        }
        return widgetSelected;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            String strFileName = ((IFileEditorInput)input).getFile().getName();
            this.setPartName(strFileName);
            this._bTranslationTestMode = strFileName.equalsIgnoreCase("TVT_TVT.egl");
        }
        site.getPage().addPartListener((IPartListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 5);
        WidgetDescriptorRegistry.getInstance(this.getProject()).addWidgetDescriptorRegistryListener(this);
    }

    protected void initializeSource() {
        this._bRuiHandler = this._editorProvider.isVESupportType();
        if (this._editorProvider.isRUIWidget()) {
            this._widgetId = this._editorProvider.getRUIWidgetId();
        }
    }

    public String getWidgetId() {
        return this._widgetId;
    }

    protected void initializeUndoManager() {
        IEGLDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        this._undoManager = new EvEditorUndoManager((IDocument)document);
    }

    public boolean isRuiHandler() {
        return this._bRuiHandler;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isTranslationTestMode() {
        return this._bTranslationTestMode;
    }

    public void modelChanged() {
        this._bWebPageGenerationRequired = true;
        this.updateBrowsers();
        this.getContainer().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EvEditor.this.firePropertyChange(257);
            }
        });
    }

    public void partActivated(IWorkbenchPart part) {
        if (part != this) {
            return;
        }
        this.selectOutlinePage();
        this.updateBrowsers();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void propertyChanged(WidgetPart widget, WidgetPropertyDescriptor descriptor, WidgetPropertyValue valueOld, WidgetPropertyValue valueNew) {
        if (descriptor.getID().equalsIgnoreCase("position")) {
            this.propertyChangedPosition(widget, descriptor, valueOld, valueNew);
            return;
        }
        this.doSourceOperationWidgetPropertyValueChange(widget, descriptor.getID(), descriptor.getType(), valueOld, valueNew, descriptor.getPropertyContainerType());
    }

    public void propertyChangedPosition(WidgetPart widget, WidgetPropertyDescriptor descriptor, WidgetPropertyValue valueOld, WidgetPropertyValue valueNew) {
        ArrayList listValues = valueNew.getValues();
        String strValue = null;
        if (listValues != null && listValues.size() > 0) {
            strValue = (String)listValues.get(0);
        }
        ArrayList<PropertyChange> listChanges = new ArrayList<PropertyChange>();
        if (strValue != null && (strValue.equalsIgnoreCase("\"absolute\"") || strValue.equalsIgnoreCase("\"relative\"") || strValue.equalsIgnoreCase("\"fixed\""))) {
            PropertyChange change = new PropertyChange();
            change.strPropertyID = descriptor.getID();
            change.strPropertyType = descriptor.getType();
            change.valueNew = valueNew;
            change.valueOld = valueOld;
            change.widget = widget;
            listChanges.add(change);
            change = new PropertyChange();
            change.strPropertyID = "x";
            change.strPropertyType = "integer";
            change.valueNew = new WidgetPropertyValue("0");
            change.valueOld = null;
            change.widget = widget;
            listChanges.add(change);
            change = new PropertyChange();
            change.strPropertyID = "y";
            change.strPropertyType = "integer";
            change.valueNew = new WidgetPropertyValue("0");
            change.valueOld = null;
            change.widget = widget;
            listChanges.add(change);
        } else {
            PropertyChange change = new PropertyChange();
            change.strPropertyID = descriptor.getID();
            change.strPropertyType = descriptor.getType();
            change.valueNew = valueNew;
            change.valueOld = valueOld;
            change.widget = widget;
            listChanges.add(change);
            change = new PropertyChange();
            change.strPropertyID = "x";
            change.strPropertyType = "integer";
            change.valueNew = new WidgetPropertyValue("");
            change.valueOld = null;
            change.widget = widget;
            listChanges.add(change);
            change = new PropertyChange();
            change.strPropertyID = "y";
            change.strPropertyType = "integer";
            change.valueNew = new WidgetPropertyValue("");
            change.valueOld = null;
            change.widget = widget;
            listChanges.add(change);
        }
        this.doSourceOperationWidgetPropertyValueChanges(listChanges);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void selectAndRevealLine(int iLine) {
        IDocumentProvider provider = this.getDocumentProvider();
        IDocument document = provider.getDocument((Object)this.getEditorInput());
        try {
            int iStart = document.getLineOffset(iLine - 1);
            int iEnd = document.getLineOffset(iLine);
            this._pageSource.selectAndReveal(iStart, iEnd - iStart);
            this.showSourcePage();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void selectAndRevealRange(int offset, int length) {
        this._pageSource.selectAndReveal(offset, length);
        this.showPage(1);
        this.getContainer().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EvEditor.this._pageSource.setFocus();
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeSelection selection = (TreeSelection)event.getSelection();
        Object objElement = selection.getFirstElement();
        if (objElement instanceof WidgetPart) {
            this._pageDesign.selectWidget((WidgetPart)objElement);
            PropertySheetPage.getInstance().widgetSelected((WidgetPart)objElement, this);
        } else {
            this._pageSource.doSelectionChanged(event);
        }
    }

    protected void selectOutlinePage() {
        if (this._outlinePage == null) {
            return;
        }
        switch (this.getPageIndex()) {
            case 0: {
                this._outlinePage.showPage(0);
                break;
            }
            case 1: {
                this._outlinePage.showPage(1);
                break;
            }
            case 2: {
                this._outlinePage.showPage(3);
            }
        }
    }

    protected void selectPageDataViewPage() {
        if (this._eglPageDataViewPage == null) {
            return;
        }
        switch (this.getPageIndex()) {
            case 0: {
                this._eglPageDataViewPage.showPage(0);
                break;
            }
            case 1: {
                this._eglPageDataViewPage.showPage(1);
                break;
            }
            case 2: {
                this._eglPageDataViewPage.showPage(3);
            }
        }
    }

    protected void setInput(IEditorInput input) {
        if (this.getEditorInput() == null) {
            super.setInput(input);
            return;
        }
        IEGLDocument currentDocument = this.getDocument();
        if (currentDocument != null) {
            this.cleanModelChangeListeners(currentDocument);
        }
        super.setInput(input);
        currentDocument = this.getDocument();
        if (currentDocument != null) {
            currentDocument.addModelChangeListener((IEGLModelChangeListener)this);
        }
        if (this._editorProvider != null) {
            this._editorProvider.cleanupGeneratedJavaScript();
        }
        this._editorProvider = new EvEditorProvider(this._pageSource);
        this._pageDesign.inputChanged(input);
        this._pagePreview.inputChanged(input);
        final String strTitle = this._pageSource.getTitle();
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                EvEditor.this.setPartName(strTitle);
                EvEditor.this._bWebPageGenerationRequired = true;
                EvEditor.this._pageDesign._bFullRefresh = true;
                EvEditor.this._pagePreview._bFullRefresh = true;
                EvEditor.this.updateBrowsers();
            }
        });
    }

    public void showPage(int iPageIndex) {
        if (iPageIndex < 0 || iPageIndex > 2) {
            return;
        }
        if (this._eglPageDataViewPage != null) {
            this._eglPageDataViewPage.showPage(iPageIndex);
        }
        this.setActivePage(iPageIndex);
        PropertySheetPage.getInstance().widgetSelected(this.getWidgetSelected(), this);
    }

    public void showSourcePage() {
        if (this.getPageCount() > 1 && this.getPageIndex() != 1) {
            this.showPage(1);
        }
    }

    protected void updateBrowsers() {
        boolean bRuiHandlerCurrent;
        if (!this._bWebPageGenerationRequired) {
            return;
        }
        if (this._bOperationInProgress) {
            return;
        }
        int iPageIndex = this.getPageIndex();
        if (iPageIndex != 1 && ((bRuiHandlerCurrent = this._editorProvider.isVESupportType()) || bRuiHandlerCurrent != this._bRuiHandler)) {
            this._bRuiHandler = bRuiHandlerCurrent;
            switch (iPageIndex) {
                case 0: {
                    WorkingCopyGenerationResult result = this.generateJavaScript();
                    this._pageDesign.updateBrowser(result);
                    this._pagePreview.updateBrowser(result);
                    this._bWebPageGenerationRequired = false;
                    if (result.hasError()) {
                        this._pageDesign.selectWidget(null);
                    }
                    this._editorProvider.clearCache();
                    break;
                }
                case 2: {
                    WorkingCopyGenerationResult result = this.generateJavaScript();
                    this._pagePreview.updateBrowser(result);
                    this._pageDesign.updateBrowser(result);
                    this._bWebPageGenerationRequired = false;
                    if (!result.hasError()) break;
                    this._pageDesign.selectWidget(null);
                }
            }
            this._bRuiHandler = bRuiHandlerCurrent;
            if (!this._bRuiHandler && this._outlinePage != null) {
                this._outlinePage.update();
            }
        }
    }

    protected void updateBrowsersIncremental() {
        if (this._bOperationInProgress) {
            return;
        }
        int iPageIndex = this.getPageIndex();
        switch (iPageIndex) {
            case 0: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pageDesign.updateBrowserIncremental(result);
                this._pagePreview.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
                break;
            }
            case 2: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pagePreview.updateBrowserIncremental(result);
                this._pageDesign.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
            }
        }
    }

    protected void changeProperty(WidgetPart widget, String property, String value, int totalCharactersChanged) {
        if (this._bOperationInProgress) {
            return;
        }
        int iPageIndex = this.getPageIndex();
        switch (iPageIndex) {
            case 0: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pageDesign.changeProperty(result, widget, property, value, totalCharactersChanged);
                this._bWebPageGenerationRequired = false;
                break;
            }
            case 2: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pagePreview.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
            }
        }
    }

    protected void moveWidget(WidgetPart widget, WidgetPart targetParent, int oldIndex, int newIndex, int[] charactersChanged) {
        if (this._bOperationInProgress) {
            return;
        }
        int iPageIndex = this.getPageIndex();
        switch (iPageIndex) {
            case 0: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pageDesign.moveWidget(result, widget, targetParent, oldIndex, newIndex, charactersChanged);
                this._pagePreview.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
                break;
            }
            case 2: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pageDesign.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
            }
        }
    }

    protected void deleteWidget(WidgetPart widget, int totalCharactersRemoved) {
        if (this._bOperationInProgress) {
            return;
        }
        int iPageIndex = this.getPageIndex();
        switch (iPageIndex) {
            case 0: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pageDesign.deleteWidget(result, widget, totalCharactersRemoved);
                this._pagePreview.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
                break;
            }
            case 2: {
                WorkingCopyGenerationResult result = this.generateJavaScript();
                this._pageDesign.updateBrowserIncremental(result);
                this._bWebPageGenerationRequired = false;
            }
        }
    }

    public void updateTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta == null) {
            return false;
        }
        IFile file = this.getFile();
        if (file == null) {
            return false;
        }
        IPath path = file.getFullPath();
        if (path == null) {
            return false;
        }
        IResourceDelta fileDelta = delta.findMember(file.getProject().getFile(".eglPath").getFullPath());
        if (fileDelta != null) {
            switch (fileDelta.getKind()) {
                case 4: {
                    if ((fileDelta.getFlags() & 0x100) != 0) {
                        IEditorInput inputSource = this._pageSource.getEditorInput();
                        if (inputSource == null) {
                            return false;
                        }
                        this.setInput(inputSource);
                    }
                    return false;
                }
            }
        }
        if ((fileDelta = delta.findMember(path)) == null) {
            if (this._pageSource == null) {
                return false;
            }
            IEditorInput inputSource = this._pageSource.getEditorInput();
            if (inputSource == null) {
                return false;
            }
            IEditorInput input = this.getEditorInput();
            if (input == null) {
                return false;
            }
            if (input != inputSource) {
                this.setInput(inputSource);
            }
            return false;
        }
        switch (fileDelta.getKind()) {
            case 2: {
                if ((fileDelta.getFlags() & 0x2000) != 0) {
                    IPath pathA = path;
                    IPath pathB = fileDelta.getMovedToPath();
                    if (pathB == null) {
                        return false;
                    }
                    IPath pathA2 = pathA.removeLastSegments(1);
                    IPath pathB2 = pathB.removeLastSegments(1);
                    if (pathA2 == null || pathB2 == null) {
                        return false;
                    }
                    if (pathA2.equals((Object)pathB2)) break;
                    this.close(false);
                    break;
                }
                this.close(false);
            }
        }
        return false;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void widgetDescriptorRegistryChanged() {
        activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        imageRegistry = activator.getImageRegistry();
        if (imageRegistry == null) {
            return;
        }
        widgetDescriptorRegistry = WidgetDescriptorRegistry.getInstance(this.getProject());
        if (widgetDescriptorRegistry == null) {
            return;
        }
        iterGroups = widgetDescriptorRegistry.getDescriptorGroups();
        if (iterGroups != null) ** GOTO lbl24
        return;
lbl-1000:
        // 1 sources

        {
            group = (WidgetDescriptorGroup)iterGroups.next();
            listDescriptors = group.getWidgetDescriptors();
            if (listDescriptors == null) continue;
            i = 0;
            while (i < listDescriptors.size()) {
                widgetDescriptor = (WidgetDescriptor)listDescriptors.get(i);
                if (widgetDescriptor != null && (strWidgetID = widgetDescriptor.getID()) != null && (imageDescriptor = EvPaletteRoot.getImageDescriptorForNodeType(strWidgetID)) != null && (image = imageDescriptor.createImage()) != null) {
                    imageRegistry.remove(strWidgetID);
                    imageRegistry.put(strWidgetID, image);
                }
                ++i;
            }
lbl24:
            // 3 sources

            ** while (iterGroups.hasNext())
        }
lbl25:
        // 1 sources

        if (this._outlinePage != null) {
            this._outlinePage.update();
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() instanceof CTabFolder) {
            this.updateBrowsers();
            PropertySheetPage.getInstance().widgetSelected(this.getWidgetSelected(), this);
            this.selectOutlinePage();
            this.selectPageDataViewPage();
            if (this.getPageIndex() == 0) {
                IViewReference[] references = this.getEditorSite().getPage().getViewReferences();
                int i = 0;
                while (i < references.length) {
                    if (references[i].getId().equals("org.eclipse.gef.ui.palette_view")) {
                        PaletteView paletteView = (PaletteView)references[i].getPart(true);
                        paletteView.partActivated(this.getEditorSite().getPart());
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public void widgetSelectedFromDesignPage(WidgetPart widget) {
        int iStatementOffset;
        if (this._outlinePage != null) {
            this._outlinePage.widgetSelectedFromDesignPage(widget);
        }
        PropertySheetPage.getInstance().widgetSelected(widget, this);
        if (widget != null && (iStatementOffset = widget.getStatementOffset()) > -1) {
            this._pageSource.selectAndReveal(iStatementOffset, 0);
        }
    }

    public void selectAndReveal(int start, int length) {
        this.showSourcePage();
        this._pageSource.selectAndReveal(start, length);
    }

    private void cleanModelChangeListeners(IEGLDocument currentDocument) {
        currentDocument.removeModelChangeListener((IEGLModelChangeListener)this);
        if (this._eglPageDataViewPage != null) {
            currentDocument.removeModelChangeListener((IEGLModelChangeListener)this._eglPageDataViewPage);
        }
    }

    private void restoreModelChangeListeners(IEGLDocument currentDocument) {
        currentDocument.addModelChangeListener((IEGLModelChangeListener)this);
        if (this._eglPageDataViewPage != null) {
            currentDocument.addModelChangeListener((IEGLModelChangeListener)this._eglPageDataViewPage);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new MultiPageEditorSite(this, editor){

            public String getId() {
                return EvEditor.this.getSite().getId();
            }
        };
    }

    public EGLEditor getEGLEditor() {
        return this._pageSource;
    }

    public boolean isEditable() {
        return this._pageSource.isEditable();
    }

    public void doRevertToSaved() {
        this._pageSource.doRevertToSaved();
    }

    public void setAction(String actionID, IAction action) {
        this._pageSource.setAction(actionID, action);
    }

    public IAction getAction(String actionId) {
        return this._pageSource.getAction(actionId);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        this._pageSource.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void removeActionActivationCode(String actionId) {
        this._pageSource.removeActionActivationCode(actionId);
    }

    public boolean showsHighlightRangeOnly() {
        return this._pageSource.showsHighlightRangeOnly();
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this._pageSource.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        this._pageSource.setHighlightRange(offset, length, moveCursor);
    }

    public IRegion getHighlightRange() {
        return this._pageSource.getHighlightRange();
    }

    public void resetHighlightRange() {
        this._pageSource.resetHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        return this._pageSource.getSelectionProvider();
    }
}

