/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.wizards.ProjectConversionOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class ConvertToEGLProjectAction
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchSite fSite;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }

    public void run(IAction action) {
        try {
            for (IResource resource : this.fSelection) {
                IResource adaptable;
                IProject project;
                if (resource == null || !(resource instanceof IAdaptable) || (project = (IProject)(adaptable = resource).getAdapter(IProject.class)) == null) continue;
                ProjectConversionOperation op = new ProjectConversionOperation(project, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                this.fSite.getWorkbenchWindow().run(true, true, (IRunnableWithProgress)op);
            }
        }
        catch (Exception e) {
            EGLLogger.log((Object)this, e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
    }
}

