/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectItemModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SelectTagConverter
extends AbstractTagConverter {
    public SelectTagConverter(Element host) {
        super(host);
    }

    protected List getSelectItems(Element parent) {
        ArrayList<SelectItemModel> result = new ArrayList<SelectItemModel>();
        NodeList nl = parent.getChildNodes();
        int i = 0;
        int size = nl.getLength();
        while (i < size) {
            Node child = nl.item(i);
            if (child instanceof Element) {
                Element ele = (Element)child;
                String tagname = ele.getLocalName();
                if ("selectItem".equalsIgnoreCase(tagname)) {
                    SelectItemModel item = new SelectItemModel();
                    item.setDescription(ele.getAttribute("itemDescription"));
                    item.setLabel(ele.getAttribute("itemLabel"));
                    item.setItemValue(ele.getAttribute("itemValue"));
                    item.setValue(ele.getAttribute("value"));
                    item.setId(ele.getAttribute("id"));
                    item.setDisabled("true".equalsIgnoreCase(ele.getAttribute("itemDisabled")));
                    result.add(item);
                } else if ("selectItems".equalsIgnoreCase(tagname)) {
                    String value = ele.getAttribute("value");
                    if (value == null || value.length() == 0) {
                        value = "value";
                    }
                    SelectItemModel item1 = new SelectItemModel();
                    item1.setValue(String.valueOf(value) + "_1");
                    item1.setId(ele.getAttribute("id"));
                    result.add(item1);
                    SelectItemModel item2 = new SelectItemModel();
                    item2.setValue(String.valueOf(value) + "_2");
                    item2.setId(ele.getAttribute("id"));
                    result.add(item2);
                }
            }
            ++i;
        }
        return result;
    }

    public SelectItemModel getDefault(Element parent) {
        SelectItemModel item = new SelectItemModel();
        if (parent.getLocalName().equals("selectOneRadio")) {
            item.setLabel("radio");
        } else if (parent.getLocalName().equals("selectManyCheckbox")) {
            item.setLabel("checkBox");
        } else {
            item.setLabel(parent.getLocalName());
        }
        return item;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return true;
    }
}

