/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;

class RemovedHandler
extends ResponseHandler {
    RemovedHandler() {
    }

    public String getResponseID() {
        return "Removed";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryFile = session.readLine();
        String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        ICVSFile mFile = mParent.getFile(fileName);
        if (!mFile.isManaged()) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSMessages.RemovedHandler_invalid, (Object[])new String[]{new Path(null, localDir).append(fileName).toString()}), session.getLocalRoot());
            throw new CVSException((IStatus)status);
        }
        try {
            if (mFile.isReadOnly()) {
                mFile.setReadOnly(false);
            }
            mFile.delete();
            mFile.unmanage(null);
        }
        catch (CVSException e) {
            CVSStatus status = new CVSStatus(4, -28, NLS.bind((String)CVSMessages.RemovedHandler_0, (Object[])new String[]{this.getPath(mFile)}), (Throwable)((Object)e), session.getLocalRoot());
            session.handleResponseError((IStatus)status);
        }
    }

    private String getPath(ICVSFile file) {
        IResource resource = file.getIResource();
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        try {
            return file.getRepositoryRelativePath();
        }
        catch (CVSException cVSException) {
            return file.getName();
        }
    }
}

