/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.ISystemPartBindingLoadedRequestor;
import org.eclipse.edt.compiler.SystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.SystemPackageMOFPathEntry;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2Binding;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ZipFileObjectStore;

public class SystemPackageBuildPathEntryFactory
implements ISystemPackageBuildPathEntryFactory {
    IEnvironment irEnv;
    ISystemEnvironment sysEnv;
    Mof2Binding converter;

    public SystemPackageBuildPathEntryFactory(Mof2Binding converter) {
        this.converter = converter;
    }

    private SystemPackageBuildPathEntry createEGLEntry(String path, ISystemPartBindingLoadedRequestor req) {
        SystemPackageBuildPathEntry entry = new SystemPackageBuildPathEntry(this.sysEnv, path, req, ".eglxml", this.converter);
        ZipFileObjectStore store = new ZipFileObjectStore(new File(path), this.irEnv, "XML", ".eglxml", "egl", (IZipFileEntryManager)entry);
        entry.setStore((ObjectStore)store);
        this.irEnv.registerObjectStore("egl", (ObjectStore)store);
        return entry;
    }

    private SystemPackageMOFPathEntry createMOFEntry(String path, ISystemPartBindingLoadedRequestor req) {
        SystemPackageMOFPathEntry entry = new SystemPackageMOFPathEntry(this.sysEnv, path, req, ".mofxml", this.converter);
        ZipFileObjectStore store = new ZipFileObjectStore(new File(path), this.irEnv, "XML", ".mofxml", (IZipFileEntryManager)entry);
        entry.setStore((ObjectStore)store);
        this.irEnv.registerObjectStore("mof", (ObjectStore)store);
        return entry;
    }

    @Override
    public List<ISystemPackageBuildPathEntry> createEntries(ISystemEnvironment sysEnv, IEnvironment irEnv, File[] files, ISystemPartBindingLoadedRequestor req) {
        this.irEnv = irEnv;
        this.sysEnv = sysEnv;
        ArrayList<ISystemPackageBuildPathEntry> list = new ArrayList<ISystemPackageBuildPathEntry>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                if (file.getName().endsWith(".eglar")) {
                    list.add(this.createEGLEntry(file.getAbsolutePath(), req));
                } else if (file.getName().endsWith(".mofar")) {
                    list.add(this.createMOFEntry(file.getAbsolutePath(), req));
                }
            }
            ++i;
        }
        return list;
    }
}

