/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.io.ZipFileBuildPathEntry;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2Binding;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;

public abstract class ZipFileBindingBuildPathEntry
extends ZipFileBuildPathEntry
implements IBuildPathEntry,
IZipFileEntryManager {
    private ObjectStore store;
    private String fileExtension;
    protected Mof2Binding converter;
    private HashMap partBindingsByPackage = new HashMap();
    private HashMap partBindingsWithoutPackage = new HashMap();

    public ZipFileBindingBuildPathEntry(String path, String fileExtension, Mof2Binding converter) {
        super(path);
        this.fileExtension = fileExtension;
        this.converter = converter;
        this.processEntries();
    }

    protected abstract IEnvironment getEnvironment();

    @Override
    public void clear() {
        super.clear();
        this.partBindingsByPackage.clear();
        this.partBindingsWithoutPackage.clear();
        if (this.store instanceof CachingObjectStore) {
            ((CachingObjectStore)this.store).clearCache();
        }
    }

    @Override
    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding partBinding = this.getCachedPartBinding(packageName, partName);
        if (partBinding == null) {
            partBinding = this.getPartBinding(this.getEntry(packageName, partName));
        }
        return partBinding;
    }

    @Override
    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding partBinding = null;
        if (packageName == null || packageName.length == 0) {
            partBinding = (IPartBinding)this.partBindingsWithoutPackage.get(partName);
        } else {
            Map partpackage = (Map)this.partBindingsByPackage.get(packageName);
            if (partpackage != null) {
                partBinding = (IPartBinding)partpackage.get(partName);
            }
        }
        return partBinding;
    }

    @Override
    public void addPartBindingToCache(IPartBinding binding) {
        this.getPackagePartBinding(InternUtil.intern((String[])binding.getPackageName())).put(InternUtil.intern((String)binding.getName()), binding);
    }

    @Override
    public boolean isProject() {
        return false;
    }

    @Override
    public int hasPart(String[] packageName, String partName) {
        IPartBinding partBinding = this.getPartBinding(packageName, partName);
        if (partBinding != null) {
            return partBinding.getKind();
        }
        return 1;
    }

    @Override
    public Part findPart(String[] packageName, String partName) throws PartNotFoundException {
        EObject obj;
        if (this.hasPart(packageName, partName) != 1 && (obj = this.getPartObject(this.getEntry(packageName, partName))) instanceof Part) {
            return (Part)obj;
        }
        return null;
    }

    protected Map getPackagePartBinding(String[] packageName) {
        HashMap map = (HashMap)this.partBindingsByPackage.get(packageName);
        if (map == null) {
            map = new HashMap();
            this.partBindingsByPackage.put(packageName, map);
        }
        return map;
    }

    public HashMap getPartBindingsWithoutPackage() {
        return this.partBindingsWithoutPackage;
    }

    @Override
    public IEnvironment getRealizingEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getFileExtension() {
        return this.fileExtension;
    }

    public void setStore(ObjectStore store) {
        this.store = store;
    }

    public IPartBinding getPartBinding(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        IPartBinding retVal = null;
        String partname = this.getPartName(entry);
        String[] packageName = InternUtil.intern((String[])this.getPackageName(entry));
        retVal = this.getCachedPartBinding(packageName, partname);
        if (retVal != null) {
            return retVal;
        }
        EObject part = this.getPartObject(entry);
        if (part != null && (retVal = this.getConverter().convert(part)) != null) {
            Map partpackage = this.getPackagePartBinding(InternUtil.intern((String[])retVal.getPackageName()));
            partpackage.put(InternUtil.intern((String)retVal.getName()), retVal);
            retVal.setEnvironment(this.getEnvironment());
            this.bindingLoaded(retVal);
        }
        return retVal;
    }

    protected EObject getPartObject(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        String key = this.convertToStoreKey(entry);
        try {
            return this.store.get(key);
        }
        catch (DeserializationException e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    protected void bindingLoaded(IPartBinding partBinding) {
    }

    public ObjectStore getObjectStore() {
        return this.store;
    }

    @Override
    public ObjectStore[] getObjectStores() {
        return new ObjectStore[]{this.store};
    }

    public boolean hasEntry(String entry) {
        entry = entry.toUpperCase().toLowerCase();
        String[] entries = this.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            if (entry.equalsIgnoreCase(entries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Mof2Binding getConverter() {
        return this.converter;
    }
}

