/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationBindingForElement;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DataItemCopiedAnntotationBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class Binding
implements IBinding {
    List annotations = Collections.EMPTY_LIST;
    protected String caseSensitiveInternedName;
    private transient String caseInsensitiveInternedName;

    public Binding(String caseSensitiveInternedName) {
        this.caseSensitiveInternedName = caseSensitiveInternedName;
    }

    protected Binding(Binding old) {
        if (old.annotations == Collections.EMPTY_LIST) {
            old.annotations = new ArrayList();
        }
        this.annotations = old.annotations;
        this.caseSensitiveInternedName = old.caseSensitiveInternedName;
        this.caseInsensitiveInternedName = old.caseInsensitiveInternedName;
    }

    @Override
    public String getName() {
        if (this.caseSensitiveInternedName == null) {
            return null;
        }
        if (this.caseInsensitiveInternedName == null) {
            this.caseInsensitiveInternedName = InternUtil.intern((String)this.caseSensitiveInternedName);
        }
        return this.caseInsensitiveInternedName;
    }

    @Override
    public String getCaseSensitiveName() {
        return this.caseSensitiveInternedName;
    }

    @Override
    public boolean isDataBinding() {
        return false;
    }

    @Override
    public boolean isFunctionBinding() {
        return false;
    }

    @Override
    public boolean isPackageBinding() {
        return false;
    }

    @Override
    public boolean isTypeBinding() {
        return false;
    }

    @Override
    public boolean isAnnotationBinding() {
        return false;
    }

    @Override
    public List getAnnotations() {
        return this.annotations;
    }

    @Override
    public void addAnnotation(IAnnotationBinding annotation) {
        if (this.annotations == Collections.EMPTY_LIST) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
    }

    @Override
    public void addAnnotations(Collection annotations) {
        if (this.annotations == Collections.EMPTY_LIST) {
            this.annotations = new ArrayList();
        }
        this.annotations.addAll(annotations);
    }

    @Override
    public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType) {
        return this.getAnnotation(annotationType, this.annotations);
    }

    @Override
    public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType, int index) {
        return this.getAnnotation(annotationType, this.annotations, index);
    }

    public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType, List list) {
        IAnnotationBinding lastFound = null;
        for (IAnnotationBinding binding : list) {
            if (binding.isAnnotationField() || binding.getAnnotationType() != annotationType || binding.isForElement()) continue;
            lastFound = binding;
        }
        return lastFound;
    }

    public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType, List list, int index) {
        IAnnotationBinding lastFound = null;
        for (IAnnotationBinding binding : list) {
            if (binding.getAnnotationType() != annotationType || !binding.isForElement() || ((AnnotationBindingForElement)binding).getIndex() != index) continue;
            lastFound = binding;
        }
        if (lastFound == null) {
            return this.getAnnotation(annotationType, list);
        }
        return lastFound;
    }

    @Override
    public IAnnotationBinding getAnnotation(String[] packageName, String annotationName) {
        return this.getAnnotation(packageName, annotationName, this.annotations);
    }

    @Override
    public IAnnotationBinding getAnnotation(String[] packageName, String annotationName, int index) {
        return this.getAnnotation(packageName, annotationName, this.annotations, index);
    }

    public IAnnotationBinding getAnnotation(String[] packageName, String annotationName, List list) {
        IAnnotationBinding lastFound = null;
        if (list.size() > 0) {
            String[] internedPackageName = InternUtil.intern((String[])packageName);
            String internedAnnotationName = InternUtil.intern((String)annotationName);
            for (IAnnotationBinding binding : list) {
                ITypeBinding annotationType = binding.getType();
                if (annotationType == null || annotationType.getPackageName() != internedPackageName || annotationType.getName() != internedAnnotationName || binding.isForElement()) continue;
                lastFound = binding;
            }
        }
        return lastFound;
    }

    public IAnnotationBinding getAnnotation(String[] packageName, String annotationName, List list, int index) {
        IAnnotationBinding lastFound = null;
        String[] internedPackageName = InternUtil.intern((String[])packageName);
        String internedAnnotationName = InternUtil.intern((String)annotationName);
        for (IAnnotationBinding binding : list) {
            IAnnotationTypeBinding annotationType = binding.getAnnotationType();
            if (annotationType == null || annotationType.getPackageName() != internedPackageName || annotationType.getName() != internedAnnotationName || !binding.isForElement() || ((AnnotationBindingForElement)binding).getIndex() != index) continue;
            lastFound = binding;
        }
        if (lastFound == null) {
            return this.getAnnotation(packageName, annotationName, list);
        }
        return lastFound;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.caseSensitiveInternedName = InternUtil.internCaseSensitive((String)this.caseSensitiveInternedName);
    }

    @Override
    public byte[] getSerializedBytes() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
        return byteStream.toByteArray();
    }

    @Override
    public InputStream getSerializedInputStream() throws IOException {
        return new ByteArrayInputStream(this.getSerializedBytes());
    }

    protected void writeTypeBindingReference(ObjectOutputStream out, ITypeBinding typeBinding) throws IOException {
        if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding.isPartBinding()) {
            out.writeBoolean(true);
            out.writeInt(typeBinding.getKind());
            out.writeUnshared(typeBinding.getPackageName());
            out.writeUTF(typeBinding.getCaseSensitiveName());
        } else {
            out.writeBoolean(false);
            out.writeObject(typeBinding);
        }
    }

    protected ITypeBinding readTypeBindingReference(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isPart = in.readBoolean();
        if (isPart) {
            int partKind = in.readInt();
            String[] packageName = (String[])in.readUnshared();
            if (packageName.length != 0) {
                packageName = InternUtil.intern((String[])packageName);
            }
            String partName = InternUtil.internCaseSensitive((String)in.readUTF());
            return PartBinding.newPartBinding(partKind, packageName, partName);
        }
        return (ITypeBinding)in.readObject();
    }

    @Override
    public boolean isUsedTypeBinding() {
        return false;
    }

    protected ITypeBinding realizeTypeBinding(ITypeBinding typeBinding, IEnvironment environment) {
        if (Binding.isValidBinding(typeBinding)) {
            FormGroupBinding fg;
            FormBinding form;
            if (typeBinding.getKind() == 8 && (form = (FormBinding)typeBinding).getEnclosingFormGroup() != null && Binding.isValidBinding(fg = (FormGroupBinding)this.realizeTypeBinding(form.getEnclosingFormGroup(), environment))) {
                return fg.findForm(typeBinding.getName());
            }
            if (!typeBinding.isValid()) {
                if (typeBinding.getKind() == 2) {
                    typeBinding = this.realizeTypeBinding(((ArrayTypeBinding)typeBinding).getElementType(), environment);
                    typeBinding = ArrayTypeBinding.getInstance(typeBinding);
                } else {
                    IPartBinding partBinding = (IPartBinding)typeBinding;
                    if (partBinding.getEnvironment() != null) {
                        return partBinding.realize();
                    }
                    if (environment != null) {
                        IPartBinding result = environment.getPartBinding(partBinding.getPackageName(), partBinding.getName());
                        if (result != null && result != IBinding.NOT_FOUND_BINDING && typeBinding.isNullable()) {
                            return result.getNullableInstance();
                        }
                        return result;
                    }
                }
            }
        }
        return typeBinding;
    }

    protected ITypeBinding getTypeBinding(ITypeBinding typeBinding, IDataBinding dataBinding) {
        if (typeBinding == null || typeBinding == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (typeBinding.getKind() == 2) {
            ArrayTypeBinding array = (ArrayTypeBinding)typeBinding;
            boolean isNullable = array.isNullable();
            ITypeBinding result = ArrayTypeBinding.getInstance(this.getTypeBinding(array.getElementType(), dataBinding));
            if (isNullable) {
                result = result.getNullableInstance();
            }
            return result;
        }
        if (typeBinding.getKind() == 17) {
            DataItemBinding dataItem = (DataItemBinding)typeBinding;
            if (!dataItem.isValid) {
                dataItem = (DataItemBinding)dataItem.realize();
            }
            this.setDataItemReference(dataItem);
            this.copyAnnotations(dataItem, dataBinding);
            if (dataItem.getPrimitiveTypeBinding() != null) {
                return dataItem.getPrimitiveTypeBinding();
            }
            return PrimitiveTypeBinding.getInstance(Primitive.INT);
        }
        return typeBinding;
    }

    public void setDataItemReference(DataItemBinding item) {
    }

    private void copyAnnotations(DataItemBinding dataItem, IDataBinding dataBinding) {
        if (dataBinding != null) {
            for (IAnnotationBinding annotation : dataItem.getAnnotations()) {
                if (!annotation.getAnnotationType().isApplicableFor(dataBinding)) continue;
                DataItemCopiedAnntotationBinding annotationBinding = new DataItemCopiedAnntotationBinding(annotation.getCaseSensitiveName(), dataBinding.getDeclaringPart(), annotation.getType());
                annotationBinding.addAnnotations(annotation.getAnnotations());
                annotationBinding.addFields(annotation.getAnnotationFields());
                dataBinding.addAnnotation(annotation);
            }
        }
    }

    @Override
    public boolean isOpenUIStatementBinding() {
        return false;
    }

    @Override
    public boolean isCallStatementBinding() {
        return false;
    }

    @Override
    public boolean isExitStatementBinding() {
        return false;
    }

    @Override
    public boolean isTransferStatementBinding() {
        return false;
    }

    @Override
    public boolean isShowStatementBinding() {
        return false;
    }

    @Override
    public byte[] getMD5HashKey() {
        try {
            byte[] bytes = this.getStructurallySignificantBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected byte[] getStructurallySignificantBytes() throws IOException {
        return this.getSerializedBytes();
    }

    public static boolean isValidBinding(IBinding binding) {
        if (binding == null) {
            return false;
        }
        return binding.isValidBinding();
    }

    @Override
    public boolean isValidBinding() {
        return true;
    }

    public void resetAnnotations() {
        this.annotations = Collections.EMPTY_LIST;
    }

    public void clear() {
        this.annotations = Collections.EMPTY_LIST;
    }
}

