/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeDataBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.StaticPartDataBinding;

public class EnumerationTypeBinding
extends PartBinding {
    private List enumerations = Collections.EMPTY_LIST;
    private transient Comparator commaListComparator;
    private transient EnumerationTypeDataBinding staticEnumerationTypeDataBinding;

    public EnumerationTypeBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    protected EnumerationTypeBinding(EnumerationTypeBinding old) {
        super(old);
        if (old.enumerations == Collections.EMPTY_LIST) {
            old.enumerations = new ArrayList();
        }
        this.enumerations = old.enumerations;
        this.commaListComparator = old.commaListComparator;
    }

    @Override
    public int getKind() {
        return 19;
    }

    public IDataBinding getStaticEnumerationTypeDataBinding() {
        if (this.staticEnumerationTypeDataBinding == null) {
            this.staticEnumerationTypeDataBinding = new EnumerationTypeDataBinding(this.getCaseSensitiveName(), this, this);
        }
        return this.staticEnumerationTypeDataBinding;
    }

    public void addEnumeration(EnumerationDataBinding enumeration) {
        if (this.enumerations == Collections.EMPTY_LIST) {
            this.enumerations = new ArrayList();
        }
        this.enumerations.add(enumeration);
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (IDataBinding binding : this.enumerations) {
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    public List getEnumerations() {
        return this.enumerations;
    }

    @Override
    public void clear() {
        super.clear();
        this.enumerations = Collections.EMPTY_LIST;
        this.staticEnumerationTypeDataBinding = null;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    public boolean isSystemEnumerationType() {
        return false;
    }

    public String getEnumerationsAsCommaList() {
        StringBuffer sb = new StringBuffer();
        TreeSet<String> enumerationNames = new TreeSet<String>(this.getCommaListComparator());
        Iterator iter = this.enumerations.iterator();
        while (iter.hasNext()) {
            enumerationNames.add(((EnumerationDataBinding)iter.next()).getCaseSensitiveName());
        }
        iter = enumerationNames.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private Comparator getCommaListComparator() {
        if (this.commaListComparator == null) {
            this.commaListComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareTo((String)o2);
                }
            };
        }
        return this.commaListComparator;
    }

    @Override
    public boolean isDeclarablePart() {
        return false;
    }

    public void setCommaListComparator(Comparator c) {
        this.commaListComparator = c;
    }

    @Override
    public StaticPartDataBinding getStaticPartDataBinding() {
        return (StaticPartDataBinding)this.getStaticEnumerationTypeDataBinding();
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        EnumerationTypeBinding nullable = new EnumerationTypeBinding(this);
        nullable.setNullable(true);
        return nullable;
    }

    @Override
    public boolean isInstantiable() {
        return false;
    }

    @Override
    public boolean isReference() {
        return true;
    }
}

