/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeDataBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.StaticPartDataBinding;

public class ExternalTypeBinding
extends PartBinding {
    private transient ExternalTypeDataBinding staticExternalTypeDataBinding;
    private List declaredFunctions = Collections.EMPTY_LIST;
    private List declaredAndInheritedFunctions = null;
    private List declaredData = Collections.EMPTY_LIST;
    private List declaredAndInheritedData = null;
    private List constructors = Collections.EMPTY_LIST;
    private transient List extendedTypes = Collections.EMPTY_LIST;

    public ExternalTypeBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    private ExternalTypeBinding(ExternalTypeBinding old) {
        super(old);
        if (old.declaredFunctions == Collections.EMPTY_LIST) {
            old.declaredFunctions = new ArrayList();
        }
        if (old.declaredData == Collections.EMPTY_LIST) {
            old.declaredData = new ArrayList();
        }
        if (old.constructors == Collections.EMPTY_LIST) {
            old.constructors = new ArrayList();
        }
        if (old.extendedTypes == Collections.EMPTY_LIST) {
            old.extendedTypes = new ArrayList();
        }
        this.declaredFunctions = old.declaredFunctions;
        this.declaredAndInheritedFunctions = old.declaredAndInheritedFunctions;
        this.declaredData = old.declaredData;
        this.declaredAndInheritedData = old.declaredAndInheritedData;
        this.constructors = old.constructors;
        this.extendedTypes = old.extendedTypes;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    public List getExtendedTypes() {
        return this.getExtendedTypes(new HashSet());
    }

    List getExtendedTypes(Set typesAlreadyProcessed) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        if (!typesAlreadyProcessed.contains(this)) {
            typesAlreadyProcessed.add(this);
            Iterator iter = this.extendedTypes.iterator();
            while (iter.hasNext()) {
                ITypeBinding typeBinding = this.realizeTypeBinding((ITypeBinding)iter.next(), this.getEnvironment());
                if (typesAlreadyProcessed.contains(typeBinding) || typeBinding.getKind() != 28) continue;
                result.add(typeBinding);
                result.addAll(((ExternalTypeBinding)typeBinding).getExtendedTypes(typesAlreadyProcessed));
            }
        }
        return result;
    }

    public void addExtendedType(ITypeBinding typeBinding) {
        if (typeBinding != this) {
            if (this.extendedTypes == Collections.EMPTY_LIST) {
                this.extendedTypes = new ArrayList();
            }
            this.extendedTypes.add(typeBinding);
        }
        this.declaredAndInheritedData = null;
        this.declaredAndInheritedFunctions = null;
    }

    @Override
    public List getDeclaredFunctions() {
        return this.declaredFunctions;
    }

    public void addDeclaredFunction(NestedFunctionBinding declaredFunctionBinding) {
        if (this.declaredFunctions == Collections.EMPTY_LIST) {
            this.declaredFunctions = new ArrayList();
        }
        this.declaredFunctions.add(declaredFunctionBinding);
        this.declaredAndInheritedFunctions = null;
    }

    public List getDeclaredAndInheritedFunctions() {
        if (this.declaredAndInheritedFunctions == null) {
            ArrayList tempDeclaredAndInheritedFunctions = new ArrayList();
            tempDeclaredAndInheritedFunctions.addAll(this.getDeclaredFunctions());
            List extendedTypes = this.getExtendedTypes();
            boolean hasEnvironment = this.getEnvironment() != null;
            for (ExternalTypeBinding et : extendedTypes) {
                tempDeclaredAndInheritedFunctions.addAll(et.getDeclaredFunctions());
                boolean bl = hasEnvironment = hasEnvironment && et.getEnvironment() != null;
            }
            if (hasEnvironment) {
                this.declaredAndInheritedFunctions = tempDeclaredAndInheritedFunctions;
            } else {
                return tempDeclaredAndInheritedFunctions;
            }
        }
        return this.declaredAndInheritedFunctions;
    }

    public List getDeclaredAndInheritedData() {
        if (this.declaredAndInheritedData == null) {
            ArrayList tempDeclaredAndInheritedData = new ArrayList();
            tempDeclaredAndInheritedData.addAll(this.getDeclaredData());
            List extendedTypes = this.getExtendedTypes();
            boolean hasEnvironment = this.getEnvironment() != null;
            for (ExternalTypeBinding et : extendedTypes) {
                tempDeclaredAndInheritedData.addAll(et.getDeclaredData());
                boolean bl = hasEnvironment = hasEnvironment && et.getEnvironment() != null;
            }
            if (hasEnvironment) {
                this.declaredAndInheritedData = tempDeclaredAndInheritedData;
            } else {
                return tempDeclaredAndInheritedData;
            }
        }
        return this.declaredAndInheritedData;
    }

    public List getDeclaredData() {
        return this.declaredData;
    }

    public void addClassField(ClassFieldBinding fieldBinding) {
        if (this.declaredData == Collections.EMPTY_LIST) {
            this.declaredData = new ArrayList();
        }
        this.declaredData.add(fieldBinding);
        this.declaredAndInheritedData = null;
    }

    public List getConstructors() {
        return this.constructors;
    }

    public void addConstructor(ConstructorBinding constructor) {
        if (this.constructors == Collections.EMPTY_LIST) {
            this.constructors = new ArrayList();
        }
        this.constructors.add(constructor);
    }

    @Override
    public int getKind() {
        return 28;
    }

    @Override
    public void clear() {
        super.clear();
        this.constructors = Collections.EMPTY_LIST;
        this.declaredData = Collections.EMPTY_LIST;
        this.declaredAndInheritedData = null;
        this.declaredFunctions = Collections.EMPTY_LIST;
        this.declaredAndInheritedFunctions = null;
        this.extendedTypes = Collections.EMPTY_LIST;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (IDataBinding binding : this.getDeclaredAndInheritedData()) {
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        OverloadedFunctionSet functionSet = new OverloadedFunctionSet();
        for (IDataBinding binding : this.getDeclaredAndInheritedFunctions()) {
            if (binding.getName() != simpleName) continue;
            functionSet.setName(binding.getCaseSensitiveName());
            functionSet.addNestedFunctionBinding(binding);
        }
        List nestedFunctionBindings = functionSet.getNestedFunctionBindings();
        if (nestedFunctionBindings.size() == 1) {
            return (IDataBinding)nestedFunctionBindings.get(0);
        }
        if (!nestedFunctionBindings.isEmpty()) {
            return functionSet;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IDataBinding findPublicData(String simpleName) {
        IDataBinding result = this.findData(simpleName);
        if (IBinding.NOT_FOUND_BINDING != result) {
            if (20 == result.getKind()) {
                if (((NestedFunctionBinding)result).isPrivate()) {
                    return IBinding.NOT_FOUND_BINDING;
                }
            } else if (23 == result.getKind()) {
                OverloadedFunctionSet newSet = new OverloadedFunctionSet();
                newSet.setName(result.getCaseSensitiveName());
                for (NestedFunctionBinding func : ((OverloadedFunctionSet)result).getNestedFunctionBindings()) {
                    if (func.isPrivate()) continue;
                    newSet.addNestedFunctionBinding(func);
                }
                if (newSet.getNestedFunctionBindings().isEmpty()) {
                    return IBinding.NOT_FOUND_BINDING;
                }
                result = newSet;
            } else if (((ClassFieldBinding)result).isPrivate) {
                return IBinding.NOT_FOUND_BINDING;
            }
        }
        return result;
    }

    @Override
    protected IFunctionBinding primFindFunction(String simpleName) {
        Iterator iter = this.getDeclaredAndInheritedFunctions().iterator();
        while (iter.hasNext()) {
            IFunctionBinding binding = (IFunctionBinding)((NestedFunctionBinding)iter.next()).getType();
            if (!binding.getName().equals(simpleName)) continue;
            return binding;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findPublicFunction(String simpleName) {
        IFunctionBinding result = this.findFunction(simpleName);
        if (IBinding.NOT_FOUND_BINDING != result && result.isPrivate()) {
            return IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    @Override
    public boolean isDeclarablePart() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.extendedTypes.size());
        int i = 0;
        while (i < this.extendedTypes.size()) {
            this.writeTypeBindingReference(out, (ITypeBinding)this.extendedTypes.get(i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numExtendedTypes = in.readInt();
        int i = 0;
        while (i < numExtendedTypes) {
            this.addExtendedType(this.readTypeBindingReference(in));
            ++i;
        }
    }

    public IDataBinding getStaticExternalTypeDataBinding() {
        if (this.staticExternalTypeDataBinding == null) {
            this.staticExternalTypeDataBinding = new ExternalTypeDataBinding(this.getCaseSensitiveName(), this, this);
        }
        return this.staticExternalTypeDataBinding;
    }

    @Override
    public StaticPartDataBinding getStaticPartDataBinding() {
        return (StaticPartDataBinding)this.getStaticExternalTypeDataBinding();
    }

    public boolean containsExtendsFor(ExternalTypeBinding et) {
        if (et == this) {
            return true;
        }
        Iterator i = this.getExtendedTypes().iterator();
        while (i.hasNext()) {
            if (i.next() != et) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        ExternalTypeBinding nullable = new ExternalTypeBinding(this);
        nullable.setNullable(true);
        return nullable;
    }

    @Override
    public boolean isInstantiable() {
        for (ConstructorBinding binding : this.getConstructors()) {
            if (binding.getParameters().size() != 0 || !binding.isPrivate()) continue;
            return false;
        }
        return super.isInstantiable();
    }

    public boolean containsStaticFunctions() {
        List allFunctions = this.getDeclaredAndInheritedFunctions();
        Iterator iterator = allFunctions.iterator();
        while (iterator.hasNext()) {
            ITypeBinding funcBinding = ((NestedFunctionBinding)iterator.next()).typeBinding;
            if (!(funcBinding instanceof FunctionBinding) || !((FunctionBinding)funcBinding).isStatic()) continue;
            return true;
        }
        return false;
    }
}

