/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class PartSubTypeAndAnnotationCollector
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private List settingsBlocks = new ArrayList();
    private AnnotationBinding subTypeAnnotationBinding;
    private IPartBinding partBinding;
    private boolean foundSubTypeInSettingsBlock = false;
    private Scope currentScope;
    private AbstractBinder abstractBinder;

    public PartSubTypeAndAnnotationCollector(IPartBinding partBinding, AbstractBinder binder, Scope currentScope, IProblemRequestor problemRequestor) {
        this.partBinding = partBinding;
        this.abstractBinder = binder;
        this.problemRequestor = problemRequestor;
        this.currentScope = currentScope;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        this.settingsBlocks.add(settingsBlock);
        settingsBlock.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                return true;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                IAnnotationTypeBinding typeBinding = null;
                ITypeBinding resolvedType = null;
                try {
                    resolvedType = PartSubTypeAndAnnotationCollector.this.abstractBinder.bindTypeName(annotationExpression.getName());
                }
                catch (ResolutionException resolutionException) {
                    resolvedType = IBinding.NOT_FOUND_BINDING;
                }
                annotationExpression.getName().setBinding(null);
                if (IBinding.NOT_FOUND_BINDING != resolvedType) {
                    AnnotationTypeBindingImpl aTypeBinding;
                    if (resolvedType.isPartBinding() && !resolvedType.isValid() && resolvedType != PartSubTypeAndAnnotationCollector.this.partBinding) {
                        resolvedType = ((IPartBinding)resolvedType).realize();
                    }
                    if (PartSubTypeAndAnnotationCollector.this.hasAnnotation(resolvedType, AnnotationAnnotationTypeBinding.getInstance()) && (aTypeBinding = new AnnotationTypeBindingImpl((FlexibleRecordBinding)resolvedType, PartSubTypeAndAnnotationCollector.this.partBinding)).isPartSubType()) {
                        typeBinding = aTypeBinding;
                    }
                }
                if (typeBinding == null) {
                    typeBinding = AnnotationTypeManager.getAnnotationType(InternUtil.intern((String)annotationExpression.getName().getCanonicalName()));
                }
                if (typeBinding != null && typeBinding.isPartSubType()) {
                    if (typeBinding.isApplicableFor(PartSubTypeAndAnnotationCollector.this.partBinding)) {
                        if (PartSubTypeAndAnnotationCollector.this.subTypeAnnotationBinding == null) {
                            PartSubTypeAndAnnotationCollector.this.subTypeAnnotationBinding = new AnnotationBinding(typeBinding.getCaseSensitiveName(), PartSubTypeAndAnnotationCollector.this.partBinding, typeBinding);
                            PartSubTypeAndAnnotationCollector.this.foundSubTypeInSettingsBlock = true;
                            annotationExpression.getName().setBinding(PartSubTypeAndAnnotationCollector.this.subTypeAnnotationBinding);
                            annotationExpression.getName().setTypeBinding(typeBinding);
                            annotationExpression.setTypeBinding(typeBinding);
                        } else {
                            PartSubTypeAndAnnotationCollector.this.problemRequestor.acceptProblem(annotationExpression.getName(), 2056);
                        }
                    } else {
                        PartSubTypeAndAnnotationCollector.this.problemRequestor.acceptProblem(annotationExpression.getName(), 2057);
                    }
                }
                return false;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }
        });
        return false;
    }

    @Override
    public boolean visit(Record record) {
        if (record.hasSubType()) {
            this.checkSubType(record.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(DataTable dataTable) {
        if (dataTable.hasSubType()) {
            this.checkSubType(dataTable.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Program program) {
        if (program.hasSubType()) {
            this.checkSubType(program.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Library library) {
        if (library.hasSubType()) {
            this.checkSubType(library.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Service service) {
        if (service.hasSubType()) {
            this.checkSubType(service.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Interface intrface) {
        if (intrface.hasSubType()) {
            this.checkSubType(intrface.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(ExternalType externalType) {
        if (externalType.hasSubType()) {
            this.checkSubType(externalType.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Handler handler) {
        if (handler.hasSubType()) {
            this.checkSubType(handler.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(NestedForm nestedForm) {
        if (nestedForm.hasSubType()) {
            this.checkSubType(nestedForm.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(TopLevelForm topLevelForm) {
        if (topLevelForm.hasSubType()) {
            this.checkSubType(topLevelForm.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(TopLevelFunction topLevelFunction) {
        return true;
    }

    private void checkSubType(Name name) {
        IPartSubTypeAnnotationTypeBinding subTypeAnnotationTypeBinding = null;
        IAnnotationTypeBinding typeBinding = null;
        ITypeBinding resolvedType = null;
        boolean typeResolved = false;
        try {
            resolvedType = this.abstractBinder.bindTypeName(name);
            typeResolved = true;
        }
        catch (ResolutionException resolutionException) {
            resolvedType = IBinding.NOT_FOUND_BINDING;
        }
        if (IBinding.NOT_FOUND_BINDING != resolvedType) {
            AnnotationTypeBindingImpl aTypeBinding;
            if (resolvedType.isPartBinding() && !resolvedType.isValid() && resolvedType != this.partBinding) {
                resolvedType = ((IPartBinding)resolvedType).realize();
            }
            if (this.hasAnnotation(resolvedType, AnnotationAnnotationTypeBinding.getInstance()) && (aTypeBinding = new AnnotationTypeBindingImpl((FlexibleRecordBinding)resolvedType, this.partBinding)).isPartSubType()) {
                typeBinding = aTypeBinding;
            }
        }
        if (typeBinding == null) {
            typeBinding = AnnotationTypeManager.getAnnotationType(name);
        }
        if (typeBinding != null && typeBinding.isPartSubType()) {
            subTypeAnnotationTypeBinding = (IPartSubTypeAnnotationTypeBinding)typeBinding;
            resolvedType = subTypeAnnotationTypeBinding;
            typeResolved = true;
        }
        if (subTypeAnnotationTypeBinding == null || !subTypeAnnotationTypeBinding.isApplicableFor(this.partBinding)) {
            if (typeResolved) {
                this.problemRequestor.acceptProblem((Node)name, 2057, new String[]{resolvedType.getPackageQualifiedName(), this.partBinding.getCaseSensitiveName()});
            } else {
                this.problemRequestor.acceptProblem((Node)name, 3260, new String[]{name.getCanonicalName()});
            }
            name.setBinding(IBinding.NOT_FOUND_BINDING);
        } else {
            this.subTypeAnnotationBinding = new AnnotationBinding(subTypeAnnotationTypeBinding.getCaseSensitiveName(), this.partBinding, subTypeAnnotationTypeBinding);
            this.partBinding.addAnnotation(this.subTypeAnnotationBinding);
            name.setBinding(this.subTypeAnnotationBinding);
        }
    }

    private boolean hasAnnotation(ITypeBinding resolvedType, IAnnotationTypeBinding annotationType) {
        Iterator iter = resolvedType.getAnnotations().iterator();
        while (iter.hasNext()) {
            if (((IAnnotationBinding)iter.next()).getType() != annotationType) continue;
            return true;
        }
        return false;
    }

    public AnnotationBinding getSubTypeAnnotationBinding() {
        return this.subTypeAnnotationBinding;
    }

    public boolean isFoundSubTypeInSettingsBlock() {
        return this.foundSubTypeInSettingsBlock;
    }

    public List getSettingsBlocks() {
        return this.settingsBlocks;
    }
}

