/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class ArrayAccess
extends Expression {
    private Expression array;
    private List subscripts;

    public ArrayAccess(Expression primary, List subscripts, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.array = primary;
        this.array.setParent(this);
        this.subscripts = subscripts;
        this.setParent(subscripts);
    }

    public Expression getArray() {
        return this.array;
    }

    public List getIndices() {
        return this.subscripts;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.array.accept(visitor);
            ArrayAccess.acceptChildren(visitor, this.subscripts);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getArray().getCanonicalString());
        sb.append("[");
        Iterator iter = this.subscripts.iterator();
        while (iter.hasNext()) {
            sb.append(((Expression)iter.next()).getCanonicalString());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setAttributeOnName(int attr, Object value) {
        this.array.setAttributeOnName(attr, value);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ArrayAccess((Expression)this.array.clone(), this.cloneList(this.subscripts), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public IDataBinding resolveDataBinding() {
        return this.getArray().resolveDataBinding();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.array.toString());
        buffer.append("[");
        Iterator i = this.subscripts.iterator();
        boolean first = true;
        while (i.hasNext()) {
            Expression ex = (Expression)i.next();
            if (!first) {
                buffer.append(",");
            }
            first = false;
            buffer.append(ex.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

