/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.WhenClause;

public class CaseStatement
extends Statement {
    private Expression parenthesizedExprOpt;
    private List whenClauses;
    private OtherwiseClause defaultClauseOpt;

    public CaseStatement(Expression parenthesizedExprOpt, List whenClauses, OtherwiseClause defaultClauseOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (parenthesizedExprOpt != null) {
            this.parenthesizedExprOpt = parenthesizedExprOpt;
            parenthesizedExprOpt.setParent(this);
        }
        this.whenClauses = this.setParent(whenClauses);
        if (defaultClauseOpt != null) {
            this.defaultClauseOpt = defaultClauseOpt;
            defaultClauseOpt.setParent(this);
        }
    }

    public boolean hasCriterion() {
        return this.parenthesizedExprOpt != null;
    }

    public Expression getCriterion() {
        return this.parenthesizedExprOpt;
    }

    public List getWhenClauses() {
        return this.whenClauses;
    }

    public boolean hasOtherwiseClause() {
        return this.defaultClauseOpt != null;
    }

    public OtherwiseClause getDefaultClause() {
        return this.defaultClauseOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.parenthesizedExprOpt != null) {
                this.parenthesizedExprOpt.accept(visitor);
            }
            CaseStatement.acceptChildren(visitor, this.whenClauses);
            if (this.defaultClauseOpt != null) {
                this.defaultClauseOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    @Override
    public List getStatementBlocks() {
        ArrayList<List> result = new ArrayList<List>();
        Iterator iter = this.whenClauses.iterator();
        while (iter.hasNext()) {
            result.add(((WhenClause)iter.next()).getStmts());
        }
        if (this.defaultClauseOpt != null) {
            result.add(this.defaultClauseOpt.getStatements());
        }
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Expression newParenthesizedExprOpt = this.parenthesizedExprOpt != null ? (Expression)this.parenthesizedExprOpt.clone() : null;
        OtherwiseClause newDefaultClauseOpt = this.defaultClauseOpt != null ? (OtherwiseClause)this.defaultClauseOpt.clone() : null;
        return new CaseStatement(newParenthesizedExprOpt, this.cloneList(this.whenClauses), newDefaultClauseOpt, this.getOffset(), this.getOffset() + this.getLength());
    }
}

