/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IDliIOStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.dli.DLIInfo;
import org.eclipse.edt.compiler.internal.sql.SQLInfo;

public class DeleteStatement
extends Statement
implements IDliIOStatement {
    private Expression expr;
    private FromOrToExpressionClause dataSource;
    private List deleteOptions;
    private SQLInfo sqlInfo;
    private DLIInfo dliInfo;

    public DeleteStatement(Expression expr, FromOrToExpressionClause dataSource, List deleteOptions, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        if (expr != null) {
            expr.setParent(this);
        }
        this.dataSource = dataSource;
        dataSource.setParent(this);
        this.deleteOptions = this.setParent(deleteOptions);
    }

    public Expression getTarget() {
        return this.expr;
    }

    public FromOrToExpressionClause getDataSource() {
        return this.dataSource;
    }

    public List getOptions() {
        return this.deleteOptions;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.expr != null) {
                this.expr.accept(visitor);
            }
            this.dataSource.accept(visitor);
            DeleteStatement.acceptChildren(visitor, this.deleteOptions);
        }
        visitor.endVisit(this);
    }

    @Override
    public List getIOObjects() {
        if (this.expr == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.expr);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Expression exprClone = null;
        if (this.expr != null) {
            exprClone = (Expression)this.expr.clone();
        }
        return new DeleteStatement(exprClone, (FromOrToExpressionClause)this.dataSource.clone(), this.cloneList(this.deleteOptions), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public DLIInfo getDliInfo() {
        return this.dliInfo;
    }

    @Override
    public void setDliInfo(DLIInfo dliInfo) {
        this.dliInfo = dliInfo;
    }

    public SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    public void setSqlInfo(SQLInfo sqlInfo) {
        this.sqlInfo = sqlInfo;
    }

    @Override
    public List getTargets() {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (this.getTarget() != null) {
            list.add(this.getTarget());
        }
        return list;
    }
}

