/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;

public class EnumerationField
extends Node {
    SimpleName name;
    Expression constantValue;

    public EnumerationField(SimpleName name, Expression constantValueOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
        if (constantValueOpt != null) {
            this.constantValue = constantValueOpt;
            this.constantValue.setParent(this);
        }
    }

    public Name getName() {
        return this.name;
    }

    public boolean hasConstantValue() {
        return this.constantValue != null;
    }

    public Expression getConstantValue() {
        return this.constantValue;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
            if (this.constantValue != null) {
                this.constantValue.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new EnumerationField((SimpleName)this.name.clone(), this.constantValue == null ? null : (Expression)this.constantValue.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }
}

