/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;

public class InlineDLIStatement
extends Node {
    private static final int POST_DELIMITER_LENGTH = 1;
    private String dliStmt;
    private int openingBraceOffset;

    public InlineDLIStatement(String sqlStmt, int openingBraceOffset, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.dliStmt = sqlStmt;
        this.openingBraceOffset = openingBraceOffset;
    }

    public String getValue() {
        String fulltext = this.dliStmt;
        return fulltext.substring(this.openingBraceOffset, fulltext.length() - 1).trim();
    }

    public int getValueOffset() {
        String text = this.dliStmt;
        int i = this.openingBraceOffset;
        while (Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return i + this.getOffset();
    }

    public int getOpeningBraceOffset() {
        return this.getOffset() + this.openingBraceOffset;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new InlineDLIStatement(this.dliStmt, this.openingBraceOffset, this.getOffset(), this.getOffset() + this.getLength());
    }
}

