/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class IntegerLiteral
extends LiteralExpression {
    private String integer;

    public IntegerLiteral(String integer, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.integer = integer;
    }

    @Override
    public String getValue() {
        return this.integer;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int getLiteralKind() {
        return 0;
    }

    @Override
    public String getCanonicalString() {
        return this.integer;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new IntegerLiteral(new String(this.integer), this.getOffset(), this.getOffset() + this.getLength());
    }
}

