/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class ParenthesizedExpression
extends Expression {
    private Expression expr;

    public ParenthesizedExpression(Expression expr, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public String getCanonicalString() {
        return this.expr.getCanonicalString();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ParenthesizedExpression((Expression)this.expr.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public IDataBinding resolveDataBinding() {
        return this.expr.resolveDataBinding();
    }
}

