/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.WithClause;

public class PrepareStatement
extends Statement {
    private Expression sqlStmt;
    private FromOrToExpressionClause dataSource;
    private WithClause withClause;

    public PrepareStatement(Expression sqlStmt, FromOrToExpressionClause dataSource, WithClause withClause, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.sqlStmt = sqlStmt;
        sqlStmt.setParent(this);
        this.dataSource = dataSource;
        dataSource.setParent(this);
        this.withClause = withClause;
        withClause.setParent(this);
    }

    public Expression getSqlStmt() {
        return this.sqlStmt;
    }

    public FromOrToExpressionClause getDataSource() {
        return this.dataSource;
    }

    public WithClause getWithClause() {
        return this.withClause;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.sqlStmt.accept(visitor);
            this.dataSource.accept(visitor);
            this.withClause.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public List getIOObjects() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new PrepareStatement((Expression)this.sqlStmt.clone(), (FromOrToExpressionClause)this.dataSource.clone(), (WithClause)this.withClause.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }
}

