/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Type;

public abstract class PrimitiveType
extends Type {
    protected Primitive prim;
    protected PrimitiveTypeBinding typeBinding;

    public PrimitiveType(Primitive prim, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.prim = prim;
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public ITypeBinding resolveTypeBinding() {
        if (this.typeBinding == null) {
            this.typeBinding = this.hasPrimLength() ? (this.hasPrimDecimals() ? PrimitiveTypeBinding.getInstance(this.prim, Integer.parseInt(this.getPrimLength()), Integer.parseInt(this.getPrimDecimals())) : PrimitiveTypeBinding.getInstance(this.prim, Integer.parseInt(this.getPrimLength()))) : (this.hasPrimPattern() ? PrimitiveTypeBinding.getInstance(this.prim, this.getPrimPattern()) : PrimitiveTypeBinding.getInstance(this.prim));
        }
        return this.typeBinding;
    }

    public Primitive getPrimitive() {
        return this.prim;
    }

    public abstract boolean hasPrimLength();

    public abstract boolean hasPrimDecimals();

    public abstract boolean hasPrimPattern();

    public abstract String getPrimLength();

    public abstract String getPrimDecimals();

    public abstract String getPrimPattern();

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.prim.getName());
        return buf.toString();
    }

    @Override
    public String getCanonicalName() {
        return this.prim.getName();
    }

    @Override
    protected abstract Object clone() throws CloneNotSupportedException;

    @Override
    public Type getBaseType() {
        return this;
    }
}

