/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.binding.ShowStatementBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class ShowStatement
extends Statement {
    private Expression expr;
    private List showOptions;
    private SettingsBlock settingsBlockOpt;
    private ShowStatementBinding statementBinding;

    public ShowStatement(Expression expr, List showOptions, SettingsBlock settingsBlockOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        this.showOptions = this.setParent(showOptions);
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
    }

    public Expression getPageRecordOrForm() {
        return this.expr;
    }

    public List getShowOptions() {
        return this.showOptions;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            ShowStatement.acceptChildren(visitor, this.showOptions);
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public List getIOObjects() {
        return Arrays.asList(this.expr);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        return new ShowStatement((Expression)this.expr.clone(), this.cloneList(this.showOptions), newSettingsBlockOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public ShowStatementBinding getStatementBinding() {
        return this.statementBinding;
    }

    public void setStatementBinding(ShowStatementBinding statementBinding) {
        this.statementBinding = statementBinding;
    }
}

