/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Type;

public class TypeLiteralExpression
extends Expression {
    private Type type;

    public TypeLiteralExpression(Type type, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.type = type;
        type.setParent(this);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.type.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalString() {
        return String.valueOf(this.type.getCanonicalName()) + ".type";
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new TypeLiteralExpression((Type)this.type.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }
}

