/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.generationServer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.generationServer.IGenerationListener;
import org.eclipse.edt.compiler.generationServer.parts.IElementInfo;
import org.eclipse.edt.compiler.generationServer.parts.IElementInfoVisitor;
import org.eclipse.edt.compiler.generationServer.parts.IEmbeddedMemberInfo;
import org.eclipse.edt.compiler.generationServer.parts.IExternalMemberInfo;
import org.eclipse.edt.compiler.generationServer.parts.IPartInfo;
import org.eclipse.edt.compiler.generationServer.parts.IUnresolvedPartInfo;

public class GenerationServer {
    private static List listeners;

    private GenerationServer() {
    }

    public static boolean hasListeners() {
        return GenerationServer.getListeners().size() > 0;
    }

    public static void addListener(IGenerationListener listener) {
        GenerationServer.getListeners().add(listener);
    }

    public static void removeListener(IGenerationListener listener) {
        GenerationServer.getListeners().remove(listener);
    }

    private static List getListeners() {
        if (listeners == null) {
            listeners = new ArrayList();
        }
        return listeners;
    }

    public static void begin() {
        for (IGenerationListener listener : GenerationServer.getListeners()) {
            listener.begin();
        }
    }

    public static void end() {
        for (IGenerationListener listener : GenerationServer.getListeners()) {
            listener.end();
        }
    }

    public static void acceptGeneratedPart(IPartInfo part) {
        if (part == null) {
            return;
        }
        for (IGenerationListener listener : GenerationServer.getListeners()) {
            listener.acceptGeneratedPart(part);
        }
    }

    public static void acceptAssociatedPart(IPartInfo part) {
        if (part == null) {
            return;
        }
        for (IGenerationListener listener : GenerationServer.getListeners()) {
            listener.acceptAssociatedPart(part);
        }
    }

    public static void reset() {
        listeners = null;
    }

    public static IPartInfo[] getAllUniqueReferecedParts(IPartInfo[] parts) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < parts.length) {
            GenerationServer.addAllUnique(parts[i].getAllReferencedParts(), list);
            ++i;
        }
        return list.toArray(new IPartInfo[list.size()]);
    }

    public static IElementInfo[] getAllUniqueReferecedElements(IElementInfo[] elements) {
        final ArrayList list = new ArrayList();
        IElementInfoVisitor visitor = new IElementInfoVisitor(){

            @Override
            public void endVisit(IPartInfo info) {
            }

            @Override
            public void endVisit(IEmbeddedMemberInfo info) {
            }

            @Override
            public void endVisit(IUnresolvedPartInfo info) {
            }

            @Override
            public void endVisit(IExternalMemberInfo info) {
            }

            @Override
            public boolean visit(IPartInfo info) {
                GenerationServer.addAllUnique(info.getAllReferencedParts(), list);
                return false;
            }

            @Override
            public boolean visit(IEmbeddedMemberInfo info) {
                if (!list.contains(info)) {
                    list.add(info);
                }
                return false;
            }

            @Override
            public boolean visit(IUnresolvedPartInfo info) {
                if (!list.contains(info)) {
                    list.add(info);
                }
                return false;
            }

            @Override
            public boolean visit(IExternalMemberInfo info) {
                if (!list.contains(info)) {
                    list.add(info);
                }
                return false;
            }
        };
        int i = 0;
        while (i < elements.length) {
            elements[i].accept(visitor);
            ++i;
        }
        return list.toArray(new IElementInfo[list.size()]);
    }

    private static void addAllUnique(Object[] parts, List list) {
        int i = 0;
        while (i < parts.length) {
            if (!list.contains(parts[i])) {
                list.add(parts[i]);
            }
            ++i;
        }
    }
}

