/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import com.ibm.icu.util.StringTokenizer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.AmbiguousSystemLibraryFieldDataBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.DynamicDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.NotFoundBinding;
import org.eclipse.edt.compiler.binding.PartFoundButNotAnnotationRecordAnnotationBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionDataBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DBCharLiteral;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.MBCharLiteral;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullableType;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DataBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SpecificTypedLiteral;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class AbstractBinder
extends AbstractASTVisitor {
    protected Scope currentScope;
    protected IDependencyRequestor dependencyRequestor;
    protected IPartBinding currentBinding;
    protected ICompilerOptions compilerOptions;
    protected boolean bindingCallTarget;

    public AbstractBinder(Scope currentScope, IPartBinding currentBinding, IDependencyRequestor dependencyRequestor, ICompilerOptions compilerOptions) {
        this.currentScope = currentScope;
        this.currentBinding = currentBinding;
        this.dependencyRequestor = dependencyRequestor;
        this.compilerOptions = compilerOptions;
    }

    public ITypeBinding bindType(Type type) throws ResolutionException {
        switch (type.getKind()) {
            case 1: {
                PrimitiveType primitiveType = (PrimitiveType)type;
                return primitiveType.resolveTypeBinding();
            }
            case 2: {
                ArrayType arrayType = (ArrayType)type;
                ITypeBinding elementTypeBinding = this.bindType(arrayType.getElementType());
                ArrayTypeBinding arrayTypeBinding = ArrayTypeBinding.getInstance(elementTypeBinding);
                arrayType.setTypeBinding(arrayTypeBinding);
                return arrayTypeBinding;
            }
            case 0: {
                NameType nameType = (NameType)type;
                return this.bindTypeName(nameType.getName());
            }
            case 3: {
                NullableType nullableType = (NullableType)type;
                ITypeBinding baseType = this.bindType(nullableType.getBaseType());
                return baseType.getNullableInstance();
            }
        }
        throw new RuntimeException("Shouldn't come into here");
    }

    public ITypeBinding bindTypeName(Name name) throws ResolutionException {
        return this.bindTypeName(name, false);
    }

    public ITypeBinding bindTypeName(Name name, boolean mayHaveFormgroupQualifier) throws ResolutionException {
        int[] errorOffsets;
        ITypeBinding result = null;
        if (name.isSimpleName()) {
            result = this.currentScope.findType(name.getIdentifier());
        } else {
            IPackageBinding packageBinding;
            QualifiedName qualifiedName = (QualifiedName)name;
            if (mayHaveFormgroupQualifier) {
                try {
                    ITypeBinding qualifierType = this.bindTypeName(qualifiedName.getQualifier());
                    if (9 == qualifierType.getKind() && IBinding.NOT_FOUND_BINDING == (result = ((FormGroupBinding)qualifierType).findForm(qualifiedName.getIdentifier()))) {
                        name.setBinding(IBinding.NOT_FOUND_BINDING);
                        throw new ResolutionException(name, 3260, new String[]{qualifiedName.getIdentifier()});
                    }
                }
                catch (ResolutionException resolutionException) {
                    qualifiedName.getQualifier().setBinding(null);
                }
            }
            if (result == null && (result = (packageBinding = this.bindPackageName(qualifiedName.getQualifier())).resolveType(qualifiedName.getIdentifier())) != IBinding.NOT_FOUND_BINDING && ((IPartBinding)result).isPrivate() && result.getPackageName() != this.currentBinding.getPackageName()) {
                result = IBinding.NOT_FOUND_BINDING;
            }
        }
        if (result == IBinding.NOT_FOUND_BINDING) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3260, new String[]{name.getCanonicalName()});
        }
        if (result == ITypeBinding.AMBIGUOUS_TYPE) {
            name.setBinding(ITypeBinding.AMBIGUOUS_TYPE);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3262, new String[]{name.getCanonicalName()});
        }
        this.dependencyRequestor.recordTypeBinding(result);
        name.setBinding(result);
        return result;
    }

    public IDataBinding bindExpressionName(Name name) throws ResolutionException {
        return this.bindExpressionName(name, false);
    }

    public IDataBinding bindExpressionName(Name name, boolean isFunctionInvocation) throws ResolutionException {
        int[] errorOffsets;
        IDataBinding result = IBinding.NOT_FOUND_BINDING;
        if (name.isSimpleName()) {
            result = this.currentScope.findData(name.getIdentifier());
            if (IBinding.NOT_FOUND_BINDING == result) {
                ITypeBinding type = this.currentScope.findType(name.getIdentifier());
                if (IBinding.NOT_FOUND_BINDING != type) {
                    if (5 == type.getKind()) {
                        result = ((DataTableBinding)type).getStaticDataTableDataBinding();
                    } else if (11 == type.getKind()) {
                        result = ((LibraryBinding)type).getStaticLibraryDataBinding();
                    } else if (13 == type.getKind()) {
                        result = ((ProgramBinding)type).getStaticProgramDataBinding();
                    } else if (28 == type.getKind()) {
                        result = ((ExternalTypeBinding)type).getStaticExternalTypeDataBinding();
                    }
                }
            } else {
                switch (result.getKind()) {
                    case 11: 
                    case 26: {
                        result = IBinding.NOT_FOUND_BINDING;
                    }
                }
            }
        } else {
            ITypeBinding typeBinding;
            QualifiedName qualifiedName = (QualifiedName)name;
            Name qualifier = qualifiedName.getQualifier();
            String identifier = qualifiedName.getIdentifier();
            IBinding binding = this.bindUnknownName(qualifier);
            if (binding.isDataBinding()) {
                IDataBinding dataBinding = (IDataBinding)binding;
                if (dataBinding.isDataBindingWithImplicitQualifier()) {
                    qualifier.setAttributeOnName(Name.IMPLICIT_QUALIFIER_DATA_BINDING, dataBinding.getImplicitQualifier());
                    dataBinding = dataBinding.getWrappedDataBinding();
                }
                ITypeBinding typeBinding2 = dataBinding.getType();
                if (dataBinding.getKind() == 5) {
                    result = ((StructureItemBinding)dataBinding).findData(identifier);
                } else if (!Binding.isValidBinding(typeBinding2)) {
                    result = IBinding.NOT_FOUND_BINDING;
                } else {
                    switch (dataBinding.getKind()) {
                        case 26: {
                            result = this.findStaticData(typeBinding2, identifier);
                            break;
                        }
                        default: {
                            result = this.findData(typeBinding2, identifier);
                        }
                    }
                    if (IBinding.NOT_FOUND_BINDING == result && typeBinding2.isDynamicallyAccessible()) {
                        result = new DynamicDataBinding(qualifiedName.getCaseSensitiveIdentifier(), dataBinding.getDeclaringPart());
                    }
                }
            } else if (binding.isTypeBinding() && (result = this.findStaticData(typeBinding = (ITypeBinding)binding, identifier)) == IBinding.NOT_FOUND_BINDING) {
                try {
                    IPackageBinding packageBinding = this.bindPackageName(qualifier);
                    binding = packageBinding;
                }
                catch (ResolutionException resolutionException) {}
            }
            if (binding.isPackageBinding()) {
                ITypeBinding resolvedType;
                IPackageBinding packageBinding = (IPackageBinding)binding;
                if (identifier != null && identifier.length() > 0) {
                    this.dependencyRequestor.recordSimpleName(identifier);
                }
                if ((resolvedType = packageBinding.resolveType(identifier)) != IBinding.NOT_FOUND_BINDING) {
                    if (resolvedType.getPackageName() != this.currentBinding.getPackageName() && ((IPartBinding)resolvedType).isPrivate()) {
                        this.dependencyRequestor.recordName(new QualifiedName(qualifier, name.getIdentifier(), qualifier.getOffset(), name.getOffset() + name.getLength()));
                        result = IBinding.NOT_FOUND_BINDING;
                    } else {
                        switch (resolvedType.getKind()) {
                            case 20: {
                                TopLevelFunctionBinding functionBinding = (TopLevelFunctionBinding)resolvedType;
                                result = functionBinding.getStaticTopLevelFunctionDataBinding();
                                this.dependencyRequestor.recordTopLevelFunctionBinding(functionBinding);
                                break;
                            }
                            case 5: {
                                result = ((DataTableBinding)resolvedType).getStaticDataTableDataBinding();
                                break;
                            }
                            case 11: {
                                result = ((LibraryBinding)resolvedType).getStaticLibraryDataBinding();
                                break;
                            }
                            case 13: {
                                result = ((ProgramBinding)resolvedType).getStaticProgramDataBinding();
                                break;
                            }
                            case 28: {
                                result = ((ExternalTypeBinding)resolvedType).getStaticExternalTypeDataBinding();
                                break;
                            }
                            default: {
                                result = IBinding.NOT_FOUND_BINDING;
                                this.dependencyRequestor.recordName(new QualifiedName(qualifier, name.getIdentifier(), qualifier.getOffset(), name.getOffset() + name.getLength()));
                                break;
                            }
                        }
                    }
                } else {
                    this.dependencyRequestor.recordName(new QualifiedName(qualifier, name.getIdentifier(), qualifier.getOffset(), name.getOffset() + name.getLength()));
                    result = IBinding.NOT_FOUND_BINDING;
                }
            }
        }
        if (result != IBinding.NOT_FOUND_BINDING && result.isDataBindingWithImplicitQualifier()) {
            name.setAttributeOnName(Name.IMPLICIT_QUALIFIER_DATA_BINDING, result.getImplicitQualifier());
            result = result.getWrappedDataBinding();
        }
        if (result != IBinding.NOT_FOUND_BINDING && result.getKind() == 23 && !isFunctionInvocation) {
            result = AmbiguousDataBinding.getInstance();
        }
        if (result != IBinding.NOT_FOUND_BINDING && result.getKind() == 21) {
            result = !this.currentScope.isReturningTopLevelFunctions() ? IBinding.NOT_FOUND_BINDING : ((TopLevelFunctionDataBinding)result).getFunctionWithItemsNullableSignature(this.currentScope.I4GLItemsNullableIsEnabled());
        }
        if (result == IBinding.NOT_FOUND_BINDING) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 6619, new String[]{name.getCanonicalName()});
        }
        if (result.getKind() == 12) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 6620, new String[]{name.getCanonicalName()});
        }
        if (result == IAnnotationBinding.NOT_APPLICABLE_ANNOTATION_BINDING) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 2058, new String[]{name.getCanonicalName()});
        }
        if (result instanceof PartFoundButNotAnnotationRecordAnnotationBinding) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 2065, new String[]{result.getType().getPackageQualifiedName()});
        }
        if (24 == result.getKind()) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3455, new String[]{name.getCanonicalName(), AbstractBinder.toCommaList(((AmbiguousSystemLibraryFieldDataBinding)result).getAllowedQualifiers().toArray(new String[0]))});
        }
        name.setBinding(result);
        name.setTypeBinding(result.getType());
        if (result.getType() != null) {
            this.dependencyRequestor.recordTypeBinding(result.getType());
        }
        return result;
    }

    private int[] getLastIdentifierOffsets(Name name) {
        if (name.isQualifiedName()) {
            String id = name.getIdentifier();
            int endOffset = name.getOffset() + name.getLength();
            return new int[]{endOffset - id.length(), endOffset};
        }
        return new int[]{name.getOffset(), name.getOffset() + name.getLength()};
    }

    private IDataBinding findStaticData(ITypeBinding typeBinding, String identifier) {
        IDataBinding result;
        if (typeBinding.getKind() == 11 || typeBinding.getKind() == 5 || typeBinding.getKind() == 19) {
            result = typeBinding == this.currentBinding ? typeBinding.findData(identifier) : typeBinding.findPublicData(identifier);
        } else if (this.bindingCallTarget && typeBinding.getKind() == 15 || typeBinding.getKind() == 14) {
            result = typeBinding.findData(identifier);
        } else if (typeBinding.getKind() == 15 || typeBinding.getKind() == 28) {
            result = typeBinding.findData(identifier);
            if (result != IBinding.NOT_FOUND_BINDING) {
                if (20 == result.getKind() && !((IFunctionBinding)result.getType()).isStatic()) {
                    result = IBinding.NOT_FOUND_BINDING;
                } else if (3 == result.getKind() && !((ClassFieldBinding)result).isStatic()) {
                    result = IBinding.NOT_FOUND_BINDING;
                }
            }
        } else {
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    public IPackageBinding bindPackageName(Name name) throws ResolutionException {
        IPackageBinding result;
        if (name.isSimpleName()) {
            result = this.currentScope.findPackage(name.getIdentifier());
        } else {
            QualifiedName qualifiedName = (QualifiedName)name;
            IPackageBinding packageBinding = this.bindPackageName(qualifiedName.getQualifier());
            result = packageBinding.resolvePackage(qualifiedName.getIdentifier());
        }
        if (result == IBinding.NOT_FOUND_BINDING) {
            this.dependencyRequestor.recordName(name);
            throw new ResolutionException(name, 6619, new String[]{name.getCanonicalName()});
        }
        name.setBinding(result);
        this.dependencyRequestor.recordPackageBinding(result);
        return result;
    }

    public IBinding bindUnknownName(Name name) throws ResolutionException {
        int[] errorOffsets;
        String identifier = name.getIdentifier();
        IBinding result = IBinding.NOT_FOUND_BINDING;
        if (name.isSimpleName()) {
            result = this.currentScope.findData(identifier);
            if (result != IBinding.NOT_FOUND_BINDING) {
                IDataBinding dataBinding = (IDataBinding)result;
                if (dataBinding.isDataBindingWithImplicitQualifier()) {
                    name.setAttributeOnName(Name.IMPLICIT_QUALIFIER_DATA_BINDING, dataBinding.getImplicitQualifier());
                    result = dataBinding.getWrappedDataBinding();
                }
                ITypeBinding type = ((IDataBinding)result).getType();
                name.setTypeBinding(type);
                if (type != null) {
                    this.dependencyRequestor.recordTypeBinding(type);
                }
            }
            if (result == IBinding.NOT_FOUND_BINDING && (result = this.currentScope.findType(identifier)) != IBinding.NOT_FOUND_BINDING) {
                name.setTypeBinding((ITypeBinding)result);
            }
            if (result == IBinding.NOT_FOUND_BINDING) {
                result = this.currentScope.findPackage(identifier);
            }
        } else {
            ITypeBinding typeBinding;
            QualifiedName qualifiedName = (QualifiedName)name;
            Name qualifier = qualifiedName.getQualifier();
            IBinding binding = this.bindUnknownName(qualifier);
            if (binding == IBinding.NOT_FOUND_BINDING) {
                return IBinding.NOT_FOUND_BINDING;
            }
            if (binding.isDataBinding()) {
                IDataBinding dataBinding = (IDataBinding)binding;
                if (dataBinding.isDataBindingWithImplicitQualifier()) {
                    qualifier.setAttributeOnName(Name.IMPLICIT_QUALIFIER_DATA_BINDING, dataBinding.getImplicitQualifier());
                    dataBinding = dataBinding.getWrappedDataBinding();
                }
                if (dataBinding.getKind() == 5) {
                    result = ((StructureItemBinding)dataBinding).findData(identifier);
                } else {
                    ITypeBinding typeBinding2 = dataBinding.getType();
                    if (typeBinding2 == null) {
                        result = IBinding.NOT_FOUND_BINDING;
                    } else if (typeBinding2.isDynamicallyAccessible()) {
                        result = new DynamicDataBinding(name.getCaseSensitiveIdentifier(), dataBinding.getDeclaringPart());
                    } else {
                        switch (dataBinding.getKind()) {
                            case 26: {
                                result = this.findStaticData(typeBinding2, identifier);
                                break;
                            }
                            default: {
                                result = this.findData(typeBinding2, identifier);
                            }
                        }
                    }
                }
                if (result != IBinding.NOT_FOUND_BINDING && result.isDataBinding()) {
                    IDataBinding resultDataBinding = (IDataBinding)result;
                    name.setTypeBinding(resultDataBinding.getType());
                    this.dependencyRequestor.recordTypeBinding(resultDataBinding.getType());
                }
            } else if (binding.isTypeBinding() && IBinding.NOT_FOUND_BINDING == (result = this.findStaticData(typeBinding = (ITypeBinding)binding, identifier))) {
                try {
                    IPackageBinding packageBinding = this.bindPackageName(qualifier);
                    binding = packageBinding;
                }
                catch (ResolutionException resolutionException) {}
            }
            if (binding.isPackageBinding()) {
                IPackageBinding packageBinding = (IPackageBinding)binding;
                result = packageBinding.resolveType(identifier);
                if (result != IBinding.NOT_FOUND_BINDING) {
                    if (((IPartBinding)result).isPrivate() && ((IPartBinding)result).getPackageName() != this.currentBinding.getPackageName()) {
                        result = IBinding.NOT_FOUND_BINDING;
                    } else {
                        name.setTypeBinding((ITypeBinding)result);
                    }
                }
                if (result == IBinding.NOT_FOUND_BINDING) {
                    result = packageBinding.resolvePackage(identifier);
                }
            }
        }
        if (result == IBinding.NOT_FOUND_BINDING) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 6619, new String[]{name.getCanonicalName()});
        }
        if (result == ITypeBinding.AMBIGUOUS_TYPE) {
            name.setBinding(ITypeBinding.AMBIGUOUS_TYPE);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3262, new String[]{name.getCanonicalName()});
        }
        if (result.isDataBinding() && 24 == ((IDataBinding)result).getKind()) {
            name.setBinding(IBinding.NOT_FOUND_BINDING);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3455, new String[]{name.getCanonicalName(), AbstractBinder.toCommaList(((AmbiguousSystemLibraryFieldDataBinding)result).getAllowedQualifiers().toArray(new String[0]))});
        }
        name.setBinding(result);
        if (result.isDataBinding()) {
            name.setTypeBinding(((IDataBinding)result).getType());
        }
        this.dependencyRequestor.recordBinding(result);
        return result;
    }

    public IBinding bindInvocationTarget(Expression invocationTarget, final boolean allowFuncs) throws ResolutionException {
        NotFoundBinding result = IBinding.NOT_FOUND_BINDING;
        final AbstractBinder thisVisitor = this;
        final ResolutionException[] ex = new ResolutionException[1];
        invocationTarget.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisit(StringLiteral stringLiteral) {
                this.bindFromString(stringLiteral, stringLiteral.getValue());
            }

            private void bindFromString(Expression expr, String value) {
                ITypeBinding result = IBinding.NOT_FOUND_BINDING;
                Name name = new ExpressionParser(AbstractBinder.this.compilerOptions).parseAsName(value);
                if (name != null) {
                    try {
                        result = AbstractBinder.this.bindTypeName(name);
                        if (IBinding.NOT_FOUND_BINDING != result && ITypeBinding.AMBIGUOUS_TYPE != result) {
                            AbstractBinder.this.dependencyRequestor.recordTypeBinding(result);
                        }
                    }
                    catch (ResolutionException resolutionException) {}
                }
                expr.setTypeBinding(result);
            }

            @Override
            public void endVisitExpression(Expression expression) {
                ITypeBinding tBinding;
                VariableBinding variableBinding;
                expression.accept(thisVisitor);
                IDataBinding dBinding = expression.resolveDataBinding();
                if (dBinding != null && IBinding.NOT_FOUND_BINDING != dBinding && (3 == dBinding.getKind() || 2 == dBinding.getKind()) && (variableBinding = (VariableBinding)dBinding).isConstant()) {
                    this.bindFromString(expression, variableBinding.getConstantValue().toString());
                }
                if ((tBinding = expression.resolveTypeBinding()) != null && IBinding.NOT_FOUND_BINDING != tBinding) {
                    block0 : switch (tBinding.getKind()) {
                        case 13: {
                            break;
                        }
                        case 20: {
                            if (allowFuncs) break;
                        }
                        case 3: {
                            switch (((PrimitiveTypeBinding)tBinding).getPrimitive().getType()) {
                                case 4: 
                                case 19: 
                                case 20: {
                                    break block0;
                                }
                            }
                            ex[0] = new ResolutionException(expression, 6540, new String[]{expression.getCanonicalString()});
                            break;
                        }
                        default: {
                            ex[0] = new ResolutionException(expression, 6543, new String[]{expression.getCanonicalString()});
                        }
                    }
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return result;
    }

    public static String toCommaList(String[] strings) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            result.append(strings[i]);
            if (i != strings.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    public static String toCommaList(Collection objects) {
        StringBuffer result = new StringBuffer();
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String toCommaList(ITypeBinding[] types) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            result.append(types[i].getCaseSensitiveName());
            if (i != types.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    protected IDataBinding findData(ITypeBinding type, String identifier) {
        IFunctionBinding fBinding;
        IDataBinding result;
        ITypeBinding baseElementType;
        if (type.getKind() == 2 && ((baseElementType = type.getBaseType()).getKind() == 6 || baseElementType.getKind() == 7) && IBinding.NOT_FOUND_BINDING != (result = this.findData(baseElementType, identifier))) {
            return result;
        }
        IDataBinding result2 = type.findPublicData(identifier);
        if (result2 == IBinding.NOT_FOUND_BINDING && (6 == type.getKind() || 5 == type.getKind()) && (result2 = (IDataBinding)((FixedStructureBinding)type).getSimpleNamesToDataBindingsMap().get(identifier)) == null) {
            result2 = IBinding.NOT_FOUND_BINDING;
        }
        if (IBinding.NOT_FOUND_BINDING == result2 && IBinding.NOT_FOUND_BINDING != (fBinding = type.findPublicFunction(identifier))) {
            result2 = new NestedFunctionBinding(fBinding.getCaseSensitiveName(), type.isPartBinding() ? (IPartBinding)type : null, fBinding);
        }
        return result2;
    }

    protected static Object getConstantValue(Expression expr, IProblemRequestor problemRequestor, boolean returnStringTypes) {
        return AbstractBinder.getConstantValue(expr, null, null, problemRequestor, returnStringTypes);
    }

    protected static Object getConstantValue(Expression expr, ITypeBinding constantType, String constantName, IProblemRequestor problemRequestor) {
        return AbstractBinder.getConstantValue(expr, constantType, constantName, problemRequestor, false);
    }

    protected static Object getConstantValue(Expression expr, ITypeBinding constantType, String constantName, IProblemRequestor problemRequestor, boolean returnStringTypes) {
        ConstantValueCreator constValueCreator = new ConstantValueCreator(constantType, constantName, problemRequestor, returnStringTypes);
        expr.accept(constValueCreator);
        if (constValueCreator.constantValue == null) {
            problemRequestor.acceptProblem(expr, 4955);
        }
        return constValueCreator.constantValue;
    }

    protected static void bindNamesToNotFound(Node node) {
        node.accept(new AbstractASTVisitor(){

            @Override
            public void endVisit(SimpleName simpleName) {
                simpleName.setBinding(IBinding.NOT_FOUND_BINDING);
            }

            @Override
            public void endVisit(QualifiedName qualifiedName) {
                qualifiedName.setBinding(IBinding.NOT_FOUND_BINDING);
            }
        });
    }

    public static boolean annotationIs(ITypeBinding annotationType, String[] packageName, String annotationName) {
        return annotationType != null && annotationType.getPackageName() == InternUtil.intern((String[])packageName) && annotationType.getName() == InternUtil.intern((String)annotationName);
    }

    public static boolean typeIs(ITypeBinding type, String[] packageName, String annotationName) {
        return type != null && type.getPackageName() == InternUtil.intern((String[])packageName) && type.getName() == InternUtil.intern((String)annotationName);
    }

    public static boolean enumerationIs(EnumerationDataBinding enumDBinding, String[] enumerationTypePackageName, String enumerationTypeName, String enumeratedValueName) {
        return enumDBinding.getType().getPackageName() == InternUtil.intern((String[])enumerationTypePackageName) && enumDBinding.getType().getName() == InternUtil.intern((String)enumerationTypeName) && enumDBinding.getName() == InternUtil.intern((String)enumeratedValueName);
    }

    public static boolean dataBindingIs(IDataBinding dataBinding, String[] enclosingTypePackageName, String enclosingTypeName, String dataBindingName) {
        return dataBinding != null && IBinding.NOT_FOUND_BINDING != dataBinding && dataBinding.getDeclaringPart() != null && dataBinding.getDeclaringPart().getPackageName() == InternUtil.intern((String[])enclosingTypePackageName) && dataBinding.getDeclaringPart().getName() == InternUtil.intern((String)enclosingTypeName) && dataBinding.getName() == InternUtil.intern((String)dataBindingName);
    }

    public static boolean functionBindingIs(IFunctionBinding functionBinding, String[] enclosingTypePackageName, String enclosingTypeName, String dataBindingName) {
        return functionBinding != null && functionBinding.getDeclarer() != null && functionBinding.getDeclarer().getPackageName() == InternUtil.intern((String[])enclosingTypePackageName) && functionBinding.getDeclarer().getName() == InternUtil.intern((String)enclosingTypeName) && functionBinding.getName() == InternUtil.intern((String)dataBindingName);
    }

    protected void processSettingsBlock(ClassDataDeclaration classDataDeclaration, IPartBinding functionContainerBinding, Scope functionContainerScope, IProblemRequestor problemRequestor) {
        Iterator i = classDataDeclaration.getNames().iterator();
        boolean annotationFoundUsingScope = false;
        while (i.hasNext()) {
            Name name = (Name)i.next();
            if (!classDataDeclaration.hasSettingsBlock() || name.resolveBinding() == null || name.resolveBinding() == IBinding.NOT_FOUND_BINDING) continue;
            ClassFieldBinding fieldBinding = (ClassFieldBinding)name.resolveBinding();
            DataBindingScope scope = new DataBindingScope(this.currentScope, fieldBinding);
            AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(scope, fieldBinding, fieldBinding.getType(), fieldBinding, -1, functionContainerBinding);
            annotationScope.setAnnotationFoundUsingThisScope(annotationFoundUsingScope);
            Scope fcScope = functionContainerScope;
            fcScope.startReturningTopLevelFunctions();
            classDataDeclaration.getSettingsBlockOpt().accept(new SettingsBlockAnnotationBindingsCompletor(fcScope, functionContainerBinding, annotationScope, this.dependencyRequestor, problemRequestor, this.compilerOptions));
            annotationFoundUsingScope = annotationScope.isAnnotationFoundUsingThisScope();
        }
    }

    public boolean isNullable(ITypeBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        if (binding.isNullable()) {
            return true;
        }
        if (binding.getKind() == 17) {
            DataItemBinding diBinding = (DataItemBinding)binding;
            return this.isNullable(diBinding.getPrimitiveTypeBinding());
        }
        if (binding != binding.getBaseType()) {
            return this.isNullable(binding.getBaseType());
        }
        return false;
    }

    private static class ConstantValueCreator
    extends DefaultASTVisitor {
        Object constantValue;
        IProblemRequestor problemRequestor;
        boolean isNegative = false;
        private String constantName;
        private ITypeBinding constantType;
        private boolean returnStringTypes;

        public ConstantValueCreator(ITypeBinding constantType, String constantName, IProblemRequestor problemRequestor, boolean returnStringTypes) {
            this.constantType = constantType;
            this.constantName = constantName;
            this.problemRequestor = problemRequestor;
            this.returnStringTypes = returnStringTypes;
        }

        @Override
        public boolean visit(IntegerLiteral integerLiteral) {
            String str = integerLiteral.getValue();
            if (this.isNegative) {
                str = "-" + str;
            }
            try {
                this.constantValue = integerLiteral.getValue().length() > 18 ? new BigInteger(str) : (integerLiteral.getValue().length() > 9 ? (Number)new Long(str) : (Number)new Integer(str));
            }
            catch (NumberFormatException numberFormatException) {
                this.problemRequestor.acceptProblem((Node)integerLiteral, 3250, new String[]{str});
                this.constantValue = null;
            }
            this.checkLengthAndDecimals(integerLiteral, integerLiteral.getValue());
            return false;
        }

        @Override
        public boolean visit(FloatLiteral floatLiteral) {
            String str = floatLiteral.getValue();
            if (this.isNegative) {
                str = "-" + str;
            }
            this.constantValue = new Double(str);
            return false;
        }

        @Override
        public boolean visit(DecimalLiteral decimalLiteral) {
            String str = decimalLiteral.getValue();
            if (this.isNegative) {
                str = "-" + str;
            }
            this.constantValue = new BigDecimal(str);
            this.checkLengthAndDecimals(decimalLiteral, decimalLiteral.getValue());
            return false;
        }

        @Override
        public boolean visit(StringLiteral stringLiteral) {
            this.constantValue = this.returnStringTypes ? new SpecificTypedLiteral(1, stringLiteral.getValue(), stringLiteral.isHex()) : stringLiteral.getValue();
            return false;
        }

        @Override
        public boolean visit(HexLiteral stringLiteral) {
            this.constantValue = this.returnStringTypes ? new SpecificTypedLiteral(2, stringLiteral.getValue(), true) : stringLiteral.getValue();
            return false;
        }

        @Override
        public boolean visit(CharLiteral stringLiteral) {
            this.constantValue = this.returnStringTypes ? new SpecificTypedLiteral(3, stringLiteral.getValue(), stringLiteral.isHex()) : stringLiteral.getValue();
            return false;
        }

        @Override
        public boolean visit(DBCharLiteral stringLiteral) {
            this.constantValue = this.returnStringTypes ? new SpecificTypedLiteral(4, stringLiteral.getValue(), stringLiteral.isHex()) : stringLiteral.getValue();
            return false;
        }

        @Override
        public boolean visit(MBCharLiteral stringLiteral) {
            this.constantValue = this.returnStringTypes ? new SpecificTypedLiteral(5, stringLiteral.getValue(), stringLiteral.isHex()) : stringLiteral.getValue();
            return false;
        }

        @Override
        public boolean visit(BooleanLiteral booleanLiteral) {
            this.constantValue = new Boolean(booleanLiteral.booleanValue().booleanValue());
            return false;
        }

        private Expression getBaseExpression(Expression expr) {
            final Expression[] baseExpr = new Expression[]{expr};
            expr.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(UnaryExpression unaryExpression) {
                    baseExpr[0] = unaryExpression.getExpression();
                    return true;
                }
            });
            return baseExpr[0];
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            ArrayList<Object> constantObjects = new ArrayList<Object>();
            Expression previousExpr = null;
            for (Expression nextExpr : arrayLiteral.getExpressions()) {
                if (previousExpr != null && !this.getBaseExpression(nextExpr).getClass().getName().equals(this.getBaseExpression(previousExpr).getClass().getName())) {
                    this.problemRequestor.acceptProblem(nextExpr, 4966);
                    this.constantValue = new Object[0];
                    return false;
                }
                ConstantValueCreator constValueCreator = new ConstantValueCreator(this.constantType, this.constantName, this.problemRequestor, this.returnStringTypes);
                nextExpr.accept(constValueCreator);
                if (constValueCreator.constantValue == null) {
                    this.problemRequestor.acceptProblem(nextExpr, 4955);
                    this.constantValue = new Object[0];
                    return false;
                }
                constantObjects.add(constValueCreator.constantValue);
                previousExpr = nextExpr;
            }
            if (previousExpr == null) {
                this.constantValue = new Object[0];
            } else {
                LiteralExpression litExpr = (LiteralExpression)this.getBaseExpression(previousExpr);
                switch (litExpr.getLiteralKind()) {
                    case 0: {
                        this.constantValue = constantObjects.toArray(new Number[0]);
                        break;
                    }
                    case 2: {
                        this.constantValue = constantObjects.toArray(new Float[0]);
                        break;
                    }
                    case 1: {
                        this.constantValue = constantObjects.toArray(new Number[0]);
                        break;
                    }
                    case 3: {
                        if (this.returnStringTypes) {
                            this.constantValue = constantObjects.toArray(new SpecificTypedLiteral[0]);
                            break;
                        }
                        this.constantValue = constantObjects.toArray(new String[0]);
                        break;
                    }
                    case 7: {
                        this.constantValue = constantObjects.toArray(new Boolean[0]);
                        break;
                    }
                    case 6: {
                        int numElements = constantObjects.size();
                        this.constantValue = Array.newInstance(constantObjects.get(0).getClass(), numElements);
                        Object[] arrayForm = (Object[])this.constantValue;
                        int i = 0;
                        while (i < numElements) {
                            arrayForm[i] = constantObjects.get(i);
                            ++i;
                        }
                        break;
                    }
                    default: {
                        this.constantValue = new Object[0];
                    }
                }
            }
            return false;
        }

        @Override
        public boolean visit(UnaryExpression unaryExpression) {
            if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                this.isNegative = !this.isNegative;
            }
            return true;
        }

        private void checkLengthAndDecimals(Node nodeForErrors, String value) {
            if (this.constantType != null && IBinding.NOT_FOUND_BINDING != this.constantType && 3 == this.constantType.getKind()) {
                PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)this.constantType;
                int length = primTypeBinding.getLength();
                int decimals = primTypeBinding.getDecimals();
                switch (primTypeBinding.getPrimitive().getType()) {
                    case 2: 
                    case 7: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: {
                        int valueDecimals;
                        int nonDecimalLength = length - decimals;
                        if (nonDecimalLength < 0) break;
                        StringTokenizer st = new StringTokenizer(value, ".");
                        int valueNonDecimalLength = st.nextToken().length();
                        int n = valueDecimals = st.hasMoreTokens() ? st.nextToken().length() : 0;
                        if (valueNonDecimalLength > nonDecimalLength && !primTypeBinding.isReference()) {
                            this.problemRequestor.acceptProblem(nodeForErrors, 3465, new String[]{value, Integer.toString(valueNonDecimalLength), Integer.toString(nonDecimalLength), this.constantName});
                        }
                        if (valueDecimals <= decimals || primTypeBinding.isReference()) break;
                        this.problemRequestor.acceptProblem(nodeForErrors, 3466, new String[]{value, Integer.toString(valueDecimals), Integer.toString(decimals), this.constantName});
                    }
                }
            }
        }
    }

    protected static class OccursValueFinder
    extends AbstractASTExpressionVisitor {
        private int occursValue = -1;
        private boolean haveIssuedError = false;
        private IProblemRequestor problemRequestor;
        private String canonicalItemName;

        public OccursValueFinder(IProblemRequestor problemRequestor, String canonicalItemName) {
            this.problemRequestor = problemRequestor;
            this.canonicalItemName = canonicalItemName;
        }

        public int getOccursValue() {
            return this.occursValue;
        }

        @Override
        public boolean visit(IntegerLiteral integerLiteral) {
            try {
                this.occursValue = Integer.parseInt(integerLiteral.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.haveIssuedError = true;
                this.reportSizeOutOfRangeError(integerLiteral, integerLiteral.getCanonicalString());
            }
            return false;
        }

        @Override
        public void endVisitExpression(Expression expression) {
            if (!this.haveIssuedError && this.occursValue < 1) {
                this.reportSizeNotIntegerError(expression, expression.getCanonicalString());
            }
        }

        protected void reportSizeNotIntegerError(Node errorNode, String canonicalExprString) {
            this.problemRequestor.acceptProblem(errorNode, 3253, new String[]{canonicalExprString});
        }

        protected void reportSizeOutOfRangeError(Node errorNode, String canonicalExprString) {
            this.problemRequestor.acceptProblem(errorNode, 4005, new String[]{canonicalExprString, this.canonicalItemName});
        }
    }
}

