/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AmbiguousFunctionBinding;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FileScope
extends Scope {
    private static final List systemPackages = new ArrayList();
    protected FileBinding fileBinding;
    private IPackageBinding[] importedPackages;
    private Map importedTypes = Collections.EMPTY_MAP;
    private IDependencyRequestor dependencyRequestor;
    private boolean returnTopLevelFunctions = true;

    public FileScope(Scope parentScope, FileBinding fileBinding, IDependencyRequestor dependencyRequestor) {
        super(parentScope);
        this.fileBinding = fileBinding;
        this.dependencyRequestor = dependencyRequestor;
        ArrayList allPackages = new ArrayList();
        allPackages.addAll(fileBinding.getPackageBindings());
        allPackages.addAll(systemPackages);
        this.importedPackages = allPackages.toArray(new IPackageBinding[fileBinding.getPackageBindings().size()]);
        List partBindings = fileBinding.getPartBindings();
        if (partBindings.size() > 0) {
            this.importedTypes = new HashMap();
        }
        for (IPartBinding partBinding : partBindings) {
            this.importedTypes.put(partBinding.getName(), partBinding);
        }
    }

    @Override
    public IDataBinding findData(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        if (this.returnTopLevelFunctions) {
            ITypeBinding type = this.findType(simpleName);
            if (type == IBinding.NOT_FOUND_BINDING) {
                return IBinding.NOT_FOUND_BINDING;
            }
            if (type == ITypeBinding.AMBIGUOUS_TYPE) {
                return AmbiguousFunctionBinding.getInstance();
            }
            if (type.getKind() != 20) {
                return IBinding.NOT_FOUND_BINDING;
            }
            IFunctionBinding functionBinding = (IFunctionBinding)type;
            this.dependencyRequestor.recordTopLevelFunctionBinding(functionBinding);
            return functionBinding;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        this.dependencyRequestor.recordSimpleName(simpleName);
        ITypeBinding result = null;
        result = this.findTypeUsingSingleTypeImports(simpleName);
        if (result != null) {
            return result;
        }
        result = this.findTypeInDeclaringPackage(simpleName);
        if (result != null) {
            return result;
        }
        result = this.findTypeInOnDemandImports(simpleName);
        return result == null ? IBinding.NOT_FOUND_BINDING : result;
    }

    protected ITypeBinding findTypeUsingSingleTypeImports(String simpleName) {
        ITypeBinding result;
        if (this.importedTypes != null && (result = (ITypeBinding)this.importedTypes.get(simpleName)) != null) {
            IPartBinding tempResult;
            if (!result.isValid() && (tempResult = this.fileBinding.getEnvironment().getPartBinding(result.getPackageName(), result.getName())) != result) {
                this.importedTypes.remove(simpleName);
                this.importedTypes.put(simpleName, tempResult);
                result = tempResult;
            }
            return result;
        }
        return null;
    }

    protected ITypeBinding findTypeInDeclaringPackage(String simpleName) {
        ITypeBinding result;
        IPackageBinding declaringPackage = this.fileBinding.getDeclaringPackage();
        if (declaringPackage != null && (result = declaringPackage.resolveType(simpleName)) != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        return null;
    }

    protected ITypeBinding findTypeInOnDemandImports(String simpleName) {
        ITypeBinding result = null;
        IPackageBinding declaringPackage = this.fileBinding.getDeclaringPackage();
        int i = 0;
        while (i < this.importedPackages.length) {
            ITypeBinding temp = this.importedPackages[i].resolveType(simpleName);
            if (temp != IBinding.NOT_FOUND_BINDING) {
                if (result != null) {
                    if (declaringPackage != null && ((IPartBinding)temp).getPackageName() == declaringPackage.getPackageName() || !((IPartBinding)temp).isPrivate()) {
                        if (result == IBinding.NOT_FOUND_BINDING) {
                            result = temp;
                        } else if (result.getPackageName() != temp.getPackageName()) {
                            return ITypeBinding.AMBIGUOUS_TYPE;
                        }
                    }
                } else {
                    result = declaringPackage != null && ((IPartBinding)temp).getPackageName() == declaringPackage.getPackageName() || !((IPartBinding)temp).isPrivate() ? temp : IBinding.NOT_FOUND_BINDING;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public void stopReturningTopLevelFunctions() {
        super.stopReturningTopLevelFunctions();
        this.returnTopLevelFunctions = false;
    }

    @Override
    public boolean isReturningTopLevelFunctions() {
        return this.returnTopLevelFunctions;
    }

    @Override
    public void startReturningTopLevelFunctions() {
        super.startReturningTopLevelFunctions();
        this.returnTopLevelFunctions = true;
    }
}

