/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NotFoundBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;

public class FunctionResolver {
    protected ICompilerOptions compilerOptions;

    public FunctionResolver(ICompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public IDataBinding findMatchingFunction(OverloadedFunctionSet functionSet, List functionArgumentTypes) {
        return this.findMatchingFunction(functionSet, functionArgumentTypes, new boolean[functionArgumentTypes.size()]);
    }

    public IDataBinding findMatchingFunction(OverloadedFunctionSet functionSet, List functionArgumentTypes, boolean[] argIsLiteral) {
        return this.findMatchingFunction(functionSet, functionArgumentTypes, argIsLiteral, true);
    }

    public IDataBinding findMatchingFunction(OverloadedFunctionSet functionSet, List functionArgumentTypes, boolean returnFirstFunctionIfNoneFound) {
        return this.findMatchingFunction(functionSet, functionArgumentTypes, new boolean[functionArgumentTypes.size()], returnFirstFunctionIfNoneFound);
    }

    public IDataBinding findMatchingFunction(OverloadedFunctionSet functionSet, List functionArgumentTypes, final boolean[] argIsLiteral, boolean returnFirstFunctionIfNoneFound) {
        IFunctionBinding fBinding;
        functionSet = functionSet.trimFunctionsWithIdenticalSignatures(this.compilerOptions);
        NotFoundBinding firstFunction = returnFirstFunctionIfNoneFound ? (IDataBinding)functionSet.getNestedFunctionBindings().get(0) : IBinding.NOT_FOUND_BINDING;
        ArrayList nestedFunctionBindings = new ArrayList();
        nestedFunctionBindings.addAll(functionSet.getNestedFunctionBindings());
        Iterator iter = nestedFunctionBindings.iterator();
        while (iter.hasNext()) {
            IDataBinding dBinding = (IDataBinding)iter.next();
            fBinding = (IFunctionBinding)dBinding.getType();
            if (this.validNumberOfArgs(fBinding, functionArgumentTypes.size())) continue;
            iter.remove();
        }
        if (nestedFunctionBindings.isEmpty()) {
            return firstFunction;
        }
        if (nestedFunctionBindings.size() == 1) {
            return (IDataBinding)nestedFunctionBindings.get(0);
        }
        for (IDataBinding dBinding : nestedFunctionBindings) {
            fBinding = (IFunctionBinding)dBinding.getType();
            boolean allArgsMatch = true;
            int limit = this.min(functionArgumentTypes.size(), fBinding.getParameters().size());
            int i = 0;
            while (i < limit) {
                ITypeBinding argType = (ITypeBinding)functionArgumentTypes.get(i);
                ITypeBinding parmType = ((IDataBinding)fBinding.getParameters().get(i)).getType();
                if (argType == null || parmType == null || !TypeCompatibilityUtil.typesAreIdentical(argType, parmType, this.compilerOptions)) {
                    allArgsMatch = false;
                    break;
                }
                ++i;
            }
            if (!allArgsMatch) continue;
            return dBinding;
        }
        IDataBinding bestFittingFunction = this.getBestFittingFunction(nestedFunctionBindings, functionArgumentTypes, new IArgumentCompatibilityRules(){

            @Override
            public int getScoreForInOrOutParameter(int argNum, ITypeBinding argumentType, ITypeBinding parameterType, ICompilerOptions compilerOptions) {
                int valueWideningDistance = TypeCompatibilityUtil.valueWideningDistance(argumentType, parameterType, compilerOptions);
                if (valueWideningDistance < 0 && argIsLiteral[argNum]) {
                    valueWideningDistance = TypeCompatibilityUtil.valueWideningDistance(parameterType, argumentType, compilerOptions);
                }
                return valueWideningDistance;
            }

            @Override
            public int getScoreForInOutParameter(int argNum, ITypeBinding argumentType, ITypeBinding parameterType, ICompilerOptions compilerOptions) {
                return argIsLiteral[argNum] ? TypeCompatibilityUtil.valueWideningDistance(argumentType, parameterType, compilerOptions) : TypeCompatibilityUtil.referenceWideningDistance(argumentType, parameterType, compilerOptions);
            }
        });
        if (bestFittingFunction != null) {
            return bestFittingFunction;
        }
        bestFittingFunction = this.getBestFittingFunction(nestedFunctionBindings, functionArgumentTypes, new IArgumentCompatibilityRules(){

            @Override
            public int getScoreForInOrOutParameter(int argNum, ITypeBinding argumentType, ITypeBinding parameterType, ICompilerOptions compilerOptions) {
                int valueWideningDistance = TypeCompatibilityUtil.valueWideningDistance(parameterType, argumentType, compilerOptions);
                if (valueWideningDistance < 0 && argIsLiteral[argNum]) {
                    valueWideningDistance = TypeCompatibilityUtil.valueWideningDistance(argumentType, parameterType, compilerOptions);
                }
                return valueWideningDistance;
            }

            @Override
            public int getScoreForInOutParameter(int argNum, ITypeBinding argumentType, ITypeBinding parameterType, ICompilerOptions compilerOptions) {
                if (TypeCompatibilityUtil.isReferenceCompatible(parameterType, argumentType, compilerOptions)) {
                    return 1;
                }
                return argIsLiteral[argNum] ? TypeCompatibilityUtil.valueWideningDistance(argumentType, parameterType, compilerOptions) : TypeCompatibilityUtil.referenceWideningDistance(argumentType, parameterType, compilerOptions);
            }
        });
        if (bestFittingFunction != null) {
            return bestFittingFunction;
        }
        bestFittingFunction = this.getBestFittingFunction(nestedFunctionBindings, functionArgumentTypes, new IArgumentCompatibilityRules(){

            @Override
            public int getScoreForInOrOutParameter(int argNum, ITypeBinding argumentType, ITypeBinding parameterType, ICompilerOptions compilerOptions) {
                return TypeCompatibilityUtil.isMoveCompatible(parameterType, argumentType, null, compilerOptions) ? 1 : -1;
            }

            @Override
            public int getScoreForInOutParameter(int argNum, ITypeBinding argumentType, ITypeBinding parameterType, ICompilerOptions compilerOptions) {
                if (3 == argumentType.getKind() && !argumentType.isNullable()) {
                    PrimitiveTypeBinding primitiveTypeBinding = (PrimitiveTypeBinding)argumentType;
                    Primitive prim = primitiveTypeBinding.getPrimitive();
                    if (Primitive.STRING == prim) {
                        argumentType = PrimitiveTypeBinding.getInstance(Primitive.CHAR, primitiveTypeBinding.getLength());
                    }
                    if (TypeCompatibilityUtil.isReferenceCompatible(parameterType, argumentType, compilerOptions)) {
                        return 1;
                    }
                    return TypeCompatibilityUtil.referenceWideningDistance(argumentType, parameterType, compilerOptions);
                }
                return -1;
            }
        });
        if (bestFittingFunction != null) {
            return bestFittingFunction;
        }
        IDataBinding iDataBinding = firstFunction = returnFirstFunctionIfNoneFound && !nestedFunctionBindings.isEmpty() ? (IDataBinding)nestedFunctionBindings.get(0) : IBinding.NOT_FOUND_BINDING;
        if (nestedFunctionBindings.size() == 1) {
            return (IDataBinding)nestedFunctionBindings.get(0);
        }
        return firstFunction;
    }

    private boolean validNumberOfArgs(IFunctionBinding functionBinding, int numArgs) {
        int[] validArgs = functionBinding.getValidNumbersOfArguments();
        if (validArgs.length == 1) {
            return validArgs[0] == numArgs;
        }
        if (validArgs.length == 2 && validArgs[0] < 0) {
            return numArgs >= validArgs[1];
        }
        int i = 0;
        while (i < validArgs.length) {
            if (validArgs[i] == numArgs) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IDataBinding getBestFittingFunction(List nestedFunctionBindings, List functionArgumentTypes, IArgumentCompatibilityRules compatibilityRules) {
        IDataBinding bestFittingFunction = null;
        int[] bestArgumentScore = null;
        Iterator iter = nestedFunctionBindings.iterator();
        while (iter.hasNext()) {
            IDataBinding dBinding = (IDataBinding)iter.next();
            IFunctionBinding fBinding = (IFunctionBinding)dBinding.getType();
            int limit = this.min(fBinding.getParameters().size(), functionArgumentTypes.size());
            int[] currentArgumentScore = new int[limit];
            int i = 0;
            while (i < limit) {
                ITypeBinding argType = (ITypeBinding)functionArgumentTypes.get(i);
                if (argType == null) {
                    currentArgumentScore[i] = 0;
                } else {
                    FunctionParameterBinding parmBinding = (FunctionParameterBinding)fBinding.getParameters().get(i);
                    ITypeBinding parmType = parmBinding.getType();
                    currentArgumentScore[i] = parmBinding.isInput() || parmBinding.isOutput() ? compatibilityRules.getScoreForInOrOutParameter(i, argType, parmType, this.compilerOptions) : compatibilityRules.getScoreForInOutParameter(i, argType, parmType, this.compilerOptions);
                }
                ++i;
            }
            if (!this.allElementsPostive(currentArgumentScore)) continue;
            if (bestArgumentScore == null) {
                bestArgumentScore = currentArgumentScore;
                bestFittingFunction = dBinding;
                continue;
            }
            if (this.allElementsLessThan(currentArgumentScore, bestArgumentScore)) {
                bestArgumentScore = currentArgumentScore;
                bestFittingFunction = dBinding;
                continue;
            }
            if (!this.allElementsEqual(currentArgumentScore, bestArgumentScore) || iter.hasNext()) continue;
            return AmbiguousDataBinding.getInstance();
        }
        return bestFittingFunction;
    }

    private int min(int int1, int int2) {
        if (int1 < int2) {
            return int1;
        }
        return int2;
    }

    private boolean allElementsLessThan(int[] srcArray, int[] targetAry) {
        boolean allElementsEqual = true;
        int limit = this.min(srcArray.length, targetAry.length);
        int i = 0;
        while (i < limit) {
            if (allElementsEqual && srcArray[i] != targetAry[i]) {
                allElementsEqual = false;
            }
            if (srcArray[i] > targetAry[i]) {
                return false;
            }
            ++i;
        }
        return !allElementsEqual;
    }

    private boolean allElementsEqual(int[] srcArray, int[] targetAry) {
        int limit = this.min(srcArray.length, targetAry.length);
        int i = 0;
        while (i < limit) {
            if (srcArray[i] != targetAry[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean allElementsPostive(int[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static interface IArgumentCompatibilityRules {
        public int getScoreForInOrOutParameter(int var1, ITypeBinding var2, ITypeBinding var3, ICompilerOptions var4);

        public int getScoreForInOutParameter(int var1, ITypeBinding var2, ITypeBinding var3, ICompilerOptions var4);
    }
}

