/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.HandlerBindingCompletor;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerBinder;
import org.eclipse.edt.compiler.internal.core.lookup.HandlerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class HandlerBinder
extends FunctionContainerBinder {
    private HandlerBinding handlerBinding;
    private Scope fileScope;

    public HandlerBinder(HandlerBinding handlerBinding, Scope fileScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(handlerBinding, fileScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.handlerBinding = handlerBinding;
        this.fileScope = fileScope;
    }

    @Override
    public boolean visit(Handler handler) {
        handler.accept(new HandlerBindingCompletor(this.fileScope, this.handlerBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.currentScope = new HandlerScope(this.currentScope, this.handlerBinding);
        this.preprocessPart(handler);
        return true;
    }

    @Override
    public void endVisit(Handler handler) {
        this.doneVisitingPart();
    }

    @Override
    protected boolean isPageHandler() {
        return this.handlerBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "JSFHandler") != null;
    }

    @Override
    protected void doneVisitingPart() {
        super.doneVisitingPart();
        IAnnotationBinding jsfHandlerABinding = this.handlerBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "JSFHandler");
        if (jsfHandlerABinding != null) {
            IFunctionBinding validatorFunctionBinding;
            IAnnotationBinding validatorFunctionAnnotation = (IAnnotationBinding)jsfHandlerABinding.findData("validatorFunction");
            HashSet<IFunctionBinding> validatorFunctions = new HashSet<IFunctionBinding>();
            if (validatorFunctionAnnotation != IBinding.NOT_FOUND_BINDING && (validatorFunctionBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && validatorFunctionBinding.isPartBinding()) {
                validatorFunctions.add(validatorFunctionBinding);
            }
            for (IDataBinding dBinding : this.handlerBinding.getDeclaredData()) {
                IFunctionBinding onValueChangeBinding;
                IFunctionBinding validatorFunctionBinding2;
                ITypeBinding tBinding = dBinding.getType().getBaseType();
                validatorFunctionAnnotation = dBinding.getAnnotation(new String[]{"egl", "ui"}, "validatorFunction");
                if (validatorFunctionAnnotation != null && (validatorFunctionBinding2 = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && validatorFunctionBinding2.isPartBinding()) {
                    validatorFunctions.add(validatorFunctionBinding2);
                }
                if ((validatorFunctionAnnotation = dBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "onValueChangeFunction")) != null && (onValueChangeBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && onValueChangeBinding.isPartBinding()) {
                    validatorFunctions.add(onValueChangeBinding);
                }
                if ((validatorFunctionAnnotation = dBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "typeAheadFunction")) != null && (onValueChangeBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && onValueChangeBinding.isPartBinding()) {
                    validatorFunctions.add(onValueChangeBinding);
                }
                this.addValidatorFunctions(validatorFunctions, tBinding);
            }
            Iterator iter2 = validatorFunctions.iterator();
            while (iter2.hasNext()) {
                this.dependencyRequestor.recordTopLevelFunctionBinding((IFunctionBinding)iter2.next());
            }
        }
    }

    private void addValidatorFunctions(Set functionBindings, ITypeBinding tBinding) {
        block2: {
            block3: {
                if (tBinding == null || IBinding.NOT_FOUND_BINDING == tBinding) break block2;
                if (6 != tBinding.getKind()) break block3;
                Iterator iter2 = ((FixedRecordBinding)tBinding).getStructureItems().iterator();
                while (iter2.hasNext()) {
                    this.addValidatorFunctions(functionBindings, (StructureItemBinding)iter2.next());
                }
                break block2;
            }
            if (7 != tBinding.getKind()) break block2;
            Iterator iter2 = ((FlexibleRecordBinding)tBinding).getDeclaredFields().iterator();
            while (iter2.hasNext()) {
                this.addValidatorFunctions(functionBindings, (FlexibleRecordFieldBinding)iter2.next());
            }
        }
    }

    private void addValidatorFunctions(Set functionBindings, StructureItemBinding sItemBinding) {
        List children = sItemBinding.getChildren();
        if (children.isEmpty()) {
            this.primAddValidatorFunctions(functionBindings, sItemBinding);
        } else {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                this.addValidatorFunctions(functionBindings, (StructureItemBinding)iter.next());
            }
        }
    }

    private void addValidatorFunctions(Set functionBindings, FlexibleRecordFieldBinding sItemBinding) {
        this.primAddValidatorFunctions(functionBindings, sItemBinding);
        ITypeBinding tBinding = sItemBinding.getType();
        this.addValidatorFunctions(functionBindings, tBinding);
    }

    private void primAddValidatorFunctions(Set functionBindings, IDataBinding sItemBinding) {
        IFunctionBinding onValueChangeBinding;
        IFunctionBinding validatorFunctionBinding;
        IAnnotationBinding validatorFunctionAnnotation = sItemBinding.getAnnotation(new String[]{"egl", "ui"}, "validatorFunction");
        if (validatorFunctionAnnotation != null && (validatorFunctionBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && validatorFunctionBinding.isPartBinding()) {
            functionBindings.add(validatorFunctionBinding);
        }
        if ((validatorFunctionAnnotation = sItemBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "onValueChangeFunction")) != null && (onValueChangeBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && onValueChangeBinding.isPartBinding()) {
            functionBindings.add(onValueChangeBinding);
        }
        if ((validatorFunctionAnnotation = sItemBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "typeAheadFunction")) != null && (onValueChangeBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING && onValueChangeBinding.isPartBinding()) {
            functionBindings.add(onValueChangeBinding);
        }
    }

    @Override
    public boolean visit(Constructor constructor) {
        IFunctionBinding functionBinding = (IFunctionBinding)constructor.getBinding().getType();
        if (functionBinding != null) {
            FunctionBinder functionBinder = new FunctionBinder(this.handlerBinding, functionBinding, this.currentScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            constructor.accept(functionBinder);
        }
        return false;
    }
}

